/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain.impl;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.configservice.XmlLoader;
import com.pingidentity.crypto.jwk.JwkFacilitator;
import com.pingidentity.x2017.x07.jwksEndpoint.CustomRSAKeyIdsType;
import com.pingidentity.x2017.x07.jwksEndpoint.JWKSSigningKeys;
import com.pingidentity.x2017.x07.jwksEndpoint.SigningJWKSInstanceType;
import com.pingidentity.x2017.x07.jwksEndpoint.SigningJWKSInstancesConfigType;
import com.pingidentity.x2017.x07.jwksEndpoint.SigningJWKSInstancesConfigTypeDocument;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.IDGenerator;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.oauth20.domain.JwksRsaManagerHelper;
import org.sourceid.oauth20.domain.JwksSigningInstanceSettings;
import org.sourceid.oauth20.domain.JwksSigningKeySetsManager;
import org.sourceid.oauth20.domain.OidcJwksSet;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;

public class JwksSigningKeySetsManagerImpl
implements JwksSigningKeySetsManager,
AutoReloadable {
    private final XmlLoader xmlLoader;
    private final String directory;
    private List<JwksSigningInstanceSettings> jWKSSigningInstanceSettings;
    private static final String FILENAME_SIGNING_KEY_GROUPS = "jwks-signing-group.xml";

    public JwksSigningKeySetsManagerImpl(XmlLoader xmlLoader, SysDirInfo sysDirInfo) {
        this.xmlLoader = xmlLoader;
        this.directory = sysDirInfo.getDataDirectory();
        this.loadSigningJWKSGroupInstances();
    }

    private synchronized void loadSigningJWKSGroupInstances() {
        this.jWKSSigningInstanceSettings = new ArrayList<JwksSigningInstanceSettings>();
        SigningJWKSInstancesConfigTypeDocument doc = this.getSigningJWKSGroupInstances();
        SigningJWKSInstancesConfigType configType = doc.getSigningJWKSInstancesConfigType();
        SigningJWKSInstanceType[] signingJWKSInstances = configType.getSigningJWKSInstanceTypeArray();
        if (signingJWKSInstances != null && signingJWKSInstances.length > 0) {
            for (SigningJWKSInstanceType signingJWKSInstance : signingJWKSInstances) {
                JwksSigningInstanceSettings jWKSSigningGroupInstance = new JwksSigningInstanceSettings();
                jWKSSigningGroupInstance.setId(signingJWKSInstance.getId());
                jWKSSigningGroupInstance.setName(signingJWKSInstance.getName());
                jWKSSigningGroupInstance.setDescription(signingJWKSInstance.getDescription());
                OidcJwksSet oidcJWKSSet = new OidcJwksSet();
                jWKSSigningGroupInstance.setOidcJWKSSigningKeySet(oidcJWKSSet);
                this.loadSigningKeySet(signingJWKSInstance.getJWKSSigningKeys(), jWKSSigningGroupInstance.getOidcJWKSSigningKeySet());
                HashSet<String> issuerIds = new HashSet<String>();
                if (signingJWKSInstance.getIssuerIdsArray() != null && signingJWKSInstance.getIssuerIdsArray().length > 0) {
                    Collections.addAll(issuerIds, signingJWKSInstance.getIssuerIdsArray());
                }
                jWKSSigningGroupInstance.setIssuerIds(issuerIds);
                this.jWKSSigningInstanceSettings.add(jWKSSigningGroupInstance);
            }
        }
    }

    @Override
    public synchronized List<JwksSigningInstanceSettings> getAllKeySets() {
        return this.jWKSSigningInstanceSettings;
    }

    @Override
    public synchronized JwksSigningInstanceSettings getKeySet(String id) {
        JwksSigningInstanceSettings jwkSet = null;
        if (StringUtils.isNotEmpty((String)id)) {
            for (JwksSigningInstanceSettings instance : this.jWKSSigningInstanceSettings) {
                if (!id.equals(instance.getId())) continue;
                jwkSet = instance;
            }
        }
        return jwkSet;
    }

    @Override
    public synchronized JwksSigningInstanceSettings saveKeySet(JwksSigningInstanceSettings jWKSSigningInstance) {
        if (jWKSSigningInstance == null) {
            return null;
        }
        List existingJWKSSigningSets = this.jWKSSigningInstanceSettings.stream().collect(Collectors.toList());
        ArrayList<JwksSigningInstanceSettings> newJWKSSigningSets = new ArrayList<JwksSigningInstanceSettings>();
        String id = jWKSSigningInstance.getId();
        if (StringUtils.isEmpty((String)id)) {
            id = IDGenerator.rndAlphaNumeric(22);
            jWKSSigningInstance.setId(id);
        }
        AdminAuditLogger.Event event = AdminAuditLogger.Event.MODIFY;
        if (this.getKeySet(id) == null) {
            newJWKSSigningSets.addAll(existingJWKSSigningSets);
            newJWKSSigningSets.add(jWKSSigningInstance);
            event = AdminAuditLogger.Event.CREATE;
        } else {
            for (JwksSigningInstanceSettings instance : Collections.unmodifiableList(existingJWKSSigningSets)) {
                if (instance.getId().equals(jWKSSigningInstance.getId())) {
                    newJWKSSigningSets.add(jWKSSigningInstance);
                    event = AdminAuditLogger.Event.MODIFY;
                    continue;
                }
                newJWKSSigningSets.add(instance);
            }
        }
        try (AuditLoggerScope scope = new AuditLoggerScope();){
            this.saveKeySet(newJWKSSigningSets);
            scope.log(AdminAuditLogger.Component.OAUTH_OIDC_KEY_SETS, event, id);
        }
        return this.getKeySet(id);
    }

    @Override
    public synchronized void saveKeySet(List<JwksSigningInstanceSettings> jWKSSigningInstanceSettings) {
        SigningJWKSInstancesConfigTypeDocument doc = SigningJWKSInstancesConfigTypeDocument.Factory.newInstance();
        SigningJWKSInstancesConfigType configType = doc.addNewSigningJWKSInstancesConfigType();
        for (JwksSigningInstanceSettings instance : jWKSSigningInstanceSettings) {
            SigningJWKSInstanceType xmlInstance = configType.addNewSigningJWKSInstanceType();
            xmlInstance.setId(instance.getId());
            xmlInstance.setName(instance.getName());
            xmlInstance.setDescription(instance.getDescription());
            this.populateSigningKeysXML(instance.getOidcJWKSSigningKeySet(), xmlInstance.addNewJWKSSigningKeys());
            if (instance.getIssuerIds() == null || instance.getIssuerIds().isEmpty()) continue;
            String[] issuersXml = new String[instance.getIssuerIds().size()];
            int index = 0;
            Iterator<String> iterator = instance.getIssuerIds().iterator();
            while (iterator.hasNext()) {
                String issuer;
                issuersXml[index] = issuer = iterator.next();
                ++index;
            }
            xmlInstance.setIssuerIdsArray(issuersXml);
        }
        this.xmlLoader.save(this.directory, FILENAME_SIGNING_KEY_GROUPS, (XmlObject)doc);
        this.loadSigningJWKSGroupInstances();
        GlobalRegistry.getService(JwkFacilitator.class).createKeys();
    }

    private synchronized SigningJWKSInstancesConfigTypeDocument getSigningJWKSGroupInstances() {
        SigningJWKSInstancesConfigTypeDocument doc;
        if (this.xmlLoader.xmlExists(this.directory, FILENAME_SIGNING_KEY_GROUPS)) {
            XmlObject xmlObject = this.xmlLoader.load(this.directory, FILENAME_SIGNING_KEY_GROUPS);
            doc = (SigningJWKSInstancesConfigTypeDocument)xmlObject;
        } else {
            doc = SigningJWKSInstancesConfigTypeDocument.Factory.newInstance();
            doc.addNewSigningJWKSInstancesConfigType();
        }
        return doc;
    }

    @Override
    public synchronized void deleteKeySet(String id) {
        if (id == null) {
            return;
        }
        ArrayList<JwksSigningInstanceSettings> newJWKSSigningSets = new ArrayList<JwksSigningInstanceSettings>();
        boolean exists = false;
        for (JwksSigningInstanceSettings instance : this.jWKSSigningInstanceSettings) {
            if (instance.getId().equals(id)) {
                exists = true;
                continue;
            }
            newJWKSSigningSets.add(instance);
        }
        if (exists) {
            try (AuditLoggerScope scope = new AuditLoggerScope();){
                this.saveKeySet(newJWKSSigningSets);
                scope.log(AdminAuditLogger.Component.OAUTH_OIDC_KEY_SETS, AdminAuditLogger.Event.DELETE, id);
            }
        }
    }

    private void populateSigningKeysXML(OidcJwksSet setting, JWKSSigningKeys configType) {
        configType.setP256ActiveKey(setting.getP256ActiveId());
        configType.setP256PreviousKey(setting.getP256PreviousId());
        configType.setP256PublishX5CParameter(setting.isP256PublishX5cParameter());
        configType.setP256ActiveKeyId(setting.getP256ActiveKeyId());
        configType.setP256PreviousKeyId(setting.getP256PreviousKeyId());
        configType.setP384ActiveKey(setting.getP384ActiveId());
        configType.setP384PreviousKey(setting.getP384PreviousId());
        configType.setP384PublishX5CParameter(setting.isP384PublishX5cParameter());
        configType.setP384ActiveKeyId(setting.getP384ActiveKeyId());
        configType.setP384PreviousKeyId(setting.getP384PreviousKeyId());
        configType.setP521ActiveKey(setting.getP521ActiveId());
        configType.setP521PreviousKey(setting.getP521PreviousId());
        configType.setP521PublishX5CParameter(setting.isP521PublishX5cParameter());
        configType.setP521ActiveKeyId(setting.getP521ActiveKeyId());
        configType.setP521PreviousKeyId(setting.getP521PreviousKeyId());
        configType.setRsaActiveKey(setting.getRsaActiveId());
        configType.setRsaPreviousKey(setting.getRsaPreviousId());
        configType.setRsaPublishX5CParameter(setting.isRsaPublishX5cParameter());
        configType.setRsaActiveKeyId(setting.getRsaActiveKeyId());
        configType.setRsaPreviousKeyId(setting.getRsaPreviousKeyId());
        CustomRSAKeyIdsType customRsaPreviousKeyIdsType = configType.getCustomRsaPreviousKeyIds() == null ? configType.addNewCustomRsaPreviousKeyIds() : configType.getCustomRsaPreviousKeyIds();
        CustomRSAKeyIdsType customRsaActiveKeyIdsType = configType.getCustomRsaActiveKeyIds() == null ? configType.addNewCustomRsaActiveKeyIds() : configType.getCustomRsaActiveKeyIds();
        JwksRsaManagerHelper.addRsaCustomAlgToKeyIdMap(customRsaActiveKeyIdsType, customRsaPreviousKeyIdsType, setting);
    }

    private void loadSigningKeySet(JWKSSigningKeys configType, OidcJwksSet jWKSEndpointSetting) {
        jWKSEndpointSetting.setP256ActiveId(configType.getP256ActiveKey());
        jWKSEndpointSetting.setP256PreviousId(configType.getP256PreviousKey());
        jWKSEndpointSetting.setP256PublishX5cParameter(configType.getP256PublishX5CParameter());
        jWKSEndpointSetting.setP256ActiveKeyId(configType.getP256ActiveKeyId());
        jWKSEndpointSetting.setP256PreviousKeyId(configType.getP256PreviousKeyId());
        jWKSEndpointSetting.setP384ActiveId(configType.getP384ActiveKey());
        jWKSEndpointSetting.setP384PreviousId(configType.getP384PreviousKey());
        jWKSEndpointSetting.setP384PublishX5cParameter(configType.getP384PublishX5CParameter());
        jWKSEndpointSetting.setP384ActiveKeyId(configType.getP384ActiveKeyId());
        jWKSEndpointSetting.setP384PreviousKeyId(configType.getP384PreviousKeyId());
        jWKSEndpointSetting.setP521ActiveId(configType.getP521ActiveKey());
        jWKSEndpointSetting.setP521PreviousId(configType.getP521PreviousKey());
        jWKSEndpointSetting.setP521PublishX5cParameter(configType.getP521PublishX5CParameter());
        jWKSEndpointSetting.setP521ActiveKeyId(configType.getP521ActiveKeyId());
        jWKSEndpointSetting.setP521PreviousKeyId(configType.getP521PreviousKeyId());
        jWKSEndpointSetting.setRsaActiveId(configType.getRsaActiveKey());
        jWKSEndpointSetting.setRsaPreviousId(configType.getRsaPreviousKey());
        jWKSEndpointSetting.setRsaPublishX5cParameter(configType.getRsaPublishX5CParameter());
        jWKSEndpointSetting.setRsaActiveKeyId(configType.getRsaActiveKeyId());
        jWKSEndpointSetting.setRsaPreviousKeyId(configType.getRsaPreviousKeyId());
        Map<String, String> rsaAlgActiveCustomKid = JwksRsaManagerHelper.populateRsaAlgKeyIdMap(configType.getCustomRsaActiveKeyIds());
        jWKSEndpointSetting.setRsaAlgTypesActiveCustomKeyIds(rsaAlgActiveCustomKid);
        Map<String, String> rsaAlgPreviousCustomKid = JwksRsaManagerHelper.populateRsaAlgKeyIdMap(configType.getCustomRsaPreviousKeyIds());
        jWKSEndpointSetting.setRsaAlgTypesPreviousCustomKeyIds(rsaAlgPreviousCustomKid);
    }
}

