/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.exchange.domain;

import com.pingidentity.common.domain.WithDefaultInstanceSupport;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorPolicy;

public class TokenExchangeProcessorPolicies
implements WithDefaultInstanceSupport<String> {
    private Map<String, TokenExchangeProcessorPolicy> policies = new LinkedHashMap<String, TokenExchangeProcessorPolicy>();
    private String defaultInstanceId;

    public void addPolicy(TokenExchangeProcessorPolicy tokenExchangeProcessorPolicy) {
        this.policies.put(tokenExchangeProcessorPolicy.getId(), tokenExchangeProcessorPolicy);
    }

    public void removePolicy(String id) {
        this.policies.remove(id);
    }

    public TokenExchangeProcessorPolicy getPolicy(String id) {
        return this.policies.get(id);
    }

    public Set<String> getPolicyIds() {
        return this.policies.keySet();
    }

    public Set<String> getPolicyNames() {
        return this.policies.values().stream().map(TokenExchangeProcessorPolicy::getName).collect(Collectors.toSet());
    }

    public Map<String, TokenExchangeProcessorPolicy> getPolicies() {
        return this.policies;
    }

    public void setPolicies(Map<String, TokenExchangeProcessorPolicy> policies) {
        this.policies = policies;
    }

    @Override
    public boolean hasDefaultInstanceId() {
        return StringUtils.isNotBlank((String)this.defaultInstanceId);
    }

    @Override
    public String getDefaultInstanceId() {
        return this.defaultInstanceId;
    }

    @Override
    public void setDefaultInstanceId(String defaultInstanceId) {
        this.defaultInstanceId = defaultInstanceId;
    }

    @Override
    public boolean containsConfigureInstances() {
        return !this.policies.isEmpty();
    }

    @Override
    public boolean containsInstance(String id) {
        return this.policies.containsKey(id);
    }
}

