/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.exchange.manager.impl;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.configservice.XmlLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.oauth.token.exchange.xmlbinding.TokenExchangeGeneratorMappingType;
import org.sourceid.oauth.token.exchange.xmlbinding.TokenExchangeGeneratorPoliciesDocument;
import org.sourceid.oauth.token.exchange.xmlbinding.TokenExchangeGeneratorPoliciesType;
import org.sourceid.oauth.token.exchange.xmlbinding.TokenExchangeGeneratorPolicyType;
import org.sourceid.oauth20.exchange.domain.TokenExchangeGeneratorMapping;
import org.sourceid.oauth20.exchange.domain.TokenExchangeGeneratorPolicies;
import org.sourceid.oauth20.exchange.domain.TokenExchangeGeneratorPolicy;
import org.sourceid.oauth20.exchange.manager.TokenExchangeGeneratorPolicyManager;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;

public class TokenExchangeGeneratorPolicyManagerImpl
implements TokenExchangeGeneratorPolicyManager,
AutoReloadable {
    private static final Logger logger = LogManager.getLogger(TokenExchangeGeneratorPolicyManagerImpl.class);
    private static final String FILENAME = "token-exchange-generator-policy.xml";
    private XmlLoader xmlLoader;
    private String directory;
    private TokenExchangeGeneratorPolicies tokenExchangeGeneratorPolicies;

    public TokenExchangeGeneratorPolicyManagerImpl(XmlLoader xmlLoader, SysDirInfo sysDirInfo) {
        this.xmlLoader = xmlLoader;
        this.directory = sysDirInfo.getDataDirectory();
        this.loadConfig();
    }

    @Override
    public synchronized TokenExchangeGeneratorPolicies getTokenExchangeGeneratorPolicies() {
        return this.tokenExchangeGeneratorPolicies;
    }

    @Override
    public synchronized void saveTokenExchangeGeneratorPolicies(TokenExchangeGeneratorPolicies toSave) {
        AdminAuditLogger.Event event;
        this.loadConfig();
        TokenExchangeGeneratorPolicies existingTokenExchangeGeneratorPolicies = this.getTokenExchangeGeneratorPolicies();
        String message = null;
        if (toSave.getPolicies().size() == existingTokenExchangeGeneratorPolicies.getPolicies().size()) {
            event = AdminAuditLogger.Event.MODIFY;
            if (toSave.getDefaultInstanceId() != null && existingTokenExchangeGeneratorPolicies.getDefaultInstanceId() != null && !toSave.getDefaultInstanceId().equals(existingTokenExchangeGeneratorPolicies.getDefaultInstanceId())) {
                message = "Default instance modified to " + toSave.getDefaultInstanceId();
            }
        } else {
            event = toSave.getPolicies().size() > existingTokenExchangeGeneratorPolicies.getPolicies().size() ? AdminAuditLogger.Event.CREATE : AdminAuditLogger.Event.DELETE;
        }
        TokenExchangeGeneratorPoliciesDocument doc = TokenExchangeGeneratorPoliciesDocument.Factory.newInstance();
        TokenExchangeGeneratorPoliciesType policiesType = doc.addNewTokenExchangeGeneratorPolicies();
        if (toSave.getPolicies().isEmpty()) {
            policiesType.setDefaultTokenExchangeGeneratorPolicyId(null);
        } else {
            policiesType.setDefaultTokenExchangeGeneratorPolicyId(toSave.getDefaultInstanceId());
        }
        for (TokenExchangeGeneratorPolicy tegp : toSave.getPolicies().values()) {
            TokenExchangeGeneratorPolicyType tegpType = policiesType.addNewTokenExchangeGeneratorPolicy();
            tegpType.setId(tegp.getId());
            tegpType.setName(tegp.getName());
            tegpType.setResourceUriArray(tegp.getResourceUris().toArray(new String[0]));
            tegpType.setDefaultTokenType(tegp.getDefaultTokenType());
            for (TokenExchangeGeneratorMapping mapping : tegp.getMappings()) {
                TokenExchangeGeneratorMappingType mappingType = tegpType.addNewTokenExchangeGeneratorTypeMapping();
                mappingType.setTokenType(mapping.getTokenType());
                mappingType.setTokenGeneratorId(mapping.getTokenGeneratorId());
            }
        }
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.xmlLoader.save(this.directory, FILENAME, (XmlObject)doc);
            auditLoggerScope.log(AdminAuditLogger.Component.OAUTH_TOKEN_EXCHANGE_GENERATOR_POLICY, event, message);
        }
        this.loadConfig();
    }

    @Override
    public synchronized Set<String> getAllResourceUris() {
        return this.tokenExchangeGeneratorPolicies.getPolicies().values().stream().flatMap(policy -> policy.getResourceUris().stream()).collect(Collectors.toSet());
    }

    @Override
    public synchronized TokenExchangeGeneratorPolicy getDefaultPolicy() {
        TokenExchangeGeneratorPolicy result = null;
        if (this.tokenExchangeGeneratorPolicies.containsConfigureInstances() && this.tokenExchangeGeneratorPolicies.hasDefaultInstanceId()) {
            result = this.tokenExchangeGeneratorPolicies.getPolicy(this.tokenExchangeGeneratorPolicies.getDefaultInstanceId());
        }
        return result;
    }

    @Override
    public Set<TokenExchangeGeneratorPolicy> getPoliciesByResourceUri(String resourceUri) {
        if (StringUtils.isBlank((String)resourceUri)) {
            return Collections.emptySet();
        }
        return this.tokenExchangeGeneratorPolicies.getPolicies().values().stream().filter(policy -> policy.matchRequestedResource(resourceUri)).collect(Collectors.toSet());
    }

    @Override
    public List<TokenExchangeGeneratorPolicy> getPoliciesUsingGenerator(String generatorId) {
        return this.tokenExchangeGeneratorPolicies.getPolicies().values().stream().filter(policy -> policy.getMappings().stream().anyMatch(mapping -> generatorId.equals(mapping.getTokenGeneratorId()))).collect(Collectors.toList());
    }

    private synchronized void loadConfig() {
        TokenExchangeGeneratorPoliciesDocument doc;
        if (this.xmlLoader.xmlExists(this.directory, FILENAME)) {
            XmlObject xmlObject = this.xmlLoader.load(this.directory, FILENAME);
            doc = (TokenExchangeGeneratorPoliciesDocument)xmlObject;
        } else {
            doc = TokenExchangeGeneratorPoliciesDocument.Factory.newInstance();
            doc.addNewTokenExchangeGeneratorPolicies();
        }
        TokenExchangeGeneratorPolicies domain = new TokenExchangeGeneratorPolicies();
        TokenExchangeGeneratorPoliciesType tegpsType = doc.getTokenExchangeGeneratorPolicies();
        domain.setDefaultInstanceId(tegpsType.getDefaultTokenExchangeGeneratorPolicyId());
        for (TokenExchangeGeneratorPolicyType tegpType : tegpsType.getTokenExchangeGeneratorPolicyArray()) {
            TokenExchangeGeneratorPolicy tegp = new TokenExchangeGeneratorPolicy();
            tegp.setId(tegpType.getId());
            tegp.setName(tegpType.getName());
            tegp.setResourceUris(Arrays.asList(tegpType.getResourceUriArray()));
            tegp.setDefaultTokenType(tegpType.getDefaultTokenType());
            for (TokenExchangeGeneratorMappingType mappingType : tegpType.getTokenExchangeGeneratorTypeMappingArray()) {
                TokenExchangeGeneratorMapping mapping = new TokenExchangeGeneratorMapping();
                mapping.setTokenType(mappingType.getTokenType());
                mapping.setTokenGeneratorId(mappingType.getTokenGeneratorId());
                tegp.addMapping(mapping);
            }
            domain.addPolicy(tegp);
        }
        this.tokenExchangeGeneratorPolicies = domain;
    }
}

