/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers;

import org.sourceid.oauth20.handlers.GeneralOAuthError;
import org.sourceid.oauth20.handlers.HandlerUtil;
import org.sourceid.websso.profiles.RequestProcessingException;
import org.sourceid.websso.servlet.reqparam.InvalidRequestParameterException;
import org.sourceid.websso.servlet.reqparam.InvalidResourceParameterException;

public class AccessTokenRequestException
extends RequestProcessingException
implements GeneralOAuthError {
    private final Error error;
    private final int httpErrorCode;
    private boolean doAuditLog = true;

    public AccessTokenRequestException(Error error) {
        this(error, null, 400);
    }

    public AccessTokenRequestException(Error error, String s) {
        this(error, s, 400);
    }

    public AccessTokenRequestException(Error error, String s, boolean doAuditLog) {
        this(error, s, 400);
        this.doAuditLog = doAuditLog;
    }

    public AccessTokenRequestException(Error error, int httpErrorCode) {
        this(error, null, httpErrorCode);
    }

    public AccessTokenRequestException(Error error, String s, int httpErrorCode) {
        super(s);
        this.error = error;
        this.httpErrorCode = httpErrorCode;
    }

    public AccessTokenRequestException(Error error, String s, Throwable th) {
        super(s, th);
        this.error = error;
        this.httpErrorCode = 400;
    }

    public AccessTokenRequestException(InvalidRequestParameterException e) {
        this(e instanceof InvalidResourceParameterException ? Error.invalid_target : Error.invalid_request, e.getMessage(), e);
    }

    public Error getError() {
        return this.error;
    }

    @Override
    public String getErrorCode() {
        return this.error != null ? this.error.toString() : "";
    }

    @Override
    public Exception getActualException() {
        return this;
    }

    @Override
    public int getHttpErrorCode() {
        return this.httpErrorCode;
    }

    @Override
    public String getDescription() {
        return super.getMessage();
    }

    @Override
    public boolean isDoAuditLog() {
        return this.doAuditLog;
    }

    @Override
    public String getMessage() {
        return HandlerUtil.formatExceptionMessage(this.error, super.getMessage());
    }

    public static enum Error {
        invalid_request,
        invalid_client,
        invalid_grant,
        unauthorized_client,
        unsupported_grant_type,
        invalid_scope,
        invalid_authorization_details,
        unsupported_token_type,
        server_error,
        authorization_pending,
        access_denied,
        expired_token,
        expired_login_hint_token,
        unknown_user_id,
        missing_user_code,
        invalid_user_code,
        invalid_binding_message,
        slow_down,
        invalid_target,
        invalid_dpop_proof,
        use_dpop_nonce;

    }
}

