/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers;

import org.sourceid.oauth20.handlers.GeneralOAuthError;
import org.sourceid.oauth20.handlers.HandlerUtil;
import org.sourceid.websso.profiles.RequestProcessingException;
import org.sourceid.websso.servlet.reqparam.InvalidRequestParameterException;

public class AuthorizationRequestException
extends RequestProcessingException
implements GeneralOAuthError {
    Error error;

    public AuthorizationRequestException(Error error) {
        this(error, null);
    }

    public AuthorizationRequestException(Error error, String s) {
        super(s);
        this.error = error;
    }

    public AuthorizationRequestException(Error error, String s, Throwable e) {
        super(s, e);
        this.error = error;
    }

    public AuthorizationRequestException(InvalidRequestParameterException e) {
        this(Error.invalid_request, e.getMessage(), e);
    }

    public Error getError() {
        return this.error;
    }

    @Override
    public String getErrorCode() {
        return this.error != null ? this.error.toString() : "";
    }

    @Override
    public Exception getActualException() {
        return this;
    }

    @Override
    public String getDescription() {
        return super.getMessage();
    }

    @Override
    public String getMessage() {
        return HandlerUtil.formatExceptionMessage(this.error, super.getMessage());
    }

    public static enum Error {
        invalid_request,
        unauthorized_client,
        access_denied,
        unsupported_response_type,
        invalid_scope,
        invalid_authorization_details,
        server_error,
        temporarily_unavailable,
        interaction_required,
        login_required,
        account_selection_required,
        consent_required,
        invalid_request_uri,
        invalid_request_object,
        registration_not_supported,
        request_not_supported,
        request_uri_not_supported,
        invalid_target;

    }
}

