/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers;

import com.pingidentity.common.util.CrossSiteRequestForgeryHelper;
import com.pingidentity.sdk.api.authn.internal.InternalAuthnApiSupport;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import com.pingidentity.sdk.oauth20.Scope;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.ThreadContext;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.domain.UserAuthorizationConsentPageSetting;
import org.sourceid.oauth20.handlers.AuthorizationRequestException;
import org.sourceid.oauth20.handlers.OAuthResumableRequestHandlerBase;
import org.sourceid.oauth20.handlers.utils.AuthorizationProcessor;
import org.sourceid.oauth20.handlers.utils.ExternalAuthorizationProcessor;
import org.sourceid.oauth20.handlers.utils.PingFederateAuthorizationProcessor;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.oauth20.protocol.ResponseType;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.authn.AuthnApiCookielessUtils;
import org.sourceid.websso.authn.AuthnApiPolicyUtil;
import org.sourceid.websso.profiles.idp.AsAuditLogger;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public abstract class BaseAuthorizationRequestHandler
extends OAuthResumableRequestHandlerBase {
    public static final String OAUTH_OIDC_RETURN_SCOPE_CONFIG_STORE_NAME = "oauth-scope-settings";
    public static final String ALWAYS_RETURN_SCOPE_SETTING = "always-return-scope-for-authz-code";
    private static final ConfigStore oauthOidcScopesConfigStore = ConfigStoreFarm.getConfig("oauth-scope-settings");
    private final AuthnApiCookielessUtils authnApiCookielessUtils;

    public BaseAuthorizationRequestHandler() {
        this(AuthnApiCookielessUtils.newInstance());
    }

    public BaseAuthorizationRequestHandler(AuthnApiCookielessUtils authnApiCookielessUtils) {
        this.authnApiCookielessUtils = authnApiCookielessUtils;
    }

    protected abstract ClientManager getClientManager();

    protected final void validateCSRF(HttpServletRequest req, Map<String, Object> otherState) throws AuthorizationRequestException {
        String cSRFTokenOnForm = req.getParameter("cSRFToken");
        String cSRFToken = (String)otherState.get("csrfToken");
        CrossSiteRequestForgeryHelper.ValidationStatus validationStatus = CrossSiteRequestForgeryHelper.validateCSRFToken(cSRFToken, cSRFTokenOnForm);
        if (!validationStatus.isValid()) {
            AsAuditLogger.setDescription(AuthorizationRequestException.Error.invalid_request);
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request, validationStatus.getErrorMessage());
        }
    }

    protected final Client getClient(String clientId) throws AuthorizationRequestException {
        Client client;
        try {
            client = this.getClientManager().getCachedClient(clientId);
        }
        catch (ClientManager.ClientManagementException e) {
            AsAuditLogger.log("Database Exception");
            this.log.error((Object)"Unable to get client from client database", (Throwable)e);
            throw new AuthorizationRequestException(null, "Unable to get client from client database.");
        }
        if (client == null || !client.isEnabled()) {
            if (client == null) {
                AsAuditLogger.setDescription("Unknown or invalid " + Parameters.CLIENT_ID);
            } else if (!client.isEnabled()) {
                this.log.debug((Object)("Client " + client.getClientId() + " is disabled"));
                AsAuditLogger.setDescription("The client is disabled.");
            }
            throw new AuthorizationRequestException(null, "Unknown or invalid " + Parameters.CLIENT_ID);
        }
        return client;
    }

    protected final boolean isReturnScopeInResp(Scope requestedScope, Scope approvedScope) {
        boolean alwaysReturnScope = oauthOidcScopesConfigStore.getBooleanValue(ALWAYS_RETURN_SCOPE_SETTING, false);
        return alwaysReturnScope || !approvedScope.equals((Object)requestedScope);
    }

    @Override
    protected void logFailure(Exception e, OutMessageContext outMsgCtx) {
        AuditLogger.setStatus("failure");
        AuditLogger.setEvent("OAuth");
        AuditLogger.setProtocol("OAuth20");
        if (AsAuditLogger.isDescriptionBlank()) {
            if (e.getCause() != null) {
                AsAuditLogger.setDescription(e.getCause().getMessage());
            } else {
                AsAuditLogger.setDescription(e.getMessage());
            }
        }
        String endpoint = outMsgCtx.getEndpoint();
        LinkedHashMap<String, Object> error = new LinkedHashMap<String, Object>();
        if (StringUtils.isNotBlank((String)endpoint)) {
            error.put("redirect_uri", endpoint);
        }
        error.put("error", e.getMessage());
        AsAuditLogger.setOutMsgCtxWithErrors(error);
        ThreadContext.put((String)AuditLogger.MDC_KEY.IN_MESSAGE_TYPE.toString(), (String)"TokenAuthorize");
        AsAuditLogger.log(e.getMessage());
    }

    protected final AuthorizationProcessor getAuthorizationProcessor(InMessageContext inMsgCtx) throws AuthorizationRequestException {
        if (UserAuthorizationConsentPageSetting.ADAPTER.getValue().equals(this.authzServerMgr.getAuthzConsentSetting()) && StringUtils.isNotBlank((String)this.authzServerMgr.getExternalConsentAdapterId())) {
            return new ExternalAuthorizationProcessor(this.stateSupport, this.getAuthnPolicy(inMsgCtx), this.authzServerMgr);
        }
        return new PingFederateAuthorizationProcessor(this.stateSupport);
    }

    @Override
    protected String saveState(HttpServletRequest req, HttpServletResponse resp, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, Map<String, Object> otherInfo) {
        String resumePath = super.saveState(req, resp, inMsgCtx, outMsgCtx, otherInfo);
        if (AuthnApiSupport.getDefault().isApiRequest(req)) {
            InternalAuthnApiSupport.getDefault().addStateParamsToRequest(req, otherInfo);
            InternalAuthnApiSupport.getDefault().setAuthnAPIOAuthFlowID(req, this.stateSupport.getContextId(resumePath));
            try {
                ResponseType.ResponseMode responseMode = ResponseType.ResponseMode.forIdentifier(inMsgCtx.getParam("response_mode"));
                if (responseMode == ResponseType.ResponseMode.pi_flow) {
                    AuthnApiPolicyUtil.getDefault().setRedirectlessApiFlow(otherInfo, true);
                    this.authnApiCookielessUtils.setCookielessApiFlow(otherInfo, this.isCookielessEnabled(inMsgCtx));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return resumePath;
    }

    public abstract boolean isCookielessEnabled(InMessageContext var1);
}

