/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers;

import com.pingidentity.common.security.AccountLockingService;
import com.pingidentity.common.security.LockingService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientAuthenticationType;
import org.sourceid.oauth20.handlers.AccessTokenRequestException;
import org.sourceid.oauth20.handlers.GeneralOAuthError;
import org.sourceid.oauth20.issuer.OAuthIssuerUtils;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.oauth20.validate.ClientCertValidator;
import org.sourceid.oauth20.validate.ClientJwtValidator;
import org.sourceid.oauth20.validate.ClientPrivateKeyJwtValidator;
import org.sourceid.oauth20.validate.ClientSecretJwtValidator;
import org.sourceid.oauth20.validate.ClientSecretValidator;
import org.sourceid.oauth20.validate.CredentialsValidator;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.servlet.QuietException;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.profiles.RequestHandler;
import org.sourceid.websso.profiles.idp.AsAuditLogger;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public abstract class BaseClientAuthnRequestHandler
implements RequestHandler {
    private static final String ACCOUNT_LOCKED = "Client temporarily locked because number of failed logins was exceeded or max number of invalid tokens was attempted to be revoked";
    private final Log log = LogFactory.getLog(this.getClass());
    private static final LockingService accountLockingService = MgmtFactory.getAccountLockingService().getInstance(BaseClientAuthnRequestHandler.class.getSimpleName());
    private final ConfigStore deviceFlowConfig = ConfigStoreFarm.getConfig("oauth-device-flow");
    public static final String JWT_CLAIMS_ATTRIBUTE_NAME_TOKEN_MAPPING = "com.pingidentity.oauth.client.jwtClaimsMap";
    public static final String AUTHN_TYPE_ATTRIBUTE_NAME_TOKEN_MAPPING = "com.pingidentity.oauth.client.authnType";
    private final OAuthIssuerUtils oAuthIssuerUtils;

    public BaseClientAuthnRequestHandler(OAuthIssuerUtils oAuthIssuerUtils) {
        this.oAuthIssuerUtils = oAuthIssuerUtils;
    }

    public OAuthIssuerUtils getOAuthIssuerService() {
        return this.oAuthIssuerUtils;
    }

    protected abstract void doProcess(InMessageContext var1, OutMessageContext var2, Client var3, HttpServletRequest var4, HttpServletResponse var5) throws IOException, AccessTokenRequestException;

    protected abstract void preValidationAuditing(HttpServletRequest var1, InMessageContext var2);

    protected abstract Collection<String> getParamsToValidateNotRepeating();

    protected abstract void validateParameters(HttpServletRequest var1, InMessageContext var2) throws AccessTokenRequestException;

    protected abstract void validateParametersAgainstClient(HttpServletRequest var1, InMessageContext var2, Client var3) throws AccessTokenRequestException;

    @Override
    public OutMessageContext process(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        OutMessageContext outMsgCtx = new OutMessageContext();
        try {
            String clientId = CredentialsValidator.getClientId(req);
            AuditLogger.setEvent("OAuth");
            AuditLogger.setProtocol("OAuth20");
            AsAuditLogger.setConnectionId(clientId);
            this.oAuthIssuerUtils.setAuditLogVirtualServerIdIfApplicable(req);
            this.preValidationAuditingInternal(req, inMsgCtx);
            this.validateParamsNotRepeated(req);
            this.validateParameters(req, inMsgCtx);
            Client client = BaseClientAuthnRequestHandler.findValidClient(req);
            outMsgCtx.setEntityId(client.getClientId());
            AsAuditLogger.setInMsgCtx(req, client);
            this.validateParametersAgainstClient(req, inMsgCtx, client);
            AsAuditLogger.setConnectionId(client.getClientId());
            this.doProcess(inMsgCtx, outMsgCtx, client, req, resp);
        }
        catch (AccessTokenRequestException e) {
            BaseClientAuthnRequestHandler.errorCondition(resp, outMsgCtx, e, this.log, this.getEndpointName(), this.getRealmName());
        }
        return outMsgCtx;
    }

    public static void errorCondition(HttpServletResponse resp, OutMessageContext outMsgCtx, GeneralOAuthError oe, Log log, String endpointName, String realmName) {
        String auditMsg;
        String description;
        String errorString;
        String errorMsg;
        AuditLogger.setStatus("failure");
        if (oe.getCause() != null && !(oe.getCause() instanceof QuietException)) {
            errorMsg = "Handling exception condition in " + endpointName + ": " + oe;
            log.error((Object)errorMsg, (Throwable)oe.getActualException());
        } else {
            errorMsg = "Handling normal exception condition in " + endpointName + ": " + oe;
            log.debug((Object)errorMsg);
        }
        int errorCode = oe.getHttpErrorCode();
        resp.setStatus(errorCode);
        if (errorCode == 401) {
            resp.setHeader("WWW-Authenticate", "basic realm=\"" + realmName + "\"");
        }
        if (StringUtils.isEmpty((String)(errorString = oe.getErrorCode()))) {
            errorString = AccessTokenRequestException.Error.invalid_request.toString();
        }
        outMsgCtx.setParam("error", errorString);
        if (oe.getCause() != null && oe.getCause() instanceof AuthorizationException) {
            description = ((AuthorizationException)oe.getCause()).getErrorDetail();
            auditMsg = oe.getCause().getMessage();
        } else {
            description = oe.getDescription();
            auditMsg = oe.getMessage();
        }
        if (description != null) {
            description = description.replaceAll("\"", "");
            description = description.replaceAll("\\\\", "");
            outMsgCtx.setParam("error_description", description);
        }
        if (oe.isDoAuditLog()) {
            if (AsAuditLogger.isDescriptionBlank()) {
                AsAuditLogger.setDescription(auditMsg);
            }
            AsAuditLogger.setOutMsgCtxWithErrors(outMsgCtx.getParams());
            AsAuditLogger.log(errorMsg);
        }
    }

    protected abstract String getRealmName();

    protected abstract String getEndpointName();

    private void validateParamsNotRepeated(HttpServletRequest req) throws AccessTokenRequestException {
        Collection<String> moreParamNames = this.getParamsToValidateNotRepeating();
        ArrayList<String> paramNames = new ArrayList<String>(moreParamNames.size() + 2);
        paramNames.add(Parameters.CLIENT_ID);
        paramNames.add(Parameters.CLIENT_SECRET);
        paramNames.addAll(moreParamNames);
        for (String name : paramNames) {
            String[] values = req.getParameterValues(name);
            if (values == null || values.length <= 1) continue;
            AsAuditLogger.setDescription(AccessTokenRequestException.Error.invalid_request);
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_request, "parameter " + name + " repeats");
        }
    }

    public static Client findValidClient(HttpServletRequest req) throws AccessTokenRequestException {
        ClientJwtValidator clientJwtValidator;
        String accountLockKey = null;
        String clientId = CredentialsValidator.getClientId(req);
        if (clientId != null) {
            accountLockKey = AccountLockingService.getUserKeyWithMaxMaliciousActions(req.getRemoteAddr(), clientId);
        }
        if (accountLockKey != null && accountLockingService.isLockedWithMaxMaliciousActions(accountLockKey)) {
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_client, ACCOUNT_LOCKED);
        }
        ClientCertValidator clientCertValidator = new ClientCertValidator();
        Client client = ((CredentialsValidator)clientCertValidator).getValidClient(req);
        if (client == null) {
            clientJwtValidator = new ClientPrivateKeyJwtValidator();
            client = ((CredentialsValidator)clientJwtValidator).getValidClient(req);
        }
        if (client == null) {
            clientJwtValidator = new ClientSecretJwtValidator();
            client = ((CredentialsValidator)clientJwtValidator).getValidClient(req);
        }
        if (client == null) {
            ClientSecretValidator clientSecretAuthValidator = new ClientSecretValidator();
            try {
                client = ((CredentialsValidator)clientSecretAuthValidator).getValidClient(req);
                if (accountLockKey != null) {
                    accountLockingService.clearFailedLogins(accountLockKey);
                }
            }
            catch (AccessTokenRequestException e) {
                if (e.getError() == AccessTokenRequestException.Error.invalid_client && accountLockKey != null) {
                    accountLockingService.logFailedLogin(accountLockKey);
                }
                throw e;
            }
        }
        if (client != null) {
            req.setAttribute(AUTHN_TYPE_ATTRIBUTE_NAME_TOKEN_MAPPING, (Object)ClientAuthenticationType.toClientAuthnType((ClientAuthenticationType)client.getClientAuthnType()));
        }
        return client;
    }

    public static LockingService getAccountLockingService() {
        return accountLockingService;
    }

    protected void preValidationAuditingInternal(HttpServletRequest req, InMessageContext inMsgCtx) {
        this.preValidationAuditing(req, inMsgCtx);
        String grantType = inMsgCtx.getParam("grant_type");
        boolean doAudit = this.deviceFlowConfig.getBooleanValue("audit-authorization-pending-response", false);
        if ("urn:ietf:params:oauth:grant-type:device_code".equals(grantType) && !doAudit) {
            return;
        }
        AuditLogger.setStatus("inprogress");
        AsAuditLogger.log("");
    }

    public static boolean isAccountLockedEx(AccessTokenRequestException e) {
        return ACCOUNT_LOCKED.equals(e.getDescription());
    }
}

