/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jose4j.json.JsonUtil;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.lang.JoseException;
import org.sourceid.common.IDGenerator;
import org.sourceid.common.SpaceDelimitedStringUtil;
import org.sourceid.common.json.SimpleJsonRespWriter;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.wwwauth.AccessTokenUtil;
import org.sourceid.openid.connect.domain.ClientRegistrationParameters;
import org.sourceid.websso.profiles.BasicHttpRequestHandler;
import org.sourceid.websso.servlet.HttpStatusCodeException;

public class ClientRegistrationHandler
implements BasicHttpRequestHandler {
    private static final String POST = "POST";
    private ClientManager clientManager;
    private SimpleJsonRespWriter jsonRespWriter = new SimpleJsonRespWriter();
    private AccessTokenUtil accessTokenUtil;

    public ClientRegistrationHandler(ClientManager clientManager) {
        this.clientManager = clientManager;
        this.accessTokenUtil = new AccessTokenUtil(null, "OpenID Connect Dynamic Client Registration");
    }

    @Override
    public void process(HttpServletRequest req, HttpServletResponse resp) throws IOException, HttpStatusCodeException {
        LinkedHashMap<String, Object> jsonRespMap;
        block8: {
            if (!StringUtils.equals((String)req.getMethod(), (String)POST)) {
                throw new HttpStatusCodeException("Only POST is allowed.", 405);
            }
            jsonRespMap = new LinkedHashMap<String, Object>();
            try {
                Operation type = this.getType(req);
                switch (type) {
                    case client_register: {
                        this.create(req, jsonRespMap);
                        break;
                    }
                    case client_update: {
                        this.update(req, jsonRespMap);
                        break;
                    }
                    case rotate_secret: {
                        this.rotateSecret(req, jsonRespMap);
                        break;
                    }
                    default: {
                        throw new ClientRegistrationException(ClientRegistrationException.ErrorCode.invalid_operation);
                    }
                }
            }
            catch (ClientRegistrationException cre) {
                resp.setStatus(400);
                jsonRespMap.put("error_code", cre.getCode().toString());
                String errorDesc = cre.getMessage();
                if (errorDesc == null) break block8;
                jsonRespMap.put("error_description", errorDesc);
            }
        }
        this.jsonRespWriter.writeJson(resp, jsonRespMap);
    }

    private Operation getType(HttpServletRequest req) throws ClientRegistrationException {
        try {
            String typeString = req.getParameter(ClientRegistrationParameters.OPERATION);
            return Operation.valueOf(typeString);
        }
        catch (RuntimeException e) {
            StringBuilder desc = new StringBuilder();
            desc.append("The value of the ").append(ClientRegistrationParameters.OPERATION).append(" parameter must be one of ");
            Operation[] operations = Operation.values();
            for (int i = 0; i < operations.length; ++i) {
                desc.append((Object)operations[i]);
                if (i == operations.length - 1) {
                    desc.append(".");
                    continue;
                }
                if (i == operations.length - 2) {
                    desc.append(" or ");
                    continue;
                }
                desc.append(", ");
            }
            throw new ClientRegistrationException(ClientRegistrationException.ErrorCode.invalid_operation, desc.toString());
        }
    }

    private void update(HttpServletRequest req, Map<String, Object> jsonResp) throws ClientRegistrationException, HttpStatusCodeException {
        Client client = this.getClient(req);
        this.commonCreateUpdateParams(req, client);
        this.clientManager.updateClient(client);
        jsonResp.put(ClientRegistrationParameters.CLIENT_ID, client.getClientId());
    }

    private void rotateSecret(HttpServletRequest req, Map<String, Object> jsonResp) throws ClientRegistrationException, HttpStatusCodeException {
        Client client = this.getClient(req);
        String newSecret = this.generateSecret();
        client.setSecret(newSecret);
        this.clientManager.updateClient(client);
        this.fillRespParams(jsonResp, client.getClientId(), newSecret);
    }

    private void create(HttpServletRequest req, Map<String, Object> jsonResp) {
        Client client = new Client();
        String id = IDGenerator.rndAlphaNumeric(24);
        client.setClientId(id);
        this.commonCreateUpdateParams(req, client);
        String secret = this.generateSecret();
        client.setSecret(secret);
        this.clientManager.addClient(client);
        this.fillRespParams(jsonResp, id, secret);
    }

    private void commonCreateUpdateParams(HttpServletRequest req, Client client) {
        String name = req.getParameter(ClientRegistrationParameters.CLIENT_NAME);
        if (name == null) {
            name = "NO APPLICATION NAME PROVIDED";
        }
        client.setName(name);
        client.setLogoUrl(req.getParameter(ClientRegistrationParameters.LOGO_URL));
        String urisString = req.getParameter(ClientRegistrationParameters.REDIRECT_URIS);
        List uris = SpaceDelimitedStringUtil.fromString((String)urisString);
        client.setRedirectUris(uris);
        Set<String> grantTypes = client.getGrantTypes();
        grantTypes.add("authorization_code");
        grantTypes.add("implicit");
        client.setGrantTypes(grantTypes);
        client.setIdTokenSigningAlgorithm(req.getParameter(ClientRegistrationParameters.ID_TOKEN_SIGNED_RESPONSE_ALG));
        client.setPolicyGroupId(req.getParameter(ClientRegistrationParameters.PING_POLICY_GROUP_ID));
    }

    private Client getClient(HttpServletRequest req) throws ClientRegistrationException, HttpStatusCodeException {
        try {
            String accessToken = this.accessTokenUtil.getBearerAccessToken(req);
            JsonWebSignature jws = new JsonWebSignature();
            jws.setAlgorithmConstraints(AlgorithmConstraints.NO_CONSTRAINTS);
            jws.setCompactSerialization(accessToken);
            String jsonPayload = jws.getPayload();
            Map params = JsonUtil.parseJson((String)jsonPayload);
            String id = (String)params.get(ClientRegistrationParameters.CLIENT_ID);
            String secret = (String)params.get(ClientRegistrationParameters.CLIENT_SECRET);
            Client client = this.clientManager.getClient(id);
            if (client == null || !client.checkSecret(secret)) {
                throw this.accessTokenUtil.statusCodeEx(401, AccessTokenUtil.ErrorCode.invalid_token, null);
            }
            return client;
        }
        catch (JoseException e) {
            throw this.accessTokenUtil.statusCodeEx(401, AccessTokenUtil.ErrorCode.invalid_token, "malformed token: " + e);
        }
        catch (RuntimeException e) {
            throw this.accessTokenUtil.statusCodeEx(401, AccessTokenUtil.ErrorCode.invalid_token, "unable to process token: " + e);
        }
    }

    private String generateSecret() {
        return IDGenerator.generateBase64UrlEncodedBytes(64);
    }

    private void fillRespParams(Map<String, Object> jsonRespMap, String id, String secret) {
        jsonRespMap.put(ClientRegistrationParameters.CLIENT_ID, id);
        jsonRespMap.put(ClientRegistrationParameters.CLIENT_SECRET, secret);
        jsonRespMap.put(ClientRegistrationParameters.REGISTRATION_ACCESS_TOKEN, this.createRegistrationAccessToken(id, secret));
        jsonRespMap.put(ClientRegistrationParameters.EXPIRES_AT, 0);
    }

    private String createRegistrationAccessToken(String clientId, String secret) {
        JsonWebSignature jws = new JsonWebSignature();
        jws.setAlgorithmConstraints(AlgorithmConstraints.NO_CONSTRAINTS);
        jws.setAlgorithmHeaderValue("none");
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put(ClientRegistrationParameters.CLIENT_ID, clientId);
        payload.put(ClientRegistrationParameters.CLIENT_SECRET, secret);
        jws.setPayload(JsonUtil.toJson(payload));
        try {
            return jws.getCompactSerialization();
        }
        catch (JoseException e) {
            throw new IllegalStateException("Should never have a problem with an unsigned jws.", e);
        }
    }

    static class ClientRegistrationException
    extends Exception {
        private ErrorCode code;

        ClientRegistrationException(ErrorCode code) {
            this(code, null);
        }

        ClientRegistrationException(ErrorCode code, String errorMessage) {
            super(errorMessage);
            this.code = code;
        }

        public ErrorCode getCode() {
            return this.code;
        }

        static enum ErrorCode {
            invalid_operation,
            invalid_client_id,
            invalid_client_secret,
            invalid_configuration_parameter;

        }
    }

    static enum Operation {
        client_register,
        rotate_secret,
        client_update;

    }
}

