/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers;

import org.sourceid.oauth20.handlers.OAuthSourceId;

public class ContextUtil {
    public static final String CTX_QUALIFIER_AUTHZ_REQ = "authz_req";
    public static final String DELIM = "|";
    private static final String SPLIT_ON_DELIM = "\\|";
    private static final String CTX_QUALIFIER_TOKEN_EXCHANGE = "token_exchange";

    public String buildQualifiedIdForAccessGrant(String contextQualifier) {
        if (contextQualifier == null) {
            return null;
        }
        Ctx ctx = this.split(contextQualifier);
        if (ctx.getQualifier() == null || ctx.getOAuthSourceId() == null) {
            return null;
        }
        return this.buildQualifiedIdForAccessGrant(ctx.getQualifier(), ctx.getOAuthSourceId());
    }

    public String buildQualifiedIdForAccessGrant(String qualifier, OAuthSourceId id) {
        return this.buildQualifiedId(qualifier, id.toString(), true);
    }

    public String buildQualifiedId(String qualifier, OAuthSourceId id) {
        return this.buildQualifiedId(qualifier, id.toString(), false);
    }

    String buildQualifiedId(String qualifier, String id, boolean isCondense) {
        if (isCondense && "urn:ietf:params:oauth:grant-type:token-exchange".equals(qualifier)) {
            qualifier = CTX_QUALIFIER_TOKEN_EXCHANGE;
        }
        if (id == null) {
            return qualifier;
        }
        return qualifier + DELIM + id;
    }

    public Ctx splitForAccessGrant(String qualifiedContext) {
        if (qualifiedContext == null) {
            return null;
        }
        return this.split(qualifiedContext, true);
    }

    public Ctx split(String qualifiedContext) {
        return this.split(qualifiedContext, false);
    }

    private Ctx split(String qualifiedContext, boolean isCondensed) {
        String[] strings = qualifiedContext.split(SPLIT_ON_DELIM, 2);
        Ctx ctx = new Ctx();
        ctx.qualifier = strings[0];
        if (strings.length > 1) {
            if (isCondensed && CTX_QUALIFIER_TOKEN_EXCHANGE.equals(ctx.qualifier)) {
                ctx.qualifier = "urn:ietf:params:oauth:grant-type:token-exchange";
            }
            ctx.oauthSourceId = OAuthSourceId.fromString(strings[1], ctx.qualifier);
        }
        return ctx;
    }

    public static class Ctx {
        private String qualifier;
        private OAuthSourceId oauthSourceId;

        public String getQualifier() {
            return this.qualifier;
        }

        public void setQualifier(String qualifier) {
            this.qualifier = qualifier;
        }

        public OAuthSourceId getOAuthSourceId() {
            return this.oauthSourceId;
        }
    }
}

