/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers;

import com.pingidentity.sdk.accessgrant.AccessGrant;
import com.pingidentity.sdk.accessgrant.AccessGrantAttributesHolder;
import com.pingidentity.sdk.accessgrant.AccessGrantCriteria;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetails;
import com.pingidentity.sdk.oauth20.Scope;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.logging.log4j.ThreadContext;
import org.sourceid.oauth20.authorizationdetails.domain.AuthorizationDetailsUtil;
import org.sourceid.oauth20.bindings.AuthorizationEndpointBinding;
import org.sourceid.oauth20.consent.OAuthConsentManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.domain.PersistentGrantLifetimeHelper;
import org.sourceid.oauth20.domain.UserKeyToAccessTokenMapping;
import org.sourceid.oauth20.handlers.AttributesHolder;
import org.sourceid.oauth20.handlers.AuthorizationRequestException;
import org.sourceid.oauth20.handlers.BaseAuthorizationRequestHandler;
import org.sourceid.oauth20.handlers.ContextUtil;
import org.sourceid.oauth20.handlers.HandlerUtil;
import org.sourceid.oauth20.handlers.OAuthAdapterSupport;
import org.sourceid.oauth20.handlers.utils.AuthorizationProcessor;
import org.sourceid.oauth20.model.UserKeyAttributes;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.oauth20.protocol.ResponseType;
import org.sourceid.oauth20.token.AccessTokenResponse;
import org.sourceid.openid.connect.AuthorizationRequestSupport;
import org.sourceid.openid.connect.IdTokenClaims;
import org.sourceid.openid.connect.model.Prompt;
import org.sourceid.saml20.domain.AttrLookupException;
import org.sourceid.saml20.domain.AuthnApiApplication;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.servlet.filter.CrossOriginFilter;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.RequestProcessingException;
import org.sourceid.websso.profiles.idp.AsAuditLogger;
import org.sourceid.websso.servlet.reqparam.InvalidRequestParameterException;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class HandleAuthorizationRequest
extends BaseAuthorizationRequestHandler {
    public static final String RETURN_SCOPE = "return-scope";
    public static final String ACCESS_GRANT_ATTRS = "access-grant-attrs";
    public static final String SUPPL_CTX_KEY = "HandleAuthorizationRequest.state";
    private final AuthorizationRequestSupport authzReqSupport = new AuthorizationRequestSupport();
    private final ClientManager clientManager = MgmtFactory.getClientManager();
    private final BearerAccessTokenMgmtPluginManager tokenManager = MgmtFactory.getBearerAccessTokenMgmtPluginMgr();
    private final AuthorizationEndpointBinding binding = new AuthorizationEndpointBinding();
    private final OAuthConsentManager oAuthConsentManager = MgmtFactory.getOAuthConsentManager();
    private final ContextUtil contextUtil = new ContextUtil();

    @Override
    protected OutMessageContext getInitialOutMsgCtx(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp) {
        OutMessageContext outCtx = super.getInitialOutMsgCtx(inMsgCtx, req, resp);
        outCtx.setBinding(inMsgCtx.getBinding());
        outCtx.setEntityId(inMsgCtx.getEntityId());
        outCtx.setSupplementalContext("response_type", inMsgCtx.getParam("response_type"));
        outCtx.setSupplementalContext("response_mode", inMsgCtx.getParam("response_mode"));
        return outCtx;
    }

    @Override
    protected void handle(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx) throws IOException, RequestProcessingException {
        Client client = this.getClient(inMsgCtx.getEntityId());
        this.authzReqSupport.generalRequestProcessing(client, inMsgCtx, outMsgCtx, req);
        this.validateCrossOriginRequests(req, resp, client);
        super.handle(inMsgCtx, req, resp, outMsgCtx);
    }

    private void validateCrossOriginRequests(HttpServletRequest req, HttpServletResponse resp, Client client) {
        if (!CrossOriginFilter.isUsingAuthzEndpointCorsSettings(req) || !CrossOriginFilter.isSimpleResponseHeadersApplied(req)) {
            return;
        }
        String origin = req.getHeader("Origin");
        if (origin != null && MgmtFactory.getAuthnApiManager().getSettings().isRestrictAccessToRedirectlessMode()) {
            boolean foundAllowedApp = false;
            for (AuthnApiApplication app : MgmtFactory.getAuthnApiManager().getApiApplications()) {
                if (app.getClientIdForRedirectlessMode() == null || !app.getAllAllowedOrigins().contains(origin) || !app.getClientIdForRedirectlessMode().equals(client.getClientId())) continue;
                foundAllowedApp = true;
                if (!this.log.isDebugEnabled()) break;
                this.log.debug((Object)("Authentication application '" + app.getName() + "' has cross-origin access to client ID '" + client.getClientId() + "'"));
                break;
            }
            if (!foundAllowedApp) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Clearing CORS headers as no allowed authentication application was found for origin " + origin + " and client ID '" + client.getClientId() + "'"));
                }
                CrossOriginFilter.clearSimpleResponseHeaders(req, resp);
            }
        }
    }

    private void prepareOutCtx(HttpServletRequest req, HttpServletResponse resp, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, Map<String, Object> otherState, AttributesHolder userAttrs, Client client, AccessGrant accessGrant, ResponseType rspType, Scope scope, boolean returnScopeInResp, AuthorizationDetails authorizationDetails) throws AuthorizationRequestException {
        try {
            this.prepOutCtx(req, resp, inMsgCtx, outMsgCtx, otherState, userAttrs, client, accessGrant, rspType, scope, returnScopeInResp, authorizationDetails);
        }
        catch (AuthorizationException e) {
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.access_denied, e.getMessage(), e);
        }
        catch (InvalidRequestParameterException e) {
            throw new AuthorizationRequestException(e);
        }
        catch (AttrLookupException e) {
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.server_error, e.getMessage(), e);
        }
    }

    private void prepOutCtx(HttpServletRequest req, HttpServletResponse resp, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, Map<String, Object> otherState, AttributesHolder userAttrs, Client client, AccessGrant accessGrant, ResponseType rspType, Scope scope, boolean returnScopeInResp, AuthorizationDetails authorizationDetails) throws AuthorizationRequestException, AttrLookupException, InvalidRequestParameterException, AuthorizationException {
        String contextQualifier = (String)outMsgCtx.getSupplementalContext("ctxQ");
        UserKeyAttributes userKeyAttrs = userAttrs.getUserKeyAttributes();
        String userKeyValue = userKeyAttrs.getUserKeyValue();
        AttributeMap extendedGrantAttrs = userKeyAttrs.getExtendedAttributes();
        AttributeMap authnContextAttrs = UserKeyToAccessTokenMapping.pruneUnreferencedAttrs(userAttrs.getAuthnResult().getAuthnAttrs(), contextQualifier);
        AccessGrantAttributesHolder grantAttrsHolder = new AccessGrantAttributesHolder(extendedGrantAttrs, authnContextAttrs);
        String accessToken = null;
        String sri = StateMgmtFactory.getExtendedSriV2(req, resp, otherState);
        AccessGrant existingAG = this.getExistingAccessGrant(inMsgCtx, client, scope, contextQualifier, userKeyValue, authorizationDetails);
        Set resources = inMsgCtx.getParam("resource", Set.class);
        IdTokenClaims idTokenClaims = this.authzReqSupport.checkCreateIdTokenClaims(inMsgCtx, client, scope, userAttrs, contextQualifier, req, resp, otherState, rspType, existingAG, rspType.getFirstImpliedGrantType(), resources);
        if (rspType.hasAny("token", "id_token")) {
            AccessTokenResponse atr;
            boolean reuseAccessGrant;
            boolean bl = reuseAccessGrant = client.isOverrideReusePersistentGrantType() ? client.isReusePersistentGrantTypeAllowed("implicit") : this.authzServerMgr.reuseExistingPersistentGrant("implicit");
            if (accessGrant == null && reuseAccessGrant && !client.isBypassApprovalPage()) {
                AccessGrantCriteria accessGrantCriteria = new AccessGrantCriteria(userKeyValue, scope, client.getClientId(), "implicit", contextQualifier, authorizationDetails);
                accessGrant = this.accessGrantMgr.getByAccessGrantCriteria(accessGrantCriteria);
            }
            if (accessGrant == null) {
                String accessGrantQualifiedId = this.contextUtil.buildQualifiedIdForAccessGrant(contextQualifier);
                accessGrant = new AccessGrant(null, userKeyValue, scope, client.getClientId(), "implicit", accessGrantQualifiedId);
                accessGrant.setAuthorizationDetails(authorizationDetails);
                if (reuseAccessGrant && !client.isBypassApprovalPage() && PersistentGrantLifetimeHelper.isIssuePersistentGrantInContextOverride(grantAttrsHolder)) {
                    String persistentGrantLifetime = PersistentGrantLifetimeHelper.getPersistentGrantLifetimeInContextOverride(grantAttrsHolder);
                    PersistentGrantLifetimeHelper.setExpirationOnGrant(accessGrant, client, persistentGrantLifetime);
                    this.accessGrantMgr.saveGrant(accessGrant, null);
                } else {
                    accessGrant.setGuid(null);
                }
            }
            if (rspType.has("token") && (atr = HandlerUtil.mapAttrsAndIssue(req, inMsgCtx, grantAttrsHolder, accessGrant, this.authzServerMgr, this.tokenManager, scope, returnScopeInResp, client, sri, rspType.getFirstImpliedGrantType(), authorizationDetails, resources)) != null) {
                HandlerUtil.tokenResponseToOutContext(outMsgCtx, atr);
                accessToken = atr.getAccessToken().toString();
            }
        }
        String code = null;
        if (rspType.has("code") && rspType.sendsIdTokenFrontChannel()) {
            code = this.binding.createCode(outMsgCtx);
        }
        String idToken = this.authzReqSupport.checkCreateIdToken(req, resp, outMsgCtx, idTokenClaims, client, rspType.sendsIdTokenFrontChannel() ? accessToken : null, code, outMsgCtx.getEndpoint(), otherState, userAttrs, inMsgCtx.getRelayState());
        if (rspType.has("code")) {
            String dpopJkt;
            String audience;
            outMsgCtx.setSupplementalContext(Parameters.SCOPE, scope.getScopeStr());
            outMsgCtx.setSupplementalContext(RETURN_SCOPE, returnScopeInResp);
            outMsgCtx.setSupplementalContext("authorization_details", authorizationDetails.toJson());
            outMsgCtx.setSupplementalContext("UK", userKeyValue);
            outMsgCtx.setSupplementalContext("id_token", idToken);
            if (idToken != null && idTokenClaims != null) {
                outMsgCtx.setSupplementalContext("id_token_jti", idTokenClaims.getClaims().get("jti"));
            }
            outMsgCtx.setSupplementalContext(ACCESS_GRANT_ATTRS, grantAttrsHolder);
            outMsgCtx.setSupplementalContext("code_challenge", inMsgCtx.getParam("code_challenge"));
            outMsgCtx.setSupplementalContext("code_challenge_method", inMsgCtx.getParam("code_challenge_method"));
            outMsgCtx.setSupplementalContext("pi.sri", sri);
            String requestedTokenManagerId = inMsgCtx.getParam("access_token_manager_id");
            if (requestedTokenManagerId != null) {
                outMsgCtx.setSupplementalContext("access_token_manager_id", requestedTokenManagerId);
            }
            if ((audience = inMsgCtx.getParam("aud")) != null) {
                outMsgCtx.setSupplementalContext("aud", audience);
            }
            if (CollectionUtils.isNotEmpty((Collection)resources)) {
                outMsgCtx.setSupplementalContext("resource", resources);
            }
            if ((dpopJkt = inMsgCtx.getParam("dpop_jkt")) != null) {
                outMsgCtx.setSupplementalContext("dpop_jkt", dpopJkt);
            }
        }
        if (rspType.has("id_token") && idToken != null) {
            outMsgCtx.setParam("id_token", idToken, true);
            if (idTokenClaims != null && idTokenClaims.getClaims().get("jti") instanceof String) {
                AuditLogger.setIdTokenJti((String)idTokenClaims.getClaims().get("jti"));
            }
        }
    }

    private AccessGrant getExistingAccessGrant(InMessageContext inMsgCtx, Client client, Scope scope, String contextQualifier, String userKeyValue, AuthorizationDetails authorizationDetails) throws AuthorizationRequestException {
        boolean reuseAccessGrant;
        String grantType = this.authzReqSupport.getResponseType(inMsgCtx, false, client).getFirstImpliedGrantType();
        boolean bl = reuseAccessGrant = client.isOverrideReusePersistentGrantType() ? client.isReusePersistentGrantTypeAllowed(grantType) : this.authzServerMgr.reuseExistingPersistentGrant(grantType);
        if (reuseAccessGrant && client.getGrantTypes().contains("refresh_token") && "authorization_code".equals(grantType)) {
            AccessGrantCriteria accessGrantCriteria = new AccessGrantCriteria(userKeyValue, scope, client.getClientId(), grantType, contextQualifier, authorizationDetails);
            return this.accessGrantMgr.getByAccessGrantCriteria(accessGrantCriteria);
        }
        return null;
    }

    @Override
    void doIt(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx, Map<String, Object> otherState, AttributesHolder userAttrs) throws AuthorizationRequestException {
        AuthorizationDetails requestedAuthorizationDetails;
        Scope requestedScope;
        UserKeyAttributes userKeyAttrs = userAttrs.getUserKeyAttributes();
        String userKeyValue = userKeyAttrs.getUserKeyValue();
        String userKeyValueForLog = userKeyAttrs.getUserKeyValue(true);
        AuditLogger.setEvent("OAuth");
        AuditLogger.setProtocol("OAuth20");
        ThreadContext.put((String)AuditLogger.MDC_KEY.IN_MESSAGE_TYPE.toString(), (String)"TokenAuthorize");
        AuditLogger.setUserName(userKeyValueForLog);
        AsAuditLogger.setOutMsgCtx(outMsgCtx);
        ThreadContext.put((String)AuditLogger.MDC_KEY.ATTRIBUTES.toString(), (String)AsAuditLogger.getAttributesAsString(userKeyAttrs));
        AsAuditLogger.setAuthnSourceId(OAuthAdapterSupport.getAuthnSourceKeys(userAttrs.getAuthnResult().getAuthnBeans()));
        Scope approvedScope = requestedScope = Scope.getScope((String)inMsgCtx.getParam(Parameters.SCOPE));
        String partnerId = inMsgCtx.getEntityId();
        Client client = this.clientManager.getCachedClient(partnerId);
        if (partnerId != null) {
            ThreadContext.put((String)AuditLogger.MDC_KEY.PARTNER_ID.toString(), (String)partnerId);
        } else if (client.getClientId() != null) {
            ThreadContext.put((String)AuditLogger.MDC_KEY.PARTNER_ID.toString(), (String)client.getClientId());
        }
        if (client.getName() != null) {
            ThreadContext.put((String)AuditLogger.MDC_KEY.PARTNER_NAME.toString(), (String)client.getName());
        }
        AuthorizationDetails approvedAuthorizationDetails = requestedAuthorizationDetails = AuthorizationDetailsUtil.getAuthorizationDetails((String)otherState.get("authorization_details"));
        ResponseType rspType = this.authzReqSupport.getResponseType(inMsgCtx, false, client);
        AsAuditLogger.setGrantType(rspType.getFirstImpliedGrantType());
        AsAuditLogger.setInMsgCtx(client, inMsgCtx, rspType);
        this.getoAuthIssuerUtils().setAuditLogVirtualServerIdIfApplicable(req);
        Prompt prompt = this.getPrompt(inMsgCtx);
        AccessGrant accessGrant = null;
        boolean granted = false;
        boolean bypassApprovalPageForConsent = false;
        boolean reuseAccessGrant = client.isOverrideReusePersistentGrantType() ? client.isReusePersistentGrantTypeAllowed(rspType.getFirstImpliedGrantType()) : this.authzServerMgr.reuseExistingPersistentGrant(rspType.getFirstImpliedGrantType());
        boolean reuseConsent = this.authzServerMgr.isBypassAuthorizationForApprovedConsents();
        if (client.isBypassApprovalPage() || AuthnApiSupport.getDefault().isApiRequest(req)) {
            granted = true;
            bypassApprovalPageForConsent = true;
        } else if (reuseAccessGrant && !prompt.isConsent()) {
            boolean skipAuthz = true;
            if (rspType.has("code") && !this.authzServerMgr.allowAutoAuthz("authorization_code")) {
                skipAuthz = false;
            }
            if (skipAuthz) {
                String impliedGrantType = rspType.getFirstImpliedGrantType();
                String contextQualifier = (String)outMsgCtx.getSupplementalContext("ctxQ");
                AccessGrantCriteria accessGrantCriteria = new AccessGrantCriteria(userKeyValue, approvedScope, client.getClientId(), impliedGrantType, contextQualifier, approvedAuthorizationDetails);
                accessGrant = this.accessGrantMgr.getByAccessGrantCriteria(accessGrantCriteria);
                if (accessGrant != null) {
                    if (PersistentGrantLifetimeHelper.isWithinIdleTimeoutWindow(accessGrant)) {
                        granted = true;
                    } else {
                        this.accessGrantMgr.revokeGrant(accessGrant.getGuid());
                    }
                }
            }
        }
        if (reuseConsent && !bypassApprovalPageForConsent && !prompt.isConsent()) {
            granted = this.oAuthConsentManager.isGranted(userKeyValue, client.getClientId(), approvedScope, approvedAuthorizationDetails);
        }
        if (!granted) {
            if (prompt.isNone()) {
                throw new AuthorizationRequestException(AuthorizationRequestException.Error.interaction_required);
            }
            AuthorizationProcessor.AuthorizationResult result = this.getAuthorizationProcessor(inMsgCtx).doAuthorize(req, resp, inMsgCtx, outMsgCtx, otherState, client, userKeyValue, userKeyAttrs, requestedScope, requestedAuthorizationDetails);
            if (AuthorizationProcessor.AuthorizationResult.Status.DENY.getValue().equals(result.getStatus().getValue())) {
                AsAuditLogger.setDescription("User Denied Authorization");
                if (reuseConsent) {
                    this.oAuthConsentManager.deny(userKeyValue, client.getClientId(), requestedScope, requestedAuthorizationDetails);
                }
                throw new AuthorizationRequestException(AuthorizationRequestException.Error.access_denied, "User Denied Authorization");
            }
            if (AuthorizationProcessor.AuthorizationResult.Status.ALLOW.getValue().equals(result.getStatus().getValue())) {
                granted = true;
                approvedScope = result.getApprovedScope();
                approvedAuthorizationDetails = result.getApprovedAuthorizationDetails();
                if (reuseConsent) {
                    this.oAuthConsentManager.createOrUpdate(userKeyValue, client.getClientId(), requestedScope, approvedScope, requestedAuthorizationDetails, approvedAuthorizationDetails);
                }
            }
        }
        if (granted) {
            boolean returnScopeInResp = this.isReturnScopeInResp(requestedScope, approvedScope);
            this.prepareOutCtx(req, resp, inMsgCtx, outMsgCtx, otherState, userAttrs, client, accessGrant, rspType, approvedScope, returnScopeInResp, approvedAuthorizationDetails);
            outMsgCtx.populateOutUrlAuditLogParameter();
            AuditLogger.setStatus("success");
            if (!rspType.has("code")) {
                AsAuditLogger.log("User Granted Authorization");
            }
        }
    }

    @Override
    String getSupplementalContextKeyName() {
        return SUPPL_CTX_KEY;
    }

    @Override
    boolean isSkipAuthorization() {
        return false;
    }

    @Override
    protected ClientManager getClientManager() {
        return this.clientManager;
    }

    @Override
    public boolean isCookielessEnabled(InMessageContext inMsgCtx) {
        if (inMsgCtx.getEntityId() == null) {
            this.log.error((Object)"Client id parameter not found");
            throw new ProcessRuntimeException("Client not found");
        }
        try {
            return this.getClient(inMsgCtx.getEntityId()).getEnableCookielessAuthenticationApi();
        }
        catch (AuthorizationRequestException e) {
            this.log.error((Object)"Failed to obtain the client");
            throw new ProcessRuntimeException(e);
        }
    }
}

