/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers;

import com.pingidentity.sdk.accessgrant.AccessGrantManager;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.handlers.AccessTokenRequestException;
import org.sourceid.oauth20.handlers.BaseClientAuthnRequestHandler;
import org.sourceid.oauth20.handlers.process.GrantContext;
import org.sourceid.oauth20.handlers.process.IntrospectBearerTokenProcessor;
import org.sourceid.oauth20.issuer.OAuthIssuerUtils;
import org.sourceid.oauth20.utils.ResourceIndicatorsUtils;
import org.sourceid.openid.connect.domain.ConnectProviderRuntimePolicySupport;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderPolicy;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.profiles.RequestProcessingException;
import org.sourceid.websso.profiles.idp.AsAuditLogger;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class TokenIntrospectEndpointRequestHandler
extends BaseClientAuthnRequestHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final BearerAccessTokenMgmtPluginManager tokenPluginMgr;
    private final AccessGrantManager accessGrantManager;
    private final ConnectProviderRuntimePolicySupport connectProviderRuntimePolicySupport;

    public TokenIntrospectEndpointRequestHandler() {
        this(OAuthIssuerUtils.getInstance(), MgmtFactory.getBearerAccessTokenMgmtPluginMgr(), MgmtFactory.getAccessGrantManager(), new ConnectProviderRuntimePolicySupport());
    }

    public TokenIntrospectEndpointRequestHandler(OAuthIssuerUtils oAuthIssuerUtils, BearerAccessTokenMgmtPluginManager tokenPluginMgr, AccessGrantManager accessGrantManager, ConnectProviderRuntimePolicySupport connectProviderRuntimePolicySupport) {
        super(oAuthIssuerUtils);
        this.tokenPluginMgr = tokenPluginMgr;
        this.accessGrantManager = accessGrantManager;
        this.connectProviderRuntimePolicySupport = connectProviderRuntimePolicySupport;
    }

    @Override
    protected void doProcess(InMessageContext msgCtx, OutMessageContext outMsgCtx, Client client, HttpServletRequest req, HttpServletResponse resp) throws IOException, AccessTokenRequestException {
        try {
            IntrospectBearerTokenProcessor processor = new IntrospectBearerTokenProcessor(this.tokenPluginMgr, this.accessGrantManager, this.connectProviderRuntimePolicySupport, this.getOAuthIssuerService());
            GrantContext context = processor.processGrant(msgCtx, req, resp, client, null);
            context.getAccessTokenResponse().tokenResponseToOutContext(outMsgCtx);
            AsAuditLogger.log("Token Validated");
        }
        catch (AccessTokenRequestException a) {
            AuditLogger.setStatus("failure");
            if (StringUtils.isNotBlank((String)a.getDescription())) {
                AsAuditLogger.setDescription(a.getDescription());
            } else {
                AsAuditLogger.setDescription(AccessTokenRequestException.Error.invalid_grant);
            }
            HashMap<String, Object> error = new HashMap<String, Object>();
            error.put("error", a.getMessage());
            AsAuditLogger.setOutMsgCtxWithErrors(error);
            AsAuditLogger.log("AccessGrantManagement Exception thrown: " + a);
            throw a;
        }
    }

    @Override
    protected void preValidationAuditing(HttpServletRequest req, InMessageContext inMsgCtx) {
        AsAuditLogger.setInMsgCtx(req, null, null);
    }

    @Override
    protected Collection<String> getParamsToValidateNotRepeating() {
        return Arrays.asList("token", "token_type", "token_type_hint", "access_token_manager_id", "aud");
    }

    @Override
    protected void validateParameters(HttpServletRequest req, InMessageContext inMsgCtx) throws AccessTokenRequestException {
        String tokenString = req.getParameter("token");
        if (StringUtils.isBlank((String)tokenString)) {
            AsAuditLogger.setDescription(AccessTokenRequestException.Error.invalid_request);
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_request, "token parameter is required for the introspection endpoint.");
        }
        try {
            ResourceIndicatorsUtils.validateResources(inMsgCtx.getParam("resource", Set.class));
        }
        catch (RequestProcessingException e) {
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_target, e.getMessage(), e);
        }
        AsAuditLogger.setInMessageType("urn:pingidentity.com:oauth2:grant_type:validate_bearer");
    }

    @Override
    protected void validateParametersAgainstClient(HttpServletRequest req, InMessageContext inMsgCtx, Client client) throws AccessTokenRequestException {
        if ("id_token".equals(req.getParameter("token_type_hint"))) {
            if (!client.canIssueIdToken()) {
                this.log.debug("Client '{}' is not authorized to issue or validate ID tokens", (Object)client.getClientId());
                AsAuditLogger.setDescription(AccessTokenRequestException.Error.unauthorized_client);
                throw new AccessTokenRequestException(AccessTokenRequestException.Error.unauthorized_client, 401);
            }
            OpenIdConnectProviderPolicy.PolicyGroup policyGroup = this.connectProviderRuntimePolicySupport.getPolicyGroup(client);
            if (!policyGroup.isAllowIdTokenIntrospection()) {
                this.log.debug("Client '{}' Policy Group '{}' does not allow ID tokens validation", (Object)client.getClientId(), (Object)policyGroup.getName());
                AsAuditLogger.setDescription(AccessTokenRequestException.Error.unauthorized_client);
                throw new AccessTokenRequestException(AccessTokenRequestException.Error.unauthorized_client, 401);
            }
            return;
        }
        if (StringUtils.isNotEmpty((String)client.getClientId()) && !client.isGrantTypeAllowed("urn:pingidentity.com:oauth2:grant_type:validate_bearer")) {
            this.log.debug("Client '" + client.getClientId() + "' is not authorized to validate tokens.");
            AsAuditLogger.setDescription(AccessTokenRequestException.Error.unauthorized_client);
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.unauthorized_client, 401);
        }
    }

    @Override
    protected String getRealmName() {
        return "PF AS Token Introspection Endpoint";
    }

    @Override
    protected String getEndpointName() {
        return "token introspection endpoint";
    }
}

