/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers;

import com.pingidentity.common.security.AccountLockingService;
import com.pingidentity.common.security.LockingService;
import com.pingidentity.sdk.accessgrant.AccessGrantAttributesHolder;
import com.pingidentity.sdk.api.authn.common.CommonActionSpec;
import com.pingidentity.sdk.api.authn.common.CommonErrorDetailSpec;
import com.pingidentity.sdk.api.authn.common.CommonErrorSpec;
import com.pingidentity.sdk.api.authn.common.CommonStateSpec;
import com.pingidentity.sdk.api.authn.exception.AuthnErrorException;
import com.pingidentity.sdk.api.authn.internal.InternalAuthnApiSupport;
import com.pingidentity.sdk.api.authn.model.AuthnError;
import com.pingidentity.sdk.api.authn.model.AuthnState;
import com.pingidentity.sdk.api.authn.model.User;
import com.pingidentity.sdk.api.authn.model.action.ConfirmUserCode;
import com.pingidentity.sdk.api.authn.model.action.SubmitUserCode;
import com.pingidentity.sdk.api.authn.model.state.OAuthDeviceUserCodeConfirmationRequired;
import com.pingidentity.sdk.api.authn.model.state.OAuthDeviceUserCodeRequired;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetails;
import com.pingidentity.sdk.oauth20.Scope;
import com.pingidentity.templates.mgmt.TemplateParamUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.ThreadContext;
import org.sourceid.common.IDGenerator;
import org.sourceid.common.ResponseTemplateRenderer;
import org.sourceid.common.ResponseTemplateRendererException;
import org.sourceid.config.ConfigStore;
import org.sourceid.oauth20.authorizationdetails.domain.AuthorizationDetailsUtil;
import org.sourceid.oauth20.consent.OAuthConsentManager;
import org.sourceid.oauth20.device.DeviceAuthorizationState;
import org.sourceid.oauth20.device.DeviceFlowManager;
import org.sourceid.oauth20.domain.ActivationCodeCheckMode;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.domain.UserKeyToAccessTokenMapping;
import org.sourceid.oauth20.handlers.AttributesHolder;
import org.sourceid.oauth20.handlers.AuthorizationRequestException;
import org.sourceid.oauth20.handlers.BaseAuthorizationRequestHandler;
import org.sourceid.oauth20.handlers.HandlerUtil;
import org.sourceid.oauth20.handlers.OAuthAdapterSupport;
import org.sourceid.oauth20.handlers.utils.AuthorizationProcessor;
import org.sourceid.oauth20.model.UserKeyAttributes;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.oauth20.protocol.ResponseType;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.adapter.state.KeyValueStateSupport;
import org.sourceid.saml20.domain.AuthnApiApplication;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.saml20.state.StateSupport;
import org.sourceid.servlet.HttpServletRespProxy;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.authn.ApiRedirectWrapper;
import org.sourceid.websso.authn.AuthnApiPolicyUtil;
import org.sourceid.websso.authn.AuthnPluginKey;
import org.sourceid.websso.authn.AuthnPolicyUtil;
import org.sourceid.websso.authn.AuthnProcessorException;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.RequestProcessingException;
import org.sourceid.websso.profiles.idp.AsAuditLogger;
import org.sourceid.websso.servlet.reqparam.HttpServletReqProxy;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class UserAuthorizationRequestHandler
extends BaseAuthorizationRequestHandler {
    public static final String SUPPL_CTX_KEY = "UserAuthorizationRequestHandler.state";
    private static final String OAUTH_DEVICE_USER_CODE_PAGE_TEMPLATE = "oauth.device.user-code.page.template.html";
    private static final String OAUTH_DEVICE_USER_CODE_CONFIRM_PAGE_TEMPLATE = "oauth.device.user-code-confirm.page.template.html";
    private static final String OK_FIELD_NAME = "ok";
    private static final String OK_FIELD_CLICKED_VALUE = "clicked";
    private static final String USER_CODE_FIELD_NAME = "user-code";
    private static final String STAGE_KEY = "oauth:device-flow:stage";
    private static final String STAGE_VALUE_GET_USER_CODE = "oauth:device-flow:stage:get-user-code";
    private static final String STAGE_VALUE_VERIFICATION_URI_COMPLETE = "oauth:device-flow:stage:verification-uri-complete";
    private static final String STAGE_VALUE_APPROVAL = "oauth:device-flow:stage:ask-consent";
    private static final String LOCKOUT_PERIOD_KEY = "LockoutPeriod";
    private static final int LOCKOUT_PERIOD_DEFAULT = 1;
    private static final String MAX_CONSECUTIVE_FAILURES_KEY = "MaxConsecutiveFailures";
    private static final int MAX_CONSECUTIVE_FAILURES_DEFAULT = 6;
    private static final String PRE_AUTHENTICATION_LOCKOUT_PERIOD_KEY = "PreAuthenticationLockoutPeriod";
    private static final int PRE_AUTHENTICATION_LOCKOUT_PERIOD_DEFAULT = 1;
    private static final String MAX_PRE_AUTHENTICATION_FAILURES_KEY = "MaxPreAuthenticationFailures";
    private static final int MAX_PRE_AUTHENTICATION_FAILURES_DEFAULT = 1000;
    private static final String VAR_ERROR_MESSAGE_KEY = "errorMessageKey";
    private static final String VAR_USER_CODE = "userCode";
    private static final String VAR_USER_KEY_ATTRIBUTES = "userKeyAttributes";
    private static final String VAR_USER_KEY = "userKey";
    private static final String VAR_USER_NAME = "userName";
    private static final String VAR_ACTION = "action";
    private static final String VAR_GRANT_ATTRIBUTES = "grantAttributes";
    private static final String MSG_USER_CODE_REQUIRED = "message.user-code.required";
    private static final String MSG_USER_CODE_INVALID = "message.user-code.invalid";
    private static final String MSG_USER_CODE_EXPIRED = "message.user-code.expired";
    private static final String MSG_USER_CODE_LOCKED = "message.user-code.locked";
    private final KeyValueStateSupport keyValueStateSupport;
    private final DeviceFlowManager deviceFlowManager;
    private final ClientManager clientManager;
    private final LockingService lockingService;
    private final ConfigStore config;
    private final OAuthConsentManager oAuthConsentManager;
    private final AuthzServerManager authzServerManager;

    public UserAuthorizationRequestHandler(KeyValueStateSupport keyValueStateSupport, DeviceFlowManager deviceFlowManager, ClientManager clientManager, LockingService lockingService, ConfigStore config, OAuthConsentManager oAuthConsentManager, AuthzServerManager authzServerManager) {
        this.keyValueStateSupport = keyValueStateSupport;
        this.deviceFlowManager = deviceFlowManager;
        this.clientManager = clientManager;
        this.lockingService = lockingService;
        this.config = config;
        this.oAuthConsentManager = oAuthConsentManager;
        this.authzServerManager = authzServerManager;
    }

    @Override
    public boolean isAuthnApiHandlesException(HttpServletRequest req, Map<String, Object> stateParams, InMessageContext inMsgCtx, OutMessageContext outMsgCtx) {
        return this.isAuthnApiHandlesResult(req, stateParams);
    }

    @Override
    public boolean isAuthnApiHandlesResult(HttpServletRequest req, Map<String, Object> stateParams) {
        return this.isEnableAuthnApiForUserCodeValidation() && (AuthnApiPolicyUtil.getDefault().isRedirectlessApiFlow(stateParams) || AuthnApiPolicyUtil.getDefault().getEffectiveAuthnApiApplication(stateParams) != null);
    }

    @Override
    public boolean hasAdditionalApiCapableStages() {
        return this.isEnableAuthnApiForUserCodeValidation();
    }

    @Override
    protected OutMessageContext getInitialOutMsgCtx(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp) {
        OutMessageContext outMsgCtx = super.getInitialOutMsgCtx(inMsgCtx, req, resp);
        outMsgCtx.setBinding(inMsgCtx.getBinding());
        return outMsgCtx;
    }

    @Override
    protected void handle(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx) throws IOException, RequestProcessingException {
        this.validateParameters(inMsgCtx);
        super.handle(inMsgCtx, req, resp, outMsgCtx);
    }

    @Override
    void doIt(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx, Map<String, Object> otherState, AttributesHolder userAttrs) throws AuthorizationRequestException, IOException {
        this.setAuditLogFields(inMsgCtx, req, outMsgCtx);
        UserKeyAttributes userKeyAttrs = userAttrs.getUserKeyAttributes();
        ThreadContext.put((String)AuditLogger.MDC_KEY.ATTRIBUTES.toString(), (String)AsAuditLogger.getAttributesAsString(userKeyAttrs));
        String userKeyValueForLog = userKeyAttrs.getUserKeyValue(true);
        AuditLogger.setUserName(userKeyValueForLog);
        AsAuditLogger.setAuthnSourceId(OAuthAdapterSupport.getAuthnSourceKeys(userAttrs.getAuthnResult().getAuthnBeans()));
        this.doStageWithWrapper(inMsgCtx, req, resp, outMsgCtx, otherState, userAttrs);
    }

    @Override
    protected void checkDoPreAuthnStep(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx, Map<String, Object> otherState) throws RequestProcessingException, IOException {
        this.setAuditLogFields(inMsgCtx, req, outMsgCtx);
        if (MgmtFactory.getAuthzServerManager().getActivationCodeCheckMode() == ActivationCodeCheckMode.AFTER_AUTHENTICATION) {
            return;
        }
        String stage = this.getStage(inMsgCtx, otherState);
        if (!Arrays.asList(STAGE_VALUE_GET_USER_CODE, STAGE_VALUE_VERIFICATION_URI_COMPLETE).contains(stage)) {
            return;
        }
        this.doStageWithWrapper(inMsgCtx, req, resp, outMsgCtx, otherState, null);
    }

    @Override
    String getSupplementalContextKeyName() {
        return SUPPL_CTX_KEY;
    }

    @Override
    boolean isSkipAuthorization() {
        return false;
    }

    @Override
    protected ClientManager getClientManager() {
        return this.clientManager;
    }

    @Override
    public boolean isCookielessEnabled(InMessageContext inMsgCtx) {
        return this.authzServerManager.isEnableCookielessUserAuthzAuthnApi();
    }

    private void setAuditLogFields(InMessageContext inMsgCtx, HttpServletRequest req, OutMessageContext outMsgCtx) {
        AuditLogger.setEvent("OAuth");
        AuditLogger.setProtocol("OAuth20");
        ThreadContext.put((String)AuditLogger.MDC_KEY.IN_MESSAGE_TYPE.toString(), (String)"TokenAuthorize");
        AsAuditLogger.setOutMsgCtx(outMsgCtx);
        this.getoAuthIssuerUtils().setAuditLogVirtualServerIdIfApplicable(req);
        if (inMsgCtx.getEntityId() != null) {
            AsAuditLogger.setPartnerId(inMsgCtx.getEntityId());
        }
    }

    private void validateParameters(InMessageContext inMsgCtx) throws AuthorizationRequestException {
        String responseModeString = inMsgCtx.getParam("response_mode");
        if (responseModeString != null) {
            try {
                ResponseType.ResponseMode responseMode = ResponseType.ResponseMode.forIdentifier(responseModeString);
                if (responseMode != ResponseType.ResponseMode.pi_flow) {
                    throw new AuthorizationRequestException(null, "The only allowed response_mode for this endpoint is " + ResponseType.ResponseMode.pi_flow.getIdentifier() + ".");
                }
                if (!MgmtFactory.getAuthnApiManager().isApiEnabled()) {
                    String msg = "response_mode " + ResponseType.ResponseMode.pi_flow.getIdentifier() + " requested, but authentication API is not enabled";
                    throw new AuthorizationRequestException(AuthorizationRequestException.Error.access_denied, msg);
                }
            }
            catch (IllegalArgumentException e) {
                throw new AuthorizationRequestException(null, "The requested response_mode is not valid.");
            }
        }
    }

    private void doStageWithWrapper(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx, Map<String, Object> otherState, AttributesHolder userAttrs) throws IOException, AuthorizationRequestException {
        String resumePath = this.saveState(req, resp, inMsgCtx, outMsgCtx, otherState);
        try {
            ApiRedirectWrapper.WrapperParams wrapperParams = new ApiRedirectWrapper.WrapperParams(this.isLastApiStage(inMsgCtx, otherState), "DeviceAuthz");
            ApiRedirectWrapper<Boolean> wrapper = new ApiRedirectWrapper<Boolean>(req, resp, resumePath, otherState, inMsgCtx, outMsgCtx, this, wrapperParams);
            wrapper.wrap(() -> this.doStage(inMsgCtx, req, resp, outMsgCtx, otherState, userAttrs, resumePath));
        }
        catch (AuthnAdapterException | AuthorizationException | AuthnProcessorException e) {
            throw new ProcessRuntimeException("Unexpected error during device authorization", e);
        }
        finally {
            HttpServletRespProxy.clearRunnable(resp);
        }
    }

    private boolean isLastApiStage(InMessageContext inMsgCtx, Map<String, Object> otherState) throws AuthorizationRequestException {
        String stage = this.getStage(inMsgCtx, otherState);
        return STAGE_VALUE_APPROVAL.equals(stage) || MgmtFactory.getAuthzServerManager().getActivationCodeCheckMode() == ActivationCodeCheckMode.AFTER_AUTHENTICATION;
    }

    private boolean doStage(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx, Map<String, Object> otherState, AttributesHolder userAttrs, String resumePath) throws IOException, AuthorizationRequestException {
        String stage = this.getStage(inMsgCtx, otherState);
        if (AuthnApiSupport.getDefault().isApiRequest(req)) {
            AuthnPolicyUtil.getDefault().setCurrentAuthnPlugin(req, otherState, AuthnPluginKey.PF_CORE);
        }
        try {
            boolean done = false;
            do {
                String nextStage = null;
                switch (stage) {
                    case "oauth:device-flow:stage:get-user-code": {
                        nextStage = this.handleUserCode(inMsgCtx, req, resp, otherState, userAttrs, resumePath);
                        break;
                    }
                    case "oauth:device-flow:stage:verification-uri-complete": {
                        nextStage = this.handleVerificationUriComplete(inMsgCtx, req, resp, otherState, userAttrs, resumePath);
                        break;
                    }
                    case "oauth:device-flow:stage:ask-consent": {
                        if (userAttrs == null) break;
                        this.handleApproval(inMsgCtx, req, resp, outMsgCtx, otherState, userAttrs, resumePath);
                        break;
                    }
                    default: {
                        throw new ProcessRuntimeException("Unexpected stage in device authorization processing: " + stage);
                    }
                }
                InternalAuthnApiSupport.getDefault().setRequestBodyConsumed(req);
                if (req instanceof HttpServletReqProxy) {
                    ((HttpServletReqProxy)req).clearParameters();
                }
                if (nextStage == null) {
                    done = true;
                    continue;
                }
                stage = nextStage;
            } while (!done);
        }
        catch (AuthnErrorException e) {
            AuthnApiSupport.getDefault().writeErrorResponse(req, resp, e.getValidationError());
        }
        return true;
    }

    private String getStage(InMessageContext inMsgCtx, Map<String, Object> otherState) throws AuthorizationRequestException {
        String stage = (String)otherState.get(STAGE_KEY);
        if (stage == null) {
            stage = this.getInitialStage(inMsgCtx, otherState);
            otherState.put(STAGE_KEY, stage);
        }
        return stage;
    }

    private String handleUserCode(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> otherState, AttributesHolder userAttrs, String resumePath) throws AuthorizationRequestException, IOException, AuthnErrorException {
        if (this.checkRedirectAuthnApiApplication(req, resp, otherState, resumePath)) {
            return null;
        }
        DeviceAuthorizationState state = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        boolean isUserCodeValid = false;
        String userCode = inMsgCtx.getParam("user_code");
        if (this.isSubmitUserCode(req)) {
            if (!AuthnApiSupport.getDefault().isApiRequest(req)) {
                this.validateCSRF(req, otherState);
            }
            if (StringUtils.isBlank((String)(userCode = this.getUserCode(req)))) {
                params.put(VAR_ERROR_MESSAGE_KEY, MSG_USER_CODE_REQUIRED);
            }
        } else if (AuthnApiSupport.getDefault().isActionRequested(req)) {
            throw new AuthnErrorException(CommonErrorSpec.INVALID_ACTION_ID.makeInstance());
        }
        if (StringUtils.isNotBlank((String)userCode)) {
            boolean locked = this.isLocked(req, userAttrs);
            if (!locked) {
                state = this.getDeviceAuthorizationState(userCode);
                if (state == null) {
                    this.lockingService.logFailedLogin(this.getKey(req, userAttrs));
                }
            } else {
                this.log.warn((Object)"activation code validation is locked due to multiple invalid requests.");
            }
            if (locked) {
                this.log.debug((Object)"User request is locked due to multiple invalid requests, error message will be rendered.");
                params.put(VAR_ERROR_MESSAGE_KEY, MSG_USER_CODE_LOCKED);
            } else if (state == null || state.getAuthorized() != null) {
                this.log.debug((Object)"Device Authorization state not found, error message will be rendered.");
                params.put(VAR_ERROR_MESSAGE_KEY, MSG_USER_CODE_INVALID);
            }
            if (state != null && state.isExpired() && state.getAuthorized() == null) {
                this.log.debug((Object)"Device authorization timed out, error message will be rendered");
                params.put(VAR_ERROR_MESSAGE_KEY, MSG_USER_CODE_EXPIRED);
                String normalizeUserCode = this.deviceFlowManager.normalizeUserCode(state.getUserCode());
                this.keyValueStateSupport.removeValue(normalizeUserCode);
                this.keyValueStateSupport.removeValue(state.getDeviceCode());
            }
            inMsgCtx.getParams().remove("user_code");
            boolean bl = isUserCodeValid = state != null && !state.isExpired() && state.getAuthorized() == null;
        }
        if (isUserCodeValid) {
            this.handleUserCodeValidated(inMsgCtx, otherState, state);
            otherState.put(STAGE_KEY, STAGE_VALUE_APPROVAL);
            return STAGE_VALUE_APPROVAL;
        }
        this.renderUserCodeForm(inMsgCtx, req, resp, otherState, userAttrs, params, resumePath);
        return null;
    }

    private void renderUserCodeForm(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> otherState, AttributesHolder userAttrs, Map<String, Object> params, String resumePath) throws AuthorizationRequestException, IOException, AuthnErrorException {
        if (AuthnApiSupport.getDefault().isApiRequest(req)) {
            this.renderUserCodeState(req, resp, userAttrs, params);
        } else {
            this.renderUserCodeTemplate(inMsgCtx, req, resp, otherState, userAttrs, params, resumePath);
        }
    }

    private void renderUserCodeState(HttpServletRequest req, HttpServletResponse resp, AttributesHolder userAttrs, Map<String, Object> params) throws IOException, AuthnErrorException {
        String errorMessage;
        this.checkThrowAuthnErrorException(req, params);
        OAuthDeviceUserCodeRequired userCodeRequired = new OAuthDeviceUserCodeRequired();
        if (userAttrs != null && MgmtFactory.getAuthnApiManager().isIncludeUserInfoInResponses()) {
            UserKeyAttributes userKeyAttrs = userAttrs.getUserKeyAttributes();
            User user = new User();
            user.setUsername(userKeyAttrs.getUserNameValue());
            user.setId(userKeyAttrs.getUserKeyValue());
            userCodeRequired.setUser(user);
        }
        if ((errorMessage = (String)params.get(VAR_ERROR_MESSAGE_KEY)) != null) {
            userCodeRequired.setAuthnError(this.getAuthnErrorFromMessage(errorMessage));
        }
        AuthnState state = CommonStateSpec.OAUTH_DEVICE_USER_CODE_REQUIRED.makeInstance(req, (Object)userCodeRequired);
        AuthnApiSupport.getDefault().writeAuthnStateResponse(req, resp, state);
    }

    private void checkThrowAuthnErrorException(HttpServletRequest req, Map<String, Object> params) throws AuthnErrorException {
        if (!AuthnApiSupport.getDefault().isApiRequest(req) || !AuthnApiSupport.getDefault().isActionRequested(req)) {
            return;
        }
        String errorMessage = (String)params.get(VAR_ERROR_MESSAGE_KEY);
        if (errorMessage != null) {
            throw new AuthnErrorException(this.getAuthnErrorFromMessage(errorMessage));
        }
    }

    private AuthnError getAuthnErrorFromMessage(String errorMessage) {
        AuthnError authnError;
        switch (errorMessage) {
            case "message.user-code.invalid": {
                authnError = CommonErrorSpec.VALIDATION_ERROR.makeInstanceBuilder().detail(CommonErrorDetailSpec.INVALID_USER_CODE.makeInstance()).build();
                break;
            }
            case "message.user-code.expired": {
                authnError = CommonErrorSpec.REQUEST_FAILED.makeInstanceBuilder().detail(CommonErrorDetailSpec.USER_CODE_EXPIRED.makeInstance()).build();
                break;
            }
            case "message.user-code.locked": {
                authnError = CommonErrorSpec.REQUEST_FAILED.makeInstanceBuilder().detail(CommonErrorDetailSpec.USER_CODE_LOCKED.makeInstance()).build();
                break;
            }
            default: {
                authnError = CommonErrorSpec.UNEXPECTED_ERROR.makeInstanceBuilder().message(errorMessage).build();
            }
        }
        return authnError;
    }

    private void renderUserCodeTemplate(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> otherState, AttributesHolder userAttrs, Map<String, Object> params, String resumePath) throws AuthorizationRequestException {
        String cSRFToken = IDGenerator.rndAlphaNumeric(20);
        otherState.put("csrfToken", cSRFToken);
        params.put("cSRFToken", cSRFToken);
        if (userAttrs != null) {
            UserKeyAttributes userKeyAttrs = userAttrs.getUserKeyAttributes();
            String userKeyValue = userKeyAttrs.getUserKeyValue();
            params.put(VAR_USER_KEY_ATTRIBUTES, (Object)userKeyAttrs);
            params.put(VAR_USER_KEY, userKeyValue);
            params.put(VAR_USER_NAME, userKeyAttrs.getUserNameValue());
            params.put(VAR_GRANT_ATTRIBUTES, TemplateParamUtil.convertAttributeMapToTemplateParams(userKeyAttrs.getExtendedAttributes()));
        }
        params.put(VAR_ACTION, resumePath);
        try {
            req = HandlerUtil.checkUiLocalesForRequest(inMsgCtx, req);
            ResponseTemplateRenderer renderer = ResponseTemplateRenderer.getInstance();
            renderer.render(req, resp, OAUTH_DEVICE_USER_CODE_PAGE_TEMPLATE, params);
        }
        catch (ResponseTemplateRendererException e) {
            AsAuditLogger.setDescription(AuthorizationRequestException.Error.invalid_request);
            this.log.debug((Object)e);
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request);
        }
    }

    private void handleApproval(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx, Map<String, Object> otherState, AttributesHolder userAttrs, String resumePath) throws AuthorizationRequestException, IOException {
        Scope requestedScope;
        UserKeyAttributes userKeyAttrs = userAttrs.getUserKeyAttributes();
        String userKeyValue = userKeyAttrs.getUserKeyValue();
        String deviceCode = inMsgCtx.getParam("device_code");
        DeviceAuthorizationState state = (DeviceAuthorizationState)this.keyValueStateSupport.getValue(deviceCode);
        if (state == null) {
            this.log.error((Object)"Device Authorization state not found");
            AsAuditLogger.setDescription(AuthorizationRequestException.Error.invalid_request);
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request);
        }
        if (state.isExpired()) {
            this.log.error((Object)"Device Authorization timed out");
            AsAuditLogger.setDescription(AuthorizationRequestException.Error.invalid_request);
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request, "Device Authorization Request state expired");
        }
        Client client = this.getClient(state.getClientId());
        Scope approvedScope = requestedScope = state.getRequestedScope();
        AuthorizationDetails requestedAuthorizationDetails = state.getRequestedAuthorizationDetails();
        AuthorizationDetailsUtil.enrich(requestedAuthorizationDetails, req, client.getClientId(), requestedScope);
        AuthorizationDetailsUtil.updateOtherState(otherState, requestedAuthorizationDetails);
        AuthorizationDetails approvedAuthorizationDetails = requestedAuthorizationDetails;
        boolean granted = client.isBypassApprovalPage();
        boolean reuseConsent = this.authzServerMgr.isBypassAuthorizationForApprovedConsents();
        if (reuseConsent && !granted) {
            granted = this.oAuthConsentManager.isGranted(userKeyValue, client.getClientId(), approvedScope, approvedAuthorizationDetails);
        }
        if (!granted) {
            if (AuthnApiSupport.getDefault().isApiRequest(req)) {
                if (AuthnApiPolicyUtil.getDefault().isRedirectlessApiFlow(otherState)) {
                    throw new ProcessRuntimeException("The approval step requires browser interaction, which is not supported with the pi.flow response mode. A possible workaround is to enable 'Bypass Authorization Approval' in the device client configuration.");
                }
                AuthnApiSupport.getDefault().writeResumeResponse(req, resp, resumePath);
                return;
            }
            AuthorizationProcessor.AuthorizationResult result = this.getAuthorizationProcessor(inMsgCtx).doAuthorize(req, resp, inMsgCtx, outMsgCtx, otherState, client, userKeyValue, userKeyAttrs, requestedScope, requestedAuthorizationDetails);
            if (AuthorizationProcessor.AuthorizationResult.Status.DENY.getValue().equals(result.getStatus().getValue())) {
                this.log.debug((Object)"User denied authorization");
                state.setAuthorized(false);
                this.keyValueStateSupport.setValue(state.getDeviceCode(), (Object)state);
                AsAuditLogger.setDescription("User Denied Authorization");
                outMsgCtx.setSupplementalContext("attrs", userAttrs);
                if (reuseConsent) {
                    this.oAuthConsentManager.deny(userKeyValue, client.getClientId(), requestedScope, requestedAuthorizationDetails);
                }
                throw new AuthorizationRequestException(AuthorizationRequestException.Error.access_denied, "User Denied Authorization");
            }
            if (AuthorizationProcessor.AuthorizationResult.Status.ALLOW.getValue().equals(result.getStatus().getValue())) {
                granted = true;
                approvedScope = result.getApprovedScope();
                approvedAuthorizationDetails = result.getApprovedAuthorizationDetails();
                if (reuseConsent) {
                    this.oAuthConsentManager.createOrUpdate(userKeyValue, client.getClientId(), requestedScope, approvedScope, requestedAuthorizationDetails, approvedAuthorizationDetails);
                }
            }
        }
        if (granted) {
            this.log.debug((Object)"Device authorized successfully");
            boolean returnScopeInResp = this.isReturnScopeInResp(requestedScope, approvedScope);
            this.prepareOutCtx(req, resp, outMsgCtx, otherState, userAttrs, approvedScope, state, returnScopeInResp, approvedAuthorizationDetails);
            AuditLogger.setStatus("success");
        }
    }

    private void prepareOutCtx(HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx, Map<String, Object> otherState, AttributesHolder userAttrs, Scope approvedScope, DeviceAuthorizationState state, boolean returnScopeInResp, AuthorizationDetails approvedAuthorizationDetails) {
        String contextQualifier = (String)outMsgCtx.getSupplementalContext("ctxQ");
        UserKeyAttributes userKeyAttrs = userAttrs.getUserKeyAttributes();
        String userKey = userKeyAttrs.getUserKeyValue();
        AttributeMap extendedGrantAttrs = userKeyAttrs.getExtendedAttributes();
        AttributeMap authnContextAttrs = UserKeyToAccessTokenMapping.pruneUnreferencedAttrs(userAttrs.getAuthnResult().getAuthnAttrs(), contextQualifier);
        AccessGrantAttributesHolder grantAttrsHolder = new AccessGrantAttributesHolder(extendedGrantAttrs, authnContextAttrs);
        String sri = StateMgmtFactory.getExtendedSriV2(req, resp, otherState);
        DeviceAuthorizationState.Result result = new DeviceAuthorizationState.Result(userKey, approvedScope, grantAttrsHolder, contextQualifier, returnScopeInResp, sri, approvedAuthorizationDetails);
        outMsgCtx.setSupplementalContext("DEVICE-AUTHZ-RESULT-STATE", result);
        outMsgCtx.setSupplementalContext("device_code", state.getDeviceCode());
        outMsgCtx.setSupplementalContext("attrs", userAttrs);
    }

    private String getKey(HttpServletRequest req, AttributesHolder attributesHolder) {
        String key = req.getRemoteAddr();
        if (attributesHolder != null && MgmtFactory.getAuthzServerManager().getActivationCodeCheckMode() == ActivationCodeCheckMode.AFTER_AUTHENTICATION) {
            key = AccountLockingService.getUserKey(req.getRemoteAddr(), attributesHolder.getUserKeyAttributes().getUserKeyValue());
        }
        return key;
    }

    private String handleVerificationUriComplete(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> otherState, AttributesHolder userAttrs, String resumePath) throws AuthorizationRequestException, IOException, AuthnErrorException {
        String ctxUserCode;
        if (this.checkRedirectAuthnApiApplication(req, resp, otherState, resumePath)) {
            return null;
        }
        String userCode = ctxUserCode = inMsgCtx.getParam("user_code");
        boolean isUserCodeValid = false;
        DeviceAuthorizationState state = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (userAttrs != null && userAttrs.getUserKeyAttributes() != null) {
            params.put(VAR_GRANT_ATTRIBUTES, TemplateParamUtil.convertAttributeMapToTemplateParams(userAttrs.getUserKeyAttributes().getExtendedAttributes()));
        }
        if (this.isConfirmUserCode(req)) {
            if (!AuthnApiSupport.getDefault().isApiRequest(req)) {
                this.validateCSRF(req, otherState);
            }
            if (StringUtils.isBlank((String)(userCode = this.getConfirmedUserCode(req)))) {
                this.log.warn((Object)"confirmed user-code is required");
                throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request, "user-code is required");
            }
            if (!ctxUserCode.equals(userCode)) {
                this.log.warn((Object)"provided user code by 'verification_uri_complete' does not match with the confirmed one.");
                throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request, "user-code is modified");
            }
            if (StringUtils.isNotBlank((String)userCode)) {
                state = this.getDeviceAuthorizationState(userCode);
                if (state == null || state.getAuthorized() != null) {
                    this.log.debug((Object)"Device Authorization state not found, error message will be rendered.");
                    throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request, "Device Authorization Request state not found");
                }
                if (state.isExpired() && state.getAuthorized() == null) {
                    this.log.debug((Object)"Device Authorization timed out, error message will be rendered");
                    String normalizeUserCode = this.deviceFlowManager.normalizeUserCode(state.getUserCode());
                    this.keyValueStateSupport.removeValue(normalizeUserCode);
                    this.keyValueStateSupport.removeValue(state.getDeviceCode());
                    throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request, "Device Authorization Request state expired");
                }
                inMsgCtx.getParams().remove("user_code");
                isUserCodeValid = !state.isExpired() && state.getAuthorized() == null;
            }
        } else if (AuthnApiSupport.getDefault().isActionRequested(req)) {
            throw new AuthnErrorException(CommonErrorSpec.INVALID_ACTION_ID.makeInstance());
        }
        if (isUserCodeValid) {
            this.handleUserCodeValidated(inMsgCtx, otherState, state);
            otherState.put(STAGE_KEY, STAGE_VALUE_APPROVAL);
            return STAGE_VALUE_APPROVAL;
        }
        params.put(VAR_USER_CODE, userCode);
        this.renderConfirmUserCodeForm(inMsgCtx, req, resp, otherState, userAttrs, params, resumePath);
        return null;
    }

    private void renderConfirmUserCodeForm(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> otherState, AttributesHolder userAttrs, Map<String, Object> params, String resumePath) throws AuthorizationRequestException, IOException {
        if (AuthnApiSupport.getDefault().isApiRequest(req)) {
            this.renderConfirmUserCodeState(req, resp, userAttrs, params);
        } else {
            this.renderConfirmUserCodeTemplate(inMsgCtx, req, resp, otherState, userAttrs, params, resumePath);
        }
    }

    private void renderConfirmUserCodeState(HttpServletRequest req, HttpServletResponse resp, AttributesHolder userAttrs, Map<String, Object> params) throws IOException {
        OAuthDeviceUserCodeConfirmationRequired userCodeConfirmationRequired = new OAuthDeviceUserCodeConfirmationRequired();
        if (userAttrs != null && MgmtFactory.getAuthnApiManager().isIncludeUserInfoInResponses()) {
            UserKeyAttributes userKeyAttrs = userAttrs.getUserKeyAttributes();
            User user = new User();
            user.setUsername(userKeyAttrs.getUserNameValue());
            user.setId(userKeyAttrs.getUserKeyValue());
            userCodeConfirmationRequired.setUser(user);
        }
        userCodeConfirmationRequired.setUserCode((String)params.get(VAR_USER_CODE));
        AuthnState state = CommonStateSpec.OAUTH_DEVICE_USER_CODE_CONFIRMATION_REQUIRED.makeInstance(req, (Object)userCodeConfirmationRequired);
        AuthnApiSupport.getDefault().writeAuthnStateResponse(req, resp, state);
    }

    private void renderConfirmUserCodeTemplate(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> otherState, AttributesHolder userAttrs, Map<String, Object> params, String resumePath) throws AuthorizationRequestException {
        String cSRFToken = IDGenerator.rndAlphaNumeric(20);
        otherState.put("csrfToken", cSRFToken);
        params.put("cSRFToken", cSRFToken);
        if (userAttrs != null) {
            UserKeyAttributes userKeyAttrs = userAttrs.getUserKeyAttributes();
            String userKeyValue = userKeyAttrs.getUserKeyValue();
            params.put(VAR_USER_KEY_ATTRIBUTES, (Object)userKeyAttrs);
            params.put(VAR_USER_KEY, userKeyValue);
            params.put(VAR_USER_NAME, userKeyAttrs.getUserNameValue());
        }
        params.put(VAR_ACTION, resumePath);
        try {
            req = HandlerUtil.checkUiLocalesForRequest(inMsgCtx, req);
            ResponseTemplateRenderer renderer = ResponseTemplateRenderer.getInstance();
            renderer.render(req, resp, OAUTH_DEVICE_USER_CODE_CONFIRM_PAGE_TEMPLATE, params);
        }
        catch (ResponseTemplateRendererException e) {
            AsAuditLogger.setDescription(AuthorizationRequestException.Error.invalid_request);
            this.log.debug((Object)e);
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request);
        }
    }

    private String getInitialStage(InMessageContext inMsgCtx, Map<String, Object> otherState) throws AuthorizationRequestException {
        DeviceAuthorizationState state;
        String userCode = inMsgCtx.getParam("user_code");
        if (StringUtils.isNotBlank((String)userCode) && (state = this.getDeviceAuthorizationState(userCode)) != null) {
            Client client = this.clientManager.getCachedClient(state.getClientId());
            if (!this.isBypassActivationCodeConfirmation(client)) {
                return STAGE_VALUE_VERIFICATION_URI_COMPLETE;
            }
            if (!state.isExpired() && state.getAuthorized() == null) {
                this.handleUserCodeValidated(inMsgCtx, otherState, state);
                return STAGE_VALUE_APPROVAL;
            }
        }
        return STAGE_VALUE_GET_USER_CODE;
    }

    private boolean isBypassActivationCodeConfirmation(Client client) {
        if ("SERVER_DEFAULT".equals(client.getDeviceFlowSettingType()) && this.authzServerMgr.isBypassActivationCodeConfirmation()) {
            return true;
        }
        return "OVERRIDE_SERVER_DEFAULT".equals(client.getDeviceFlowSettingType()) && client.getBypassActivationCodeConfirmationOverride() != null && client.getBypassActivationCodeConfirmationOverride() != false;
    }

    private DeviceAuthorizationState getDeviceAuthorizationState(String userCode) {
        String normalizeUserCode = this.deviceFlowManager.normalizeUserCode(userCode);
        String deviceCode = (String)this.keyValueStateSupport.getValue(normalizeUserCode);
        if (StringUtils.isNotBlank((String)deviceCode)) {
            return (DeviceAuthorizationState)this.keyValueStateSupport.getValue(deviceCode);
        }
        return null;
    }

    private boolean checkRedirectAuthnApiApplication(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> otherState, String resumePath) throws IOException {
        if (!this.isEnableAuthnApiForUserCodeValidation()) {
            return false;
        }
        AuthnApiApplication authnApiApplication = AuthnApiPolicyUtil.getDefault().getEffectiveAuthnApiApplication(otherState);
        if (authnApiApplication != null && !AuthnApiSupport.getDefault().isApiRequest(req)) {
            StateSupport stateSupport = new StateSupport(MetaDataFactory.getLocalMetaData());
            AuthnApiPolicyUtil.getDefault().redirectAuthnApiApplication(resp, stateSupport.getContextId(resumePath), authnApiApplication);
            return true;
        }
        return false;
    }

    private boolean isEnableAuthnApiForUserCodeValidation() {
        return this.config.getBooleanValue("enable-authn-api-for-user-code-validation", true);
    }

    private boolean isLocked(HttpServletRequest req, AttributesHolder userAttrs) {
        if (MgmtFactory.getAuthzServerManager().getActivationCodeCheckMode() == ActivationCodeCheckMode.BEFORE_AUTHENTICATION) {
            int maxFailedLogins = this.config.getIntValue(MAX_PRE_AUTHENTICATION_FAILURES_KEY, 1000);
            int lockoutPeriod = this.config.getIntValue(PRE_AUTHENTICATION_LOCKOUT_PERIOD_KEY, 1);
            return this.lockingService.isLocked(this.getKey(req, userAttrs), maxFailedLogins, lockoutPeriod);
        }
        int maxFailedLogins = this.config.getIntValue(MAX_CONSECUTIVE_FAILURES_KEY, 6);
        int lockoutPeriod = this.config.getIntValue(LOCKOUT_PERIOD_KEY, 1);
        return this.lockingService.isLocked(this.getKey(req, userAttrs), maxFailedLogins, lockoutPeriod);
    }

    private boolean isSubmitUserCode(HttpServletRequest req) {
        if (AuthnApiSupport.getDefault().isApiRequest(req)) {
            return CommonActionSpec.SUBMIT_USER_CODE.isRequested(req);
        }
        String submit = req.getParameter(OK_FIELD_NAME);
        return OK_FIELD_CLICKED_VALUE.equals(submit);
    }

    private boolean isConfirmUserCode(HttpServletRequest req) {
        if (AuthnApiSupport.getDefault().isApiRequest(req)) {
            return CommonActionSpec.CONFIRM_USER_CODE.isRequested(req);
        }
        String submit = req.getParameter(OK_FIELD_NAME);
        return OK_FIELD_CLICKED_VALUE.equals(submit);
    }

    private String getUserCode(HttpServletRequest req) throws AuthnErrorException, IOException {
        if (AuthnApiSupport.getDefault().isApiRequest(req)) {
            SubmitUserCode submitUserCode = (SubmitUserCode)AuthnApiSupport.getDefault().deserializeAsModel(req, SubmitUserCode.class);
            return submitUserCode.getUserCode();
        }
        return req.getParameter(USER_CODE_FIELD_NAME);
    }

    private String getConfirmedUserCode(HttpServletRequest req) throws AuthnErrorException, IOException {
        if (AuthnApiSupport.getDefault().isApiRequest(req)) {
            ConfirmUserCode confirmUserCode = (ConfirmUserCode)AuthnApiSupport.getDefault().deserializeAsModel(req, ConfirmUserCode.class);
            return confirmUserCode.getUserCode();
        }
        return req.getParameter(USER_CODE_FIELD_NAME);
    }

    private void handleUserCodeValidated(InMessageContext inMsgCtx, Map<String, Object> otherState, DeviceAuthorizationState deviceAuthzState) throws AuthorizationRequestException {
        inMsgCtx.getParams().remove("user_code");
        inMsgCtx.setEntityId(deviceAuthzState.getClientId());
        inMsgCtx.setParam(Parameters.SCOPE, deviceAuthzState.getRequestedScope().getScopeStr());
        inMsgCtx.setParam("device_code", deviceAuthzState.getDeviceCode(), false);
        if (deviceAuthzState.getRequestedAuthorizationDetails() != null) {
            inMsgCtx.setParam("authorization_details", deviceAuthzState.getRequestedAuthorizationDetails().toJson());
        }
        AsAuditLogger.setPartnerId(deviceAuthzState.getClientId());
        Client client = this.getClient(deviceAuthzState.getClientId());
        otherState.put(Parameters.CLIENT_ID, client.getClientId());
        otherState.put("applicationName", client.getName());
        otherState.put("applicationIcon", client.getLogoUrl());
        otherState.put(Parameters.SCOPE, deviceAuthzState.getRequestedScope().getScopeStr());
        AuthorizationDetailsUtil.updateOtherState(otherState, deviceAuthzState.getRequestedAuthorizationDetails());
    }
}

