/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers.process;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.handlers.AccessTokenRequestException;
import org.sourceid.oauth20.handlers.TokenManagerSelector;
import org.sourceid.oauth20.handlers.process.GrantContext;
import org.sourceid.oauth20.handlers.process.GrantProcessor;
import org.sourceid.oauth20.protocol.GrantParamHelper;
import org.sourceid.oauth20.token.TokenResponse;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.websso.servlet.reqparam.InvalidRequestParameterException;
import org.sourceid.websso.wrapper.InMessageContext;

public abstract class AbstractTokenValidateProcessor
implements GrantProcessor {
    public static final String TOKEN = "token";
    private final BearerAccessTokenMgmtPluginManager tokenManager;

    public AbstractTokenValidateProcessor(BearerAccessTokenMgmtPluginManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    @Override
    public GrantContext processGrant(InMessageContext ctx, HttpServletRequest req, HttpServletResponse resp, Client client, String grantType) throws AccessTokenRequestException {
        List<String> tokenManagerIds;
        if (client.getClientId() == null) {
            Object errorMsg = "This endpoint requires client authentication";
            if (!StringUtils.isEmpty((String)grantType)) {
                errorMsg = grantType + " requires client authentication";
            }
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_client, (String)errorMsg);
        }
        TokenManagerSelector selector = new TokenManagerSelector();
        try {
            tokenManagerIds = selector.selectTokenManagerIdsForValidation(ctx, null, client);
        }
        catch (InvalidRequestParameterException e) {
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_request, e.getMessage(), e);
        }
        String tokenString = GrantParamHelper.getParam(req, TOKEN, true, grantType);
        String tokenTypeHint = GrantParamHelper.getParam(req, "token_type_hint", false, grantType);
        return new GrantContext<TokenResponse>(this.translateGrant(client, tokenString, tokenManagerIds, tokenTypeHint, req));
    }

    abstract TokenResponse translateGrant(Client var1, String var2, List<String> var3, String var4, HttpServletRequest var5) throws AccessTokenRequestException;

    BearerAccessTokenMgmtPluginManager getTokenManager() {
        return this.tokenManager;
    }
}

