/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers.process;

import com.pingidentity.common.util.Base64URL;
import com.pingidentity.sdk.oauth20.Scope;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jose4j.base64url.Base64Url;
import org.sourceid.common.HashAlgorithm;
import org.sourceid.common.HashUtil;
import org.sourceid.oauth20.authorizationdetails.domain.AuthorizationDetailsUtil;
import org.sourceid.oauth20.bindings.StoredMessage;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.dpop.DpopUtil;
import org.sourceid.oauth20.handlers.AccessTokenRequestException;
import org.sourceid.oauth20.handlers.TokenManagerSelector;
import org.sourceid.oauth20.handlers.process.ClientAwareGrantProcessor;
import org.sourceid.oauth20.handlers.process.GrantContext;
import org.sourceid.oauth20.handlers.process.GrantProcessor;
import org.sourceid.oauth20.protocol.GrantParamHelper;
import org.sourceid.oauth20.protocol.HttpRequestUtil;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.oauth20.utils.ResourceIndicatorsUtils;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.ArtifactPersistenceService;
import org.sourceid.saml20.service.ArtifactPersistenceServiceException;
import org.sourceid.util.UriValidationUtil;
import org.sourceid.websso.profiles.idp.AsAuditLogger;
import org.sourceid.websso.servlet.reqparam.InvalidRequestParameterException;
import org.sourceid.websso.wrapper.InMessageContext;

public class AuthzCodeGrantProcessor
extends ClientAwareGrantProcessor
implements GrantProcessor {
    private ArtifactPersistenceService persistenceSvc;
    private AuthzServerManager authzServerManager;
    private final BearerAccessTokenMgmtPluginManager tokenManager = MgmtFactory.getBearerAccessTokenMgmtPluginMgr();

    public AuthzCodeGrantProcessor(ArtifactPersistenceService persistenceSvc, AuthzServerManager authzServerManager, ClientManager clientMgr) {
        super(clientMgr);
        this.persistenceSvc = persistenceSvc;
        this.authzServerManager = authzServerManager;
    }

    @Override
    public GrantContext processGrant(InMessageContext ctx, HttpServletRequest req, HttpServletResponse resp, Client client, String grantType) throws AccessTokenRequestException {
        String code = GrantParamHelper.getParam(req, "code", true, grantType);
        String redirectUri = GrantParamHelper.getParam(req, "redirect_uri", false, grantType);
        String codeVerifier = HttpRequestUtil.getParameter(req, "code_verifier");
        return this.processGrant(code, redirectUri, client, codeVerifier, ctx);
    }

    private GrantContext processGrant(String code, String redirectUri, Client client, String codeVerifier, InMessageContext ctx) throws AccessTokenRequestException {
        StoredMessage msg;
        String requestedAtmId = ctx.getParam("access_token_manager_id");
        String requestedAudience = ctx.getParam("aud");
        Set<String> requestedResources = ctx.getParam("resource", Set.class);
        AsAuditLogger.setInAuthorizationCodeHash(code);
        byte[] bytes = Base64URL.decode((String)code);
        if (bytes == null || bytes.length != this.authzServerManager.getAuthzCodeLength() || !Base64URL.encodeToString((byte[])bytes).equals(code)) {
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, "Authorization code is malformed.");
        }
        if (client.getClientId() == null) {
            String msg2 = "Client authentication (if the client has credentials) or the " + Parameters.CLIENT_ID + " parameter is required for an authorization request using the code grant type.";
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_client, msg2);
        }
        try {
            ArtifactPersistenceService.Message message = this.persistenceSvc.retrieveAndRemoveArtifact(bytes);
            if (message == null) {
                AsAuditLogger.setDescription("Authorization Code Invalid or Expired");
                throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, "Authorization code is invalid or expired.");
            }
            msg = (StoredMessage)message.getMsg();
        }
        catch (ArtifactPersistenceServiceException e) {
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, "Unexpected problem looking up authorization code.", e);
        }
        if (!StringUtils.isBlank((String)codeVerifier)) {
            if (StringUtils.length((String)codeVerifier) < 43 || StringUtils.length((String)codeVerifier) > 128) {
                throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, "code_verifier must be between 43 and 128 characters.");
            }
            Pattern r = Pattern.compile("^[a-zA-Z_0-9\\-\\.\\_\\~]+$");
            Matcher m = r.matcher(codeVerifier);
            if (!m.find()) {
                throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, "code_verifier must contain only: alphanumeric, '-', '.', '_', '~'");
            }
        }
        if (StringUtils.isBlank((String)msg.getCodeChallengeMethod()) || msg.getCodeChallengeMethod().equals("plain")) {
            if (!StringUtils.equals((String)codeVerifier, (String)msg.getCodeChallenge())) {
                String errMsg = "The code_verifier sent does not match code_challenge included in the authorization request using the plain code_challenge_method.";
                throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, errMsg);
            }
        } else if (msg.getCodeChallengeMethod().equals("S256")) {
            String errMsgMismatch = "The code_verifier sent does not match code_challenge included in the authorization request using the S256 code_challenge_method.";
            if (codeVerifier == null) {
                throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, errMsgMismatch);
            }
            String hashed = Base64Url.encode((byte[])HashUtil.hashToBytes((String)codeVerifier, (HashAlgorithm)HashAlgorithm.SHA256));
            if (!StringUtils.equals((String)msg.getCodeChallenge(), (String)hashed)) {
                throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, errMsgMismatch);
            }
        } else {
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, "code_challenge_method must be 'plain' or 'S256'");
        }
        this.validateDpopBoundAuthorizationCode(msg, ctx);
        this.validateResources(msg, ctx);
        Scope scope = Scope.getScope((String)msg.getScope());
        if (requestedAtmId == null && requestedAudience == null && CollectionUtils.isEmpty((Collection)requestedResources)) {
            requestedAtmId = msg.getRequestedTokenManagerId();
            requestedAudience = msg.getAudience();
            requestedResources = msg.getResources();
        }
        TokenManagerSelector selector = new TokenManagerSelector();
        String tokenManagerId = null;
        try {
            tokenManagerId = selector.selectTokenManagerId(selector.getEligibleTokenManagerIdsForContext(msg.getQualifier()), requestedAtmId, requestedAudience, requestedResources, scope, client);
        }
        catch (InvalidRequestParameterException e) {
            throw new AccessTokenRequestException(e);
        }
        GrantContext context = new GrantContext(msg.getUserKeyValue(), msg.getAccessGrantAttributes(), scope, msg.isReturnScope(), msg.getQualifier(), tokenManagerId);
        if (client.getClientId() == null) {
            context.setContextClientId(msg.getClientId());
        }
        client = this.evalGrantClientToIdentifiedClient(client, msg.getClientId(), "Client id does not match the id of the client to whom the authorization code was issued.");
        if (!StringUtils.isBlank((String)msg.getRedirectUri())) {
            if (StringUtils.isEmpty((String)redirectUri)) {
                String s = "redirect_uri is required if it was included in the authorization request.";
                throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, s);
            }
            if (!UriValidationUtil.compareUrisEqual(redirectUri, msg.getRedirectUri())) {
                String s = "redirect_uri value must be identical to the value included in the authorization request.";
                throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, s);
            }
        } else if (!StringUtils.isBlank((String)redirectUri) && !UriValidationUtil.compareAsUris(redirectUri, client.getRedirectUris(), false, false)) {
            String s = "redirect_uri value must match client's registered redirect URI";
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, s);
        }
        if (msg.getIdToken() != null) {
            context.setAdditionalParameters(Collections.singletonMap("id_token", msg.getIdToken()));
            if (msg.getIdTokenJti() != null) {
                AsAuditLogger.setIdTokenJti(msg.getIdTokenJti());
            }
        }
        context.setAuthenticationClaims(msg.getAuthenticationClaimHolder());
        context.setAuthRequestResponseType(msg.getAuthRequestResponseType());
        if (msg.getSri() != null) {
            context.setSri(msg.getSri());
        }
        context.setAuthorizationDetails(AuthorizationDetailsUtil.getAuthorizationDetails(msg.getAuthorizationDetails()));
        context.setResourcesForMapping(requestedResources);
        context.setResourcesForAccessGrant(msg.getResources());
        return context;
    }

    private void validateDpopBoundAuthorizationCode(StoredMessage msg, InMessageContext inMsgCtx) throws AccessTokenRequestException {
        String jwkThumbprintFromAuthorizationRequest = msg.getDpopJkt();
        if (jwkThumbprintFromAuthorizationRequest == null) {
            return;
        }
        String jwkThumbprintFromTokenRequest = inMsgCtx.getParam("dpop_jkt");
        if (jwkThumbprintFromTokenRequest == null) {
            AsAuditLogger.setDescription("DPoP header not found");
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_dpop_proof, "DPoP header not found");
        }
        if (!DpopUtil.isJwkThumbprintMatching(jwkThumbprintFromAuthorizationRequest, jwkThumbprintFromTokenRequest)) {
            AsAuditLogger.setDescription("The public key in DPoP proof does not match the public key bound to the authorization code");
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_dpop_proof, "The public key in DPoP proof does not match the public key bound to the authorization code");
        }
    }

    private void validateResources(StoredMessage msg, InMessageContext inMsgCtx) throws AccessTokenRequestException {
        Set requestedResources = inMsgCtx.getParam("resource", Set.class);
        Set<String> authorizedResources = msg.getResources();
        ResourceIndicatorsUtils.validateResourcesAuthorized(requestedResources, authorizedResources);
    }
}

