/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers.process;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.handlers.AccessTokenRequestException;
import org.sourceid.websso.profiles.idp.AsAuditLogger;

public abstract class ClientAwareGrantProcessor {
    Log log = LogFactory.getLog(this.getClass());
    private ClientManager clientMgr;

    protected ClientAwareGrantProcessor(ClientManager clientMgr) {
        this.clientMgr = clientMgr;
    }

    protected Client evalGrantClientToIdentifiedClient(Client client, String grantImpliedClientId, String invalidGrantMsg) throws AccessTokenRequestException {
        if (client.getClientId() != null) {
            if (!StringUtils.equals((String)client.getClientId(), (String)grantImpliedClientId)) {
                throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, invalidGrantMsg);
            }
        } else {
            try {
                client = this.clientMgr.getCachedClient(grantImpliedClientId);
            }
            catch (ClientManager.ClientManagementException e) {
                AsAuditLogger.log("Database Exception");
                throw e;
            }
            if (client == null) {
                String msg = String.format("Client '%s' that was associated with the grant is no longer valid.", grantImpliedClientId);
                throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, msg);
            }
        }
        return client;
    }
}

