/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers.process;

import java.util.Collection;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.config.ConfigStore;
import org.sourceid.oauth20.device.DeviceAuthorizationState;
import org.sourceid.oauth20.device.DeviceFlowManager;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.handlers.AccessTokenRequestException;
import org.sourceid.oauth20.handlers.TokenManagerSelector;
import org.sourceid.oauth20.handlers.process.ClientAwareGrantProcessor;
import org.sourceid.oauth20.handlers.process.GrantContext;
import org.sourceid.oauth20.handlers.process.GrantProcessor;
import org.sourceid.oauth20.protocol.GrantParamHelper;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.saml20.adapter.state.KeyValueStateSupport;
import org.sourceid.websso.profiles.idp.AsAuditLogger;
import org.sourceid.websso.servlet.reqparam.InvalidRequestParameterException;
import org.sourceid.websso.wrapper.InMessageContext;

public class DeviceCodeGrantProcessor
extends ClientAwareGrantProcessor
implements GrantProcessor {
    private final AuthzServerManager authzServerManager;
    private final KeyValueStateSupport keyValueStateSupport;
    private final DeviceFlowManager deviceFlowManager;
    private final ConfigStore configStore;
    public static final String AUDIT_AUTHORIZATION_PENDING_RESPONSE_ATTR = "audit-authorization-pending-response";
    public static final boolean AUDIT_AUTHORIZATION_PENDING_RESPONSE_DEFAULT_VALUE = false;

    public DeviceCodeGrantProcessor(ClientManager clientMgr, AuthzServerManager authzServerManager, KeyValueStateSupport keyValueStateSupport, DeviceFlowManager deviceFlowManager, ConfigStore configStore) {
        super(clientMgr);
        this.authzServerManager = authzServerManager;
        this.keyValueStateSupport = keyValueStateSupport;
        this.deviceFlowManager = deviceFlowManager;
        this.configStore = configStore;
    }

    @Override
    public GrantContext processGrant(InMessageContext ctx, HttpServletRequest req, HttpServletResponse resp, Client client, String grantType) throws AccessTokenRequestException {
        if (client.getClientId() == null) {
            String msg = "Client authentication (if the client has credentials) or the " + Parameters.CLIENT_ID + " parameter is required for an authorization request using the Device Authorization grant type.";
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_client, msg);
        }
        String deviceCode = GrantParamHelper.getParam(req, "device_code", true, grantType);
        DeviceAuthorizationState state = (DeviceAuthorizationState)this.keyValueStateSupport.getValue(deviceCode);
        this.validateState(deviceCode, state);
        String invalidGrantMsg = "Client id does not match the id of the client to whom the device code was issued.";
        client = this.evalGrantClientToIdentifiedClient(client, state.getClientId(), invalidGrantMsg);
        if (state.getAuthorized() == null) {
            boolean doAudit = this.configStore.getBooleanValue(AUDIT_AUTHORIZATION_PENDING_RESPONSE_ATTR, false);
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.authorization_pending, "Pending user authorization", doAudit);
        }
        state = (DeviceAuthorizationState)this.keyValueStateSupport.removeValue(deviceCode);
        String normalizeUserCode = this.deviceFlowManager.normalizeUserCode(state.getUserCode());
        this.keyValueStateSupport.removeValue(normalizeUserCode);
        this.validateState(deviceCode, state);
        if (!state.getAuthorized().booleanValue()) {
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.access_denied, "Authorization request is denied");
        }
        String requestedAtmId = ctx.getParam("access_token_manager_id");
        String requestedAudience = ctx.getParam("aud");
        Set requestedResources = ctx.getParam("resource", Set.class);
        return this.processGrant(client, state, requestedAtmId, requestedAudience, requestedResources);
    }

    private GrantContext processGrant(Client client, DeviceAuthorizationState state, String requestedAtmId, String requestedAudience, Set<String> requestedResources) throws AccessTokenRequestException {
        TokenManagerSelector selector = new TokenManagerSelector();
        try {
            DeviceAuthorizationState.Result result = state.getResult();
            Collection<String> eligibleTokenMgrIds = selector.getEligibleTokenManagerIdsForContext(result.getCtxQualifier());
            String tokenManagerId = selector.selectTokenManagerId(eligibleTokenMgrIds, requestedAtmId, requestedAudience, requestedResources, result.getApprovedScope(), client);
            GrantContext context = new GrantContext(result.getUserKey(), result.getGrantAttrHolder(), result.getApprovedScope(), result.isReturnScope(), result.getCtxQualifier(), tokenManagerId, result.getApprovedAuthorizationDetails());
            context.setResourcesForMapping(requestedResources);
            context.setResourcesForAccessGrant(requestedResources);
            context.setAllowIdToken(this.authzServerManager.isReturnIdTokenOnOpenIdWithDeviceAuthorizationGrant());
            if (result.getSri() != null) {
                context.setSri(result.getSri());
            }
            return context;
        }
        catch (InvalidRequestParameterException e) {
            throw new AccessTokenRequestException(e);
        }
    }

    private void validateState(String deviceCode, DeviceAuthorizationState state) throws AccessTokenRequestException {
        if (state == null) {
            AsAuditLogger.setDescription("Device Code Invalid or Expired");
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, "Device code not found, expired or invalid");
        }
        if (state.isExpired()) {
            String normalizeUserCode = this.deviceFlowManager.normalizeUserCode(state.getUserCode());
            this.keyValueStateSupport.removeValue(normalizeUserCode);
            this.keyValueStateSupport.removeValue(deviceCode);
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.expired_token, "The authorization request has expired.");
        }
    }
}

