/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers.process;

import com.pingidentity.sdk.accessgrant.AccessGrant;
import com.pingidentity.sdk.accessgrant.AccessGrantManager;
import com.pingidentity.sdk.accessgrant.exception.AccessGrantManagementException;
import com.pingidentity.sdk.oauth20.AccessToken;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.PersistentGrantLifetimeHelper;
import org.sourceid.oauth20.dpop.DpopUtil;
import org.sourceid.oauth20.handlers.AccessTokenRequestException;
import org.sourceid.oauth20.handlers.process.AbstractTokenValidateProcessor;
import org.sourceid.oauth20.handlers.process.GrantContext;
import org.sourceid.oauth20.handlers.process.introspection.IdTokenIntrospectionRequestTokenProcessor;
import org.sourceid.oauth20.issuer.OAuthIssuerUtils;
import org.sourceid.oauth20.token.AccessTokenWrapper;
import org.sourceid.oauth20.token.TokenIntrospectResponse;
import org.sourceid.openid.connect.domain.ConnectProviderRuntimePolicySupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.profiles.idp.AsAuditLogger;
import org.sourceid.websso.wrapper.InMessageContext;

public class IntrospectBearerTokenProcessor
extends AbstractTokenValidateProcessor {
    private static final Log log = LogFactory.getLog(IntrospectBearerTokenProcessor.class);
    private static final TokenIntrospectResponse.Builder DEFAULT_RESPONSE_BUILDER = new TokenIntrospectResponse.Builder(false).setTokenType(null);
    private final boolean refreshTokensWithoutHint;
    private final AccessGrantManager accessGrantManager;
    private final ConnectProviderRuntimePolicySupport connectProviderRuntimePolicySupport;
    private final OAuthIssuerUtils oAuthIssuerUtils;

    public IntrospectBearerTokenProcessor(BearerAccessTokenMgmtPluginManager tokenManager, AccessGrantManager accessGrantManager, ConnectProviderRuntimePolicySupport connectProviderRuntimePolicySupport, OAuthIssuerUtils oAuthIssuerUtils) {
        super(tokenManager);
        this.accessGrantManager = accessGrantManager;
        this.connectProviderRuntimePolicySupport = connectProviderRuntimePolicySupport;
        this.oAuthIssuerUtils = oAuthIssuerUtils;
        ConfigStore config = ConfigStoreFarm.getConfig("oauth-introspect-endpoint");
        this.refreshTokensWithoutHint = config.getBooleanValue("checkRefreshTokensWithoutHint", false);
    }

    @Override
    TokenIntrospectResponse translateGrant(Client client, String tokenString, List<String> tokenManagerIds, String tokenTypeHint, HttpServletRequest req) throws AccessTokenRequestException {
        TokenIntrospectResponse response;
        if (StringUtils.isNotBlank((String)tokenTypeHint)) {
            log.debug((Object)("Using token_type_hint: " + tokenTypeHint));
            switch (tokenTypeHint) {
                case "access_token": {
                    response = this.getAccessTokenResponse(client, tokenString, tokenManagerIds);
                    if (response == null) break;
                    AsAuditLogger.setAccessTokenTrackingId(tokenString);
                    AsAuditLogger.setInAccessTokenHash(tokenString);
                    return response;
                }
                case "refresh_token": {
                    response = this.getRefreshTokenResponse(client, tokenString);
                    if (response == null) break;
                    AsAuditLogger.setInRefreshTokenHash(tokenString);
                    return response;
                }
                case "id_token": {
                    IdTokenIntrospectionRequestTokenProcessor idTokenIntrospectionRequestTokenProcessor = new IdTokenIntrospectionRequestTokenProcessor(client, req, this.connectProviderRuntimePolicySupport, this.oAuthIssuerUtils);
                    Optional<TokenIntrospectResponse> responseOptional = idTokenIntrospectionRequestTokenProcessor.processToken(tokenString);
                    if (!responseOptional.isPresent()) break;
                    TokenIntrospectResponse response2 = responseOptional.get();
                    AsAuditLogger.setIdTokenJti(response2.getTokenId());
                    return response2;
                }
            }
            log.debug((Object)String.format("Did not find a valid token for the token type hint: %s. Attempting other token types.", tokenTypeHint));
        } else {
            tokenTypeHint = "";
        }
        if (!tokenTypeHint.equals("access_token") && (response = this.getAccessTokenResponse(client, tokenString, tokenManagerIds)) != null) {
            AsAuditLogger.setAccessTokenTrackingId(tokenString);
            AsAuditLogger.setInAccessTokenHash(tokenString);
            return response;
        }
        if (this.refreshTokensWithoutHint && !tokenTypeHint.equals("refresh_token") && (response = this.getRefreshTokenResponse(client, tokenString)) != null) {
            AsAuditLogger.setInRefreshTokenHash(tokenString);
            return response;
        }
        if ("access_token".equals(tokenTypeHint)) {
            AsAuditLogger.setAccessTokenTrackingId(tokenString);
            AsAuditLogger.setInAccessTokenHash(tokenString);
        } else if ("refresh_token".equals(tokenTypeHint)) {
            AsAuditLogger.setInRefreshTokenHash(tokenString);
        } else {
            AsAuditLogger.setAccessTokenTrackingId(tokenString);
            AsAuditLogger.setInAccessTokenHash(tokenString);
        }
        String errorMsg = "invalid_grant: No token found for the given parameters";
        log.debug((Object)(errorMsg + ". Returning the default response."));
        this.configureAuditLogFailure(errorMsg);
        return DEFAULT_RESPONSE_BUILDER.build(client);
    }

    private TokenIntrospectResponse getRefreshTokenResponse(Client client, String tokenString) {
        try {
            AccessGrant refreshGrant = this.accessGrantManager.getByRefreshToken(tokenString);
            if (refreshGrant != null) {
                if (StringUtils.isNotBlank((String)refreshGrant.getUniqueUserIdentifer())) {
                    AsAuditLogger.setUserName(refreshGrant.getUniqueUserIdentifer());
                }
                if (refreshGrant.isExpired()) {
                    log.debug((Object)"Token is expired.");
                    this.configureAuditLogFailure("invalid_grant: grant is expired");
                    return DEFAULT_RESPONSE_BUILDER.build(client);
                }
                if (!PersistentGrantLifetimeHelper.isWithinIdleTimeoutWindow(refreshGrant)) {
                    this.accessGrantManager.revokeGrant(refreshGrant.getGuid());
                    log.debug((Object)"Access grant idle timeout.");
                    this.configureAuditLogFailure("invalid_grant: access grant revoked due to idle timeout");
                    return DEFAULT_RESPONSE_BUILDER.build(client);
                }
                TokenIntrospectResponse.Builder builder = new TokenIntrospectResponse.Builder(true);
                builder.setTokenType(null);
                if (refreshGrant.getExpires() != null) {
                    builder.setExpiresAt(refreshGrant.getExpires() / 1000L);
                }
                return builder.build(client);
            }
        }
        catch (AccessGrantManagementException e) {
            log.debug((Object)"Did not find a valid refresh token.");
        }
        return null;
    }

    private TokenIntrospectResponse getAccessTokenResponse(Client client, String tokenString, List<String> tokenManagerIds) {
        log.debug((Object)"Attempting to decode this as an access_token");
        AccessTokenWrapper accessTokenWrapper = this.getTokenManager().validateAccessToken(tokenManagerIds, tokenString);
        AccessToken token = accessTokenWrapper.getAccessToken();
        if (token != null) {
            if (token.isExpired()) {
                log.debug((Object)"Token is expired.");
                this.configureAuditLogFailure("invalid_grant: token is expired");
                return DEFAULT_RESPONSE_BUILDER.build(client);
            }
            TokenIntrospectResponse.Builder tokenResponseBuilder = new TokenIntrospectResponse.Builder(true);
            tokenResponseBuilder.setScope(token.getScope());
            tokenResponseBuilder.setClientId(token.getClientId());
            tokenResponseBuilder.setExpiresAt(this.getExpiresAt(token));
            tokenResponseBuilder.setAdditionalAttributes(token.getAttributes());
            tokenResponseBuilder.setAudience(token.getAudience());
            tokenResponseBuilder.setTokenId(token.getTokenIdentifier());
            tokenResponseBuilder.setIssuedBy(token.getIssuer());
            tokenResponseBuilder.setMultiValuedAttributes(accessTokenWrapper.getTokenManager().getMultiValuedContractAttributes());
            tokenResponseBuilder.setAuthorizationDetails(token.getAuthorizationDetails());
            if (token.getAttributes() != null) {
                if (token.getAttributes().get("username") != null) {
                    tokenResponseBuilder.setUsername(((AttributeValue)token.getAttributes().get("username")).getValue());
                }
                if (token.getAttributes().get("sub") != null) {
                    tokenResponseBuilder.setSubject(((AttributeValue)token.getAttributes().get("sub")).getValue());
                }
            }
            DpopUtil.covertToDPoPBoundAccessTokenIntrospectResponseIfNecessary(tokenResponseBuilder, token.getAttributes());
            AuditLogger.setUserName(accessTokenWrapper, token);
            return tokenResponseBuilder.build(client);
        }
        log.debug((Object)"Did not find a valid access token.");
        return null;
    }

    private Long getExpiresAt(AccessToken token) {
        return token.getExpiresAt() / 1000L;
    }

    @Override
    public GrantContext processGrant(InMessageContext ctx, HttpServletRequest req, HttpServletResponse resp, Client client, String grantType) throws AccessTokenRequestException {
        try {
            GrantContext context = super.processGrant(ctx, req, resp, client, grantType);
            AuditLogger.setStatus("success");
            return context;
        }
        catch (AccessTokenRequestException e) {
            if (AccessTokenRequestException.Error.invalid_request.equals((Object)e.getError())) {
                this.configureAuditLogFailure(e.getMessage());
                return new GrantContext<TokenIntrospectResponse>(DEFAULT_RESPONSE_BUILDER.build(client));
            }
            throw e;
        }
    }

    private void configureAuditLogFailure(String errorMsg) {
        AuditLogger.setStatus("failure");
        AsAuditLogger.setDescription(errorMsg);
        if (errorMsg != null) {
            HashMap<String, Object> error = new HashMap<String, Object>();
            error.put("error", errorMsg);
            AsAuditLogger.setOutMsgCtxWithErrors(error);
        }
    }
}

