/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers.process;

import com.pingidentity.common.util.LogGuard;
import com.pingidentity.crypto.Cert;
import com.pingidentity.sdk.oauth20.Scope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.resolvers.HttpsJwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.keys.resolvers.X509VerificationKeyResolver;
import org.jose4j.lang.UnresolvableKeyException;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.handlers.AccessTokenRequestException;
import org.sourceid.oauth20.handlers.HandlerUtil;
import org.sourceid.oauth20.handlers.ServerErrorException;
import org.sourceid.oauth20.handlers.TokenManagerSelector;
import org.sourceid.oauth20.handlers.process.GrantContext;
import org.sourceid.oauth20.handlers.process.GrantProcessor;
import org.sourceid.oauth20.protocol.GrantParamHelper;
import org.sourceid.oauth20.protocol.HttpsJwksCache;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderInfo;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.AttrLookupException;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.OAuthAssertionGrantMapping;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.partner.MetadataDirectory;
import org.sourceid.saml20.protocol.AssertionMapKeys;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.util.BaseUrlUtil;
import org.sourceid.util.license.LicenseManager;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.idp.AsAuditLogger;
import org.sourceid.websso.servlet.reqparam.InvalidRequestParameterException;
import org.sourceid.websso.wrapper.InMessageContext;

public class JwtGrantProcessor
implements GrantProcessor {
    private static final String MAX_FUTURE_VALIDITY_IN_MINUTES = "MaxFutureValidityInMinutes";
    private static final int DEFAULT_MAX_FUTURE_VALIDITY_IN_MINUTES = 720;
    private final Log log = LogFactory.getLog(this.getClass());
    private final AuthzServerManager authzServerManager;
    private final MetadataDirectory metadataDirectory = MetaDataFactory.getMetadataDirectory();
    private final HttpsJwksCache httpsJwksCache;
    private ConfigStore configStore = ConfigStoreFarm.getConfig("org.sourceid.oauth20.handlers.process.JwtGrantProcessor");

    private AlgorithmConstraints getSignatureConstraints() {
        List<String> algs = OpenIdConnectProviderInfo.getVerificationAlgorithmsSupported();
        String[] algsArray = algs.toArray(new String[algs.size()]);
        return new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.WHITELIST, algsArray);
    }

    public JwtGrantProcessor(AuthzServerManager authzServerManager, HttpsJwksCache httpsJwksCache) {
        this.authzServerManager = authzServerManager;
        this.httpsJwksCache = httpsJwksCache;
    }

    @Override
    public GrantContext processGrant(InMessageContext ctx, HttpServletRequest req, HttpServletResponse resp, Client client, String grantType) throws AccessTokenRequestException {
        if (client.getClientId() == null && !this.authzServerManager.allowUnidentifiedClientExtensionGrants()) {
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_client, "No client specified. Unidentified clients cannot make " + grantType + " grant type requests");
        }
        Scope scope = Scope.getScope((String)ctx.getParam(Parameters.SCOPE));
        String jwt = GrantParamHelper.getParam(req, "assertion", true, grantType);
        JwtContext jwtContext = this.getJwtContext(jwt);
        IdpConnection idp = this.getIdp(jwtContext);
        AsAuditLogger.setConnectionId(idp.getEntityId());
        try {
            if (jwtContext.getJwtClaims().getJwtId() != null) {
                AuditLogger.setRequestJti(jwtContext.getJwtClaims().getJwtId());
            }
        }
        catch (MalformedClaimException e) {
            this.log.error((Object)("Unable to get jti from JWT Grant. Jti will not be included in the security audit log record for this transaction: " + e.getMessage()));
            this.log.debug((Object)e);
        }
        if (idp.getOAuthSettings() == null) {
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, "Issuer (" + idp.getEntityId() + ") is not valid for OAuth JWT Grant");
        }
        try {
            LicenseManager.checkLicenseForConnection(idp);
        }
        catch (ProcessRuntimeException ex) {
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, ex.getMessage());
        }
        this.validateJwt(jwtContext, req, idp);
        AttributeMap jwtAttributes = this.makeAttributeMap(jwtContext.getJwtClaims());
        AttributeValue sub = (AttributeValue)jwtAttributes.get((Object)"sub");
        if (sub != null) {
            jwtAttributes.put(AssertionMapKeys.getGenericNameIdValueKey(), sub);
            AsAuditLogger.setUserName(sub.getValue());
        }
        String tokenManagerId = null;
        AttributeMap attrs = null;
        try {
            TokenManagerSelector selector = new TokenManagerSelector();
            Set resources = ctx.getParam("resource", Set.class);
            tokenManagerId = selector.selectTokenManagerId(this.getEligibleTokenManagerIds(idp), ctx, resources, scope, client);
            Set<String> maskedAttributeNames = idp.getMaskedAttributeNames();
            if (idp.getOAuthSettings().getOAuthAssertionGrantAttributeContract() != null) {
                maskedAttributeNames.addAll(idp.getOAuthSettings().getOAuthAssertionGrantAttributeContract().getMaskedAttributeNames());
            }
            AttrValueSupport.checkSetMasked((Map)jwtAttributes, maskedAttributeNames);
            Scope requestedScope = Scope.getScope((String)ctx.getParam(Parameters.SCOPE));
            AttributeMap contextAttributes = new AttributeMap();
            contextAttributes.put(SourceContextType.OAUTH_SCOPES.getId(), new AttributeValue((Collection)requestedScope.getScopeSet()));
            contextAttributes.put(SourceContextType.OAUTH_CLIENT.getId(), new AttributeValue(client.getClientId()));
            HandlerUtil.addExtPropertiesToAttrMap(client.getExtendedParams(), contextAttributes);
            contextAttributes.put(SourceContextType.CLIENT_IP.getId(), new AttributeValue(req.getRemoteAddr()));
            contextAttributes.put(SourceContextType.REQUEST.getId(), AttrValueSupport.make((Object)req));
            attrs = idp.mapOAuthAttributesFromSAML(tokenManagerId, jwtAttributes, contextAttributes);
        }
        catch (InvalidRequestParameterException e) {
            throw new AccessTokenRequestException(e);
        }
        catch (AuthorizationException ae) {
            AsAuditLogger.setDescription(ae.getMessage());
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, ae.getMessage(), ae);
        }
        catch (AttrLookupException e) {
            this.log.error((Object)e);
            if (e.getCause() instanceof RuntimeException) {
                throw new ServerErrorException(e.getMessage());
            }
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, "Invalid JWT token.");
        }
        return new GrantContext(attrs, scope, tokenManagerId);
    }

    protected AttributeMap makeAttributeMap(JwtClaims claims) {
        AttributeMap result = new AttributeMap();
        for (Map.Entry entry : claims.getClaimsMap().entrySet()) {
            if (entry.getValue() instanceof Collection) {
                result.put((String)entry.getKey(), AttrValueSupport.make((Collection)((Collection)entry.getValue())));
                continue;
            }
            result.put((String)entry.getKey(), AttrValueSupport.make(entry.getValue()));
        }
        return result;
    }

    protected JwtConsumer makeFirstPassJwtConsumer() {
        return new JwtConsumerBuilder().setSkipAllValidators().setDisableRequireSignature().setSkipSignatureVerification().build();
    }

    protected void validateJwt(JwtContext jwtContext, HttpServletRequest req, IdpConnection idp) throws AccessTokenRequestException {
        String virtualEntityId = null;
        virtualEntityId = idp.isOIDCConnection() ? idp.getOidcSettings().getClientId() : VirtualIdentityUtil.resolve(idp, req).getVirtualEntityId(DomainMode.RUNTIME);
        String baseUrl = MetaDataFactory.getLocalMetaData().getBaseUrl();
        String currentBaseUrl = BaseUrlUtil.getCurrentBaseUrl(baseUrl);
        JwtConsumerBuilder builder = new JwtConsumerBuilder();
        builder.setExpectedAudience(new String[]{currentBaseUrl + "/as/token.oauth2", virtualEntityId});
        builder.setRequireSubject();
        builder.setRequireExpirationTime();
        builder.setMaxFutureValidityInMinutes(this.configStore.getIntValue(MAX_FUTURE_VALIDITY_IN_MINUTES, 720));
        builder.setAllowedClockSkewInSeconds(60);
        builder.setJwsAlgorithmConstraints(this.getSignatureConstraints());
        builder.setVerificationKeyResolver(this.getVerificationKeyResolver(idp));
        try {
            builder.build().processContext(jwtContext);
        }
        catch (InvalidJwtException e) {
            this.log.error((Object)e);
            if (e.getCause() instanceof UnresolvableKeyException) {
                StringBuilder sb = new StringBuilder("Missing or invalid signature ");
                sb.append("in JWS header");
                if (jwtContext.getJoseObjects() != null && jwtContext.getJoseObjects().get(0) != null) {
                    sb.append("(").append(((JsonWebStructure)jwtContext.getJoseObjects().get(0)).getHeaders().getFullHeaderAsJsonString());
                    sb.append(")");
                }
                sb.append(". The provided certificate could not be verified against the certificates available from the IDP (");
                sb.append(idp.getEntityId()).append(").");
                throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, sb.toString());
            }
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, "Invalid JWT token");
        }
    }

    protected VerificationKeyResolver getVerificationKeyResolver(IdpConnection idp) {
        if (idp.isOIDCConnection()) {
            HttpsJwks httpsJwks = this.httpsJwksCache.getJwks(idp.getOidcSettings().getJwksUri().getFullLocation(), idp.getEntityId());
            HttpsJwksVerificationKeyResolver resolver = new HttpsJwksVerificationKeyResolver(httpsJwks);
            return resolver;
        }
        if (idp.getDsigVerificationCerts().getActiveVerificationCerts().isEmpty()) {
            throw new ProcessRuntimeException("IdP connection missing certificate to validate JWT signature.");
        }
        List x509s = idp.getDsigVerificationCerts().getActiveVerificationCerts().stream().map(Cert::getX509Certificate).collect(Collectors.toList());
        X509VerificationKeyResolver resolver = new X509VerificationKeyResolver(x509s);
        resolver.setTryAllOnNoThumbHeader(true);
        return resolver;
    }

    protected JwtContext getJwtContext(String jwt) throws AccessTokenRequestException {
        try {
            JwtConsumer firstPassConsumer = this.makeFirstPassJwtConsumer();
            return firstPassConsumer.process(jwt);
        }
        catch (InvalidJwtException e) {
            this.log.error((Object)e);
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, "Invalid JWT token");
        }
    }

    protected IdpConnection getIdp(JwtContext jwtContext) throws AccessTokenRequestException {
        try {
            String issuer = jwtContext.getJwtClaims().getIssuer();
            if (issuer == null) {
                throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, "JWT token missing issuer.");
            }
            IdpConnection connection = this.metadataDirectory.getIdpConnection(issuer, false);
            if (connection == null || !connection.isActive()) {
                throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, "Token issuer " + LogGuard.encode(issuer) + " does not match an active IdP connection.");
            }
            return connection;
        }
        catch (MalformedClaimException e) {
            this.log.error((Object)e);
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, "Invalid JWT token");
        }
    }

    protected Collection<String> getEligibleTokenManagerIds(IdpConnection connection) {
        ArrayList<String> result = new ArrayList<String>();
        for (OAuthAssertionGrantMapping mapping : connection.getOAuthSettings().getOAuthAssertionGrantMappingList()) {
            result.add(mapping.getTokenManagerId());
        }
        return result;
    }
}

