/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers.process;

import com.pingidentity.common.util.Base64URL;
import com.pingidentity.common.util.LogGuard;
import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.sdk.oauth20.Scope;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.dsig.SignatureResult;
import org.sourceid.common.dsig.SignatureStatus;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.handlers.AccessTokenRequestException;
import org.sourceid.oauth20.handlers.HandlerUtil;
import org.sourceid.oauth20.handlers.ServerErrorException;
import org.sourceid.oauth20.handlers.TokenManagerSelector;
import org.sourceid.oauth20.handlers.process.GrantContext;
import org.sourceid.oauth20.handlers.process.GrantProcessor;
import org.sourceid.oauth20.handlers.process.ValidateAssertionConditions;
import org.sourceid.oauth20.protocol.GrantParamHelper;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.AttrLookupException;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.OAuthAssertionGrantMapping;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.dsig.SignatureEngine;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.metadata.partner.MetadataDirectory;
import org.sourceid.saml20.protocol.AssertionAssembler;
import org.sourceid.saml20.protocol.AssertionMapKeys;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.saml20.wrapper.Assertion;
import org.sourceid.saml20.xmlbinding.assertion.AssertionDocument;
import org.sourceid.saml20.xmlbinding.assertion.AssertionType;
import org.sourceid.util.license.LicenseManager;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.idp.AsAuditLogger;
import org.sourceid.websso.servlet.reqparam.InvalidRequestParameterException;
import org.sourceid.websso.wrapper.InMessageContext;

public class SAML2GrantProcessor
implements GrantProcessor {
    private final Log log = LogFactory.getLog(this.getClass());
    private final AuthzServerManager authzServerManager;
    private final MetadataDirectory metadataDirectory = MetaDataFactory.getMetadataDirectory();
    private final MetadataLocal localMetaData = MetaDataFactory.getLocalMetaData();
    private final AssertionAssembler assembler = new AssertionAssembler();
    private final SignatureEngine signatureSvc = GlobalRegistry.getService(SignatureEngine.class);
    private final BearerAccessTokenMgmtPluginManager tokenPluginManager = MgmtFactory.getBearerAccessTokenMgmtPluginMgr();

    public SAML2GrantProcessor(AuthzServerManager authzServerManager) {
        this.authzServerManager = authzServerManager;
    }

    @Override
    public GrantContext processGrant(InMessageContext ctx, HttpServletRequest req, HttpServletResponse resp, Client client, String grantType) throws AccessTokenRequestException {
        if (client.getClientId() == null && !this.authzServerManager.allowUnidentifiedClientExtensionGrants()) {
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_client, "No client specified. Unidentified clients cannot make " + grantType + " grant type requests");
        }
        Scope scope = Scope.getScope((String)ctx.getParam(Parameters.SCOPE));
        AttributeMap attrs = null;
        String encodedSamlAssertion = GrantParamHelper.getParam(req, "assertion", true, grantType);
        byte[] bytes = Base64URL.decode((String)encodedSamlAssertion);
        AssertionDocument assertionDoc = null;
        try {
            assertionDoc = XmlBeansUtil.parse(new ByteArrayInputStream(bytes), AssertionDocument.class);
        }
        catch (XmlException e) {
            this.log.error((Object)e);
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, "Invalid SAML 2.0 Assertion");
        }
        IdpConnection idp = this.getIdp(assertionDoc);
        AsAuditLogger.setConnectionId(idp.getEntityId());
        if (idp.getOAuthSettings() == null) {
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, "SAML issuer (" + idp.getEntityId() + ") is not valid for OAuth SAML Grant");
        }
        try {
            LicenseManager.checkLicenseForConnection(idp);
        }
        catch (ProcessRuntimeException ex) {
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, ex.getMessage());
        }
        AssertionType assertionType = assertionDoc.getAssertion();
        Assertion assertion = new Assertion(assertionType);
        SignatureResult signatureResult = this.signatureSvc.verifyXmlSignature((XmlObject)assertionDoc, (ConnectionBase)idp);
        if (SignatureStatus.VALID != signatureResult.getStatus()) {
            StringBuilder sb = new StringBuilder("Missing or invalid signature (");
            sb.append(signatureResult).append(") on SAML 2.0 assertion (ID=");
            sb.append(assertionType.getID()).append("). ");
            sb.append("The provided certificate could not be verified against the certificates available from the IDP (");
            sb.append(idp.getEntityId()).append(").");
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, sb.toString());
        }
        ValidateAssertionConditions validateAssertionConditions = new ValidateAssertionConditions();
        String baseUrl = this.localMetaData.getBaseUrl();
        String virtualEntityId = VirtualIdentityUtil.resolve(idp, req).getVirtualEntityId(DomainMode.RUNTIME);
        validateAssertionConditions.validateAudiences(assertion, new String[]{baseUrl + "/as/token.oauth2", virtualEntityId});
        validateAssertionConditions.validate(assertion, baseUrl + "/as/token.oauth2");
        AttributeMap assertionAttributes = this.assembler.disassemble(assertionType);
        AttributeValue samlSubject = (AttributeValue)assertionAttributes.get((Object)AssertionMapKeys.getNameIdValueKey());
        if (samlSubject != null) {
            assertionAttributes.put(AssertionMapKeys.getGenericNameIdValueKey(), samlSubject);
        }
        if (!assertionAttributes.containsKey((Object)AssertionMapKeys.getGenericNameIdValueKey())) {
            assertion.addInvalidRemark("Invalid Subject");
        } else {
            AttributeValue value = (AttributeValue)assertionAttributes.get((Object)AssertionMapKeys.getGenericNameIdValueKey());
            AsAuditLogger.setUserName(value.getValue(true));
        }
        if (!assertion.isValid()) {
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, "Invalid SAML 2.0 Assertion: " + assertion.getRemarks());
        }
        String tokenManagerId = null;
        try {
            TokenManagerSelector selector = new TokenManagerSelector();
            Set resources = ctx.getParam("resource", Set.class);
            tokenManagerId = selector.selectTokenManagerId(this.getEligibleTokenManagerIds(idp), ctx, resources, scope, client);
            Set<String> maskedAttributeNames = idp.getMaskedAttributeNames();
            if (idp.getOAuthSettings().getOAuthAssertionGrantAttributeContract() != null) {
                maskedAttributeNames.addAll(idp.getOAuthSettings().getOAuthAssertionGrantAttributeContract().getMaskedAttributeNames());
            }
            AttrValueSupport.checkSetMasked((Map)assertionAttributes, maskedAttributeNames);
            Scope requestedScope = Scope.getScope((String)ctx.getParam(Parameters.SCOPE));
            AttributeMap contextAttributes = new AttributeMap();
            contextAttributes.put(SourceContextType.OAUTH_SCOPES.getId(), new AttributeValue((Collection)requestedScope.getScopeSet()));
            contextAttributes.put(SourceContextType.OAUTH_CLIENT.getId(), new AttributeValue(client.getClientId()));
            HandlerUtil.addExtPropertiesToAttrMap(client.getExtendedParams(), contextAttributes);
            contextAttributes.put(SourceContextType.CLIENT_IP.getId(), new AttributeValue(req.getRemoteAddr()));
            contextAttributes.put(SourceContextType.REQUEST.getId(), AttrValueSupport.make((Object)req));
            attrs = idp.mapOAuthAttributesFromSAML(tokenManagerId, assertionAttributes, contextAttributes);
        }
        catch (InvalidRequestParameterException e) {
            throw new AccessTokenRequestException(e);
        }
        catch (AuthorizationException ae) {
            AsAuditLogger.setDescription(ae.getMessage());
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, ae.getMessage(), ae);
        }
        catch (AttrLookupException e) {
            this.log.error((Object)e);
            if (e.getCause() instanceof RuntimeException) {
                throw new ServerErrorException(e.getMessage());
            }
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, "Invalid SAML 2.0 Assertion");
        }
        return new GrantContext(attrs, scope, tokenManagerId);
    }

    protected IdpConnection getIdp(AssertionDocument assertionDoc) throws AccessTokenRequestException {
        IdpConnection connection = this.metadataDirectory.getIdpConnection(assertionDoc.getAssertion().getIssuer().getStringValue(), false);
        if (connection == null || connection != null && !connection.isActive()) {
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, "Assertion issuer " + LogGuard.encode(assertionDoc.getAssertion().getIssuer().getStringValue()) + " does not match an active IdP connection.");
        }
        return connection;
    }

    protected Collection<String> getEligibleTokenManagerIds(IdpConnection connection) {
        ArrayList<String> result = new ArrayList<String>();
        for (OAuthAssertionGrantMapping mapping : connection.getOAuthSettings().getOAuthAssertionGrantMappingList()) {
            result.add(mapping.getTokenManagerId());
        }
        return result;
    }
}

