/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers.process;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.sourceid.common.Util;
import org.sourceid.saml20.protocol.ValidateSubjectConfirmationData;
import org.sourceid.saml20.wrapper.Assertion;
import org.sourceid.saml20.xmlbinding.assertion.AssertionType;
import org.sourceid.saml20.xmlbinding.assertion.AudienceRestrictionType;
import org.sourceid.saml20.xmlbinding.assertion.ConditionsType;
import org.sourceid.websso.protocol.AssertionConditionsValidator;

public class ValidateAssertionConditions
extends AssertionConditionsValidator {
    public void validateAudiences(Assertion assertion, String[] myAudiences) {
        AssertionType assertionType = assertion.getAssertionType();
        if (!assertionType.isSetConditions()) {
            assertion.addInvalidRemark("No conditions set on assertion");
            return;
        }
        ConditionsType conditions = assertionType.getConditions();
        AudienceRestrictionType[] audienceRestrictionConditions = conditions.getAudienceRestrictionArray();
        HashMap audienceRestrictionConditionsResults = new HashMap();
        for (AudienceRestrictionType audienceRestrictionType : audienceRestrictionConditions) {
            ArrayList<Boolean> audienceRestrictionConditionsResult = new ArrayList<Boolean>();
            for (String audience : audienceRestrictionType.getAudienceArray()) {
                if (myAudiences == null) continue;
                for (String myAudience : myAudiences) {
                    audienceRestrictionConditionsResult.add(this.audienceEvaluator.evalAudience(myAudience, audience));
                }
            }
            audienceRestrictionConditionsResults.put(audienceRestrictionType, audienceRestrictionConditionsResult);
        }
        boolean allValid = audienceRestrictionConditions.length > 0;
        for (AudienceRestrictionType audienceRestrictionType : audienceRestrictionConditions) {
            allValid &= ((List)audienceRestrictionConditionsResults.get(audienceRestrictionType)).contains(Boolean.TRUE);
        }
        if (!allValid) {
            assertion.addInvalidRemark(this.audienceEvaluator.getRemark(myAudiences));
        }
    }

    public void validate(Assertion assertion, String myRecipientId) {
        AssertionType assertionType = assertion.getAssertionType();
        ConditionsType conditions = assertionType.getConditions();
        boolean isNotBeforeValid = false;
        boolean isNotOnOrAfterValid = false;
        Calendar now = Util.getUtcCalendar();
        isNotBeforeValid = conditions.isSetNotBefore() ? this.timeConditionUtil.validateNotBefore(assertion, conditions.getNotBefore(), now) : true;
        if (conditions.isSetNotOnOrAfter()) {
            isNotOnOrAfterValid = this.timeConditionUtil.validateNotOnOrAfter(assertion, conditions.getNotOnOrAfter(), now);
        }
        if (assertion.isValid()) {
            ValidateSubjectConfirmationData validateSubjectConfirmationData = new ValidateSubjectConfirmationData();
            validateSubjectConfirmationData.validateBearerSubjectConfirmationData(assertion, myRecipientId, !isNotBeforeValid || !isNotOnOrAfterValid);
        }
    }
}

