/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers.process;

import com.pingidentity.sdk.oauth20.AccessToken;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.sourceid.common.json.SimpleJsonRespWriter;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.handlers.AccessTokenRequestException;
import org.sourceid.oauth20.handlers.process.AbstractTokenValidateProcessor;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.oauth20.token.AccessTokenResponse;
import org.sourceid.oauth20.token.AccessTokenWrapper;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.profiles.idp.AsAuditLogger;

public class ValidateBearerAccessTokenProcessor
extends AbstractTokenValidateProcessor {
    public ValidateBearerAccessTokenProcessor(BearerAccessTokenMgmtPluginManager tokenManager) {
        super(tokenManager);
    }

    @Override
    public AccessTokenResponse translateGrant(Client client, String tokenString, List<String> tokenManagerIds, String tokenTypeHint, HttpServletRequest req) throws AccessTokenRequestException {
        AsAuditLogger.setAccessTokenTrackingId(tokenString);
        AsAuditLogger.setInAccessTokenHash(tokenString);
        AccessTokenWrapper accessTokenWrapper = this.getTokenManager().validateAccessToken(tokenManagerIds, tokenString);
        AccessToken token = accessTokenWrapper.getAccessToken();
        if (token == null) {
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, "token not found, expired or invalid");
        }
        if (token.isExpired()) {
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, "token expired");
        }
        AuditLogger.setUserName(accessTokenWrapper, token);
        Set<String> multiValuedAttributes = accessTokenWrapper.getTokenManager().getMultiValuedContractAttributes();
        HashMap<String, Object> returnToken = new HashMap<String, Object>();
        for (Map.Entry e : token.getAttributes().entrySet()) {
            AttributeValue v = (AttributeValue)e.getValue();
            String key = (String)e.getKey();
            if (v == null || key == null) continue;
            SimpleJsonRespWriter.setForJsonSerialize(returnToken, key, v, multiValuedAttributes);
        }
        if (CollectionUtils.isNotEmpty((Collection)token.getAudience())) {
            SimpleJsonRespWriter.setForJsonSerialize(returnToken, "aud", new AttributeValue((Collection)token.getAudience()), multiValuedAttributes);
        }
        Map<String, Object> params = Collections.singletonMap(Parameters.CLIENT_ID, token.getClientId());
        return new AccessTokenResponse(returnToken, "urn:pingidentity.com:oauth2:validated_token", token.getExpiresAt(), token.getScope(), null, params, null, token.getAuthorizationDetails());
    }
}

