/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers.process.exchange;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.PersistentGrantLifetimeHelper;
import org.sourceid.oauth20.handlers.AccessTokenRequestException;
import org.sourceid.oauth20.handlers.HandlerUtil;
import org.sourceid.oauth20.handlers.process.GrantContext;
import org.sourceid.oauth20.handlers.process.exchange.TokenExchangeRequest;
import org.sourceid.oauth20.handlers.process.exchange.execution.InputProcessingStrategy;
import org.sourceid.oauth20.handlers.process.exchange.execution.OutputGenerationStrategy;
import org.sourceid.oauth20.handlers.process.exchange.execution.TokenExchangeExecutionStrategy;
import org.sourceid.oauth20.handlers.process.exchange.execution.exception.TokenExchangeExecutionStrategyException;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.util.log.AttributeMap;

public final class TokenExchangeRequestProcessor {
    private static final Logger logger = LogManager.getLogger(TokenExchangeRequestProcessor.class);
    private static final String END_OF_LINE = System.getProperty("line.separator");
    private final TokenExchangeExecutionStrategy tokenExchangeExecutionStrategy;
    private final AuthzServerManager authzServerManager;

    public TokenExchangeRequestProcessor(TokenExchangeExecutionStrategy tokenExchangeExecutionStrategy, AuthzServerManager authzServerManager) {
        this.tokenExchangeExecutionStrategy = tokenExchangeExecutionStrategy;
        this.authzServerManager = authzServerManager;
    }

    public GrantContext process(Client client, TokenExchangeRequest tokenExchangeRequest, HttpServletRequest req) throws AccessTokenRequestException {
        try {
            AttributeMap contextAttrs = this.createContext(client, tokenExchangeRequest, req);
            InputProcessingStrategy input = this.tokenExchangeExecutionStrategy.createInputProcessingStrategy(client, tokenExchangeRequest);
            OutputGenerationStrategy output = this.tokenExchangeExecutionStrategy.createOutputGenerationStrategy(client, tokenExchangeRequest, input.getTokenExchangeProcessorPolicy());
            String inputInfo = "Input token will be processed using:" + END_OF_LINE + input.getInfo();
            logger.debug(inputInfo);
            String outputInfo = "Output token will be generated using:" + END_OF_LINE + output.getInfo();
            logger.debug(outputInfo);
            AttributeMap inputAttrs = input.process(contextAttrs, req);
            return output.generate(inputAttrs, contextAttrs);
        }
        catch (TokenExchangeExecutionStrategyException e) {
            logger.error("Token Exchange transaction failed");
            if (logger.isDebugEnabled()) {
                logger.error("Token Exchange transaction failed: " + e.getMessage());
            }
            throw e.toAccessTokenRequestException();
        }
    }

    private AttributeMap createContext(Client client, TokenExchangeRequest tokenExchangeRequest, HttpServletRequest req) {
        AttributeMap contextAttrs = new AttributeMap();
        contextAttrs.put(SourceContextType.CLIENT_IP.getId(), new AttributeValue(req.getRemoteAddr()));
        contextAttrs.put(SourceContextType.REQUEST.getId(), AttrValueSupport.make((Object)req));
        contextAttrs.put(SourceContextType.OAUTH_CLIENT.getId(), client.getClientId());
        contextAttrs.put(SourceContextType.OAUTH_SCOPES.getId(), new AttributeValue((Collection)tokenExchangeRequest.getScope().getScopeSet()));
        if (tokenExchangeRequest.getAuthorizationDetails() != null && tokenExchangeRequest.getAuthorizationDetails().getDetails() != null) {
            contextAttrs.put(SourceContextType.OAUTH_AUTHORIZATION_DETAILS.getId(), tokenExchangeRequest.getAuthorizationDetails().toAttributeValue());
        }
        if (CollectionUtils.isNotEmpty(tokenExchangeRequest.getResource())) {
            contextAttrs.put(SourceContextType.OAUTH_RESOURCES.getId(), new AttributeValue(tokenExchangeRequest.getResource()));
        }
        String defaultPersistentGrantLifetime = String.valueOf(PersistentGrantLifetimeHelper.getPersistentGrantExpirationTimeSettingInMins(client, this.authzServerManager));
        contextAttrs.put(SourceContextType.OAUTH_DEFAULT_PERSISTENT_GRANT_LIFETIME.getId(), defaultPersistentGrantLifetime);
        HandlerUtil.addExtPropertiesToAttrMap(client.getExtendedParams(), contextAttrs);
        return contextAttrs;
    }
}

