/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers.process.exchange;

import com.pingidentity.common.util.HierarchicalUriComparison;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.oauth20.handlers.AccessTokenRequestException;
import org.sourceid.oauth20.handlers.process.exchange.TokenExchangeRequest;

public final class TokenExchangeResourceParameterValidator {
    private static final Log log = LogFactory.getLog(TokenExchangeResourceParameterValidator.class);
    private final Set<URI> serverResourceUris = new HashSet<URI>();

    public TokenExchangeResourceParameterValidator(Set<String> serverResources) {
        this.serverResourceUris.addAll(this.toUri(serverResources));
    }

    public void validate(TokenExchangeRequest tokenExchangeRequest) throws AccessTokenRequestException {
        Set<URI> requestResources;
        if (tokenExchangeRequest.getResource() != null && !(requestResources = this.validateAndConvertRequestResources(tokenExchangeRequest.getResource())).isEmpty()) {
            if (this.serverResourceUris.isEmpty()) {
                this.throwException(requestResources.iterator().next());
            }
            for (URI requestResource : requestResources) {
                if (this.serverResourceUris.contains(requestResource)) continue;
                boolean found = false;
                for (URI serverResource : this.serverResourceUris) {
                    int compare = HierarchicalUriComparison.compare(requestResource, serverResource, true);
                    if (compare < 0) continue;
                    found = true;
                }
                if (found) continue;
                this.throwException(requestResource);
            }
        }
    }

    private void throwException(URI requestResource) throws AccessTokenRequestException {
        String msg = String.format("'%s' resource not found", requestResource);
        log.debug((Object)msg);
        throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_target, msg);
    }

    private Set<URI> validateAndConvertRequestResources(Set<String> resources) throws AccessTokenRequestException {
        HashSet<URI> set = new HashSet<URI>();
        for (String resource : resources) {
            set.add(this.toValidRequestUri(resource));
        }
        return set;
    }

    private URI toValidRequestUri(String resource) throws AccessTokenRequestException {
        try {
            URI uri = new URI(resource);
            if (uri.isAbsolute() && StringUtils.isBlank((String)uri.getFragment())) {
                return uri;
            }
        }
        catch (URISyntaxException uri) {
            // empty catch block
        }
        String msg = String.format("'%s' resource is an invalid URI", resource);
        log.debug((Object)msg);
        throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_target, msg);
    }

    private Set<URI> toUri(Set<String> resources) {
        Function<String, URI> toUriFunction = s -> {
            try {
                return new URI((String)s);
            }
            catch (URISyntaxException ignored) {
                return null;
            }
        };
        return resources.stream().map(toUriFunction).filter(Objects::nonNull).collect(Collectors.toSet());
    }
}

