/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers.process.exchange.execution.impl;

import java.util.HashSet;
import java.util.Set;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.handlers.process.exchange.TokenExchangeRequest;
import org.sourceid.oauth20.handlers.process.exchange.execution.OutputCreatorSelector;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;

public final class AccessTokenManagerSelector
implements OutputCreatorSelector<BearerAccessTokenMgmtPluginInstance> {
    private final ClientManager clientMgr;
    private final BearerAccessTokenMgmtPluginManager atmManager;

    public AccessTokenManagerSelector(ClientManager clientMgr, BearerAccessTokenMgmtPluginManager atmManager) {
        this.clientMgr = clientMgr;
        this.atmManager = atmManager;
    }

    @Override
    public Set<BearerAccessTokenMgmtPluginInstance> select(TokenExchangeRequest request, Client requestingClient) {
        HashSet<BearerAccessTokenMgmtPluginInstance> result = new HashSet<BearerAccessTokenMgmtPluginInstance>();
        for (String aud : request.getAudience()) {
            Client client = this.clientMgr.getCachedClient(aud);
            if (client == null) continue;
            String clientAtmId = client.getDefaultAccessTokenManagerId();
            if (clientAtmId != null) {
                BearerAccessTokenMgmtPluginInstance atm = (BearerAccessTokenMgmtPluginInstance)this.atmManager.getInstance(clientAtmId);
                result.add(atm);
                continue;
            }
            if (!this.atmManager.isDefaultInstanceConfigured()) continue;
            result.add((BearerAccessTokenMgmtPluginInstance)this.atmManager.getDefaultInstance());
        }
        for (BearerAccessTokenMgmtPluginInstance atm : this.atmManager.getInstances()) {
            for (String uri : request.getResource()) {
                if (!atm.matchRequestedResource(uri)) continue;
                result.add(atm);
            }
        }
        if (request.getResource().isEmpty() && result.isEmpty()) {
            if (requestingClient.getDefaultAccessTokenManagerId() != null) {
                result.add((BearerAccessTokenMgmtPluginInstance)this.atmManager.getInstance(requestingClient.getDefaultAccessTokenManagerId()));
            } else if (this.atmManager.isDefaultInstanceConfigured()) {
                result.add((BearerAccessTokenMgmtPluginInstance)this.atmManager.getDefaultInstance());
            }
        }
        return result;
    }
}

