/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers.process.exchange.execution.impl;

import com.pingidentity.sdk.accessgrant.AccessGrantAttributesHolder;
import com.pingidentity.sdk.oauth20.Scope;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.TeppToUserKeyAttrMapping;
import org.sourceid.oauth20.domain.UserKeyToAccessTokenMapping;
import org.sourceid.oauth20.handlers.AccessTokenRequestException;
import org.sourceid.oauth20.handlers.ContextUtil;
import org.sourceid.oauth20.handlers.OAuthSourceId;
import org.sourceid.oauth20.handlers.process.GrantContext;
import org.sourceid.oauth20.handlers.process.exchange.execution.OutputGenerationStrategy;
import org.sourceid.oauth20.handlers.process.exchange.execution.exception.TokenExchangeExecutionException;
import org.sourceid.oauth20.model.UserKeyAttributes;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.AttrLookupException;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class AccessTokenMappingOutputGenerationStrategy
implements OutputGenerationStrategy {
    private static final String END_OF_LINE = System.getProperty("line.separator");
    private static final Logger logger = LogManager.getLogger(AccessTokenMappingOutputGenerationStrategy.class);
    private final String requestedTokenType;
    private final Scope requestedScope;
    private final String tokenManagerId;
    private final UserKeyToAccessTokenMapping mapping;
    private final boolean isExpandScope;
    private final String teppId;
    private final boolean isIncludeRefreshToken;
    private final boolean isIncludeIdToken;
    private final String oidcPolicyId;
    private final AuthzServerManager authzServerManager;
    private static final ConfigStore oauthScopesConfigStore = ConfigStoreFarm.getConfig("oauth-scope-settings");

    public AccessTokenMappingOutputGenerationStrategy(String requestedTokenType, Scope requestedScope, String tokenManagerId, UserKeyToAccessTokenMapping mapping, boolean isExpandScope, String teppId, boolean isIncludeRefreshToken, boolean isIncludeIdToken, String oidcPolicyId, AuthzServerManager authzServerManager) {
        this.requestedTokenType = requestedTokenType;
        this.requestedScope = requestedScope;
        this.tokenManagerId = tokenManagerId;
        this.mapping = mapping;
        this.isExpandScope = isExpandScope;
        this.teppId = teppId;
        this.isIncludeRefreshToken = isIncludeRefreshToken;
        this.isIncludeIdToken = isIncludeIdToken;
        this.oidcPolicyId = oidcPolicyId;
        this.authzServerManager = authzServerManager;
    }

    @Override
    public GrantContext generate(AttributeMap inputAttrs, AttributeMap contextAttrs) throws TokenExchangeExecutionException {
        try {
            boolean includeScopeInResponse = false;
            if (this.requestedScope != null && !this.requestedScope.getScopeSet().isEmpty()) {
                boolean bl = includeScopeInResponse = oauthScopesConfigStore.getBooleanValue("always-return-scope-for-authz-code", false) || this.isExpandScope;
            }
            if (this.isIncludeRefreshToken) {
                TeppToUserKeyAttrMapping userKeyAttrMapping = this.authzServerManager.getTeppToUserKeyMapping(this.teppId);
                UserKeyAttributes userKeyAttributes = userKeyAttrMapping.execMapping(inputAttrs, contextAttrs);
                ContextUtil contextUtil = new ContextUtil();
                String qualifiedId = contextUtil.buildQualifiedId("urn:ietf:params:oauth:grant-type:token-exchange", new OAuthSourceId(OAuthSourceId.Type.TOKEN_EXCHANGE_PROCESSOR_POLICY, this.teppId));
                AccessGrantAttributesHolder grantAttributesHolder = new AccessGrantAttributesHolder(userKeyAttributes.getExtendedAttributes(), inputAttrs);
                return new GrantContext(userKeyAttributes.getUserKeyValue(), grantAttributesHolder, this.requestedScope, includeScopeInResponse, qualifiedId, this.tokenManagerId, this.requestedTokenType, this.isIncludeIdToken, this.oidcPolicyId);
            }
            AttributeMap updatedEntry = new AttributeMap();
            for (Map.Entry entry : inputAttrs.entrySet()) {
                updatedEntry.put("tepp." + (String)entry.getKey(), (AttributeValue)entry.getValue());
            }
            Set<String> targetNames = this.mapping.getAttributeMapping().keySet();
            AttributeMap attributes = this.mapping.executeMapping(updatedEntry, targetNames, contextAttrs);
            return new GrantContext(attributes, this.requestedScope, includeScopeInResponse, this.tokenManagerId, this.requestedTokenType, this.isIncludeIdToken, this.oidcPolicyId);
        }
        catch (AttrLookupException | AuthorizationException | ProcessRuntimeException ex) {
            logger.error(String.format("Failed to issue a new access token using [%s] Access Token Manager.", this.tokenManagerId));
            throw new TokenExchangeExecutionException(AccessTokenRequestException.Error.invalid_request, ex.getMessage());
        }
    }

    @Override
    public StringBuilder getInfo() {
        StringBuilder builder = new StringBuilder();
        builder.append("Type: ").append(this.getType()).append(END_OF_LINE);
        builder.append("Requested Token Type: ").append(this.requestedTokenType).append(END_OF_LINE);
        builder.append("Requested Scope: ").append(this.requestedScope).append(END_OF_LINE);
        builder.append("Access Token Manager ID: ").append(this.tokenManagerId).append(END_OF_LINE);
        if (this.oidcPolicyId != null) {
            builder.append("OIDC Policy ID: ").append(this.oidcPolicyId).append(END_OF_LINE);
        }
        return builder;
    }

    @Override
    public String getType() {
        return "Access Token Mapping";
    }
}

