/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers.process.exchange.execution.impl;

import java.util.HashSet;
import java.util.Set;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.handlers.process.exchange.TokenExchangeRequest;
import org.sourceid.oauth20.handlers.process.exchange.execution.OutputCreatorSelector;
import org.sourceid.openid.connect.domain.ConnectProviderRuntimePolicySupport;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderPolicy;

public class OidcPolicySelector
implements OutputCreatorSelector<OpenIdConnectProviderPolicy.PolicyGroup> {
    private final ClientManager clientMgr;
    private final ConnectProviderRuntimePolicySupport oidcPolicySupport;

    public OidcPolicySelector(ClientManager clientMgr, ConnectProviderRuntimePolicySupport oidcPolicySupport) {
        this.clientMgr = clientMgr;
        this.oidcPolicySupport = oidcPolicySupport;
    }

    @Override
    public Set<OpenIdConnectProviderPolicy.PolicyGroup> select(TokenExchangeRequest request, Client requestingClient) {
        OpenIdConnectProviderPolicy.PolicyGroup clientPolicyGroup;
        HashSet<OpenIdConnectProviderPolicy.PolicyGroup> result = new HashSet<OpenIdConnectProviderPolicy.PolicyGroup>();
        for (String aud : request.getAudience()) {
            Client audClient = this.clientMgr.getCachedClient(aud);
            OpenIdConnectProviderPolicy.PolicyGroup audPolicyGroup = this.oidcPolicySupport.getPolicyGroup(audClient, false);
            if (audPolicyGroup == null) continue;
            result.add(audPolicyGroup);
        }
        if (result.isEmpty() && (clientPolicyGroup = this.oidcPolicySupport.getPolicyGroup(requestingClient, false)) != null) {
            result.add(clientPolicyGroup);
        }
        return result;
    }
}

