/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers.process.exchange.execution.impl;

import com.pingidentity.sdk.oauth20.Scope;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.domain.UserKeyToAccessTokenMapping;
import org.sourceid.oauth20.exchange.domain.ProcessorPolicy2GeneratorMapping;
import org.sourceid.oauth20.exchange.domain.TokenExchangeGeneratorMapping;
import org.sourceid.oauth20.exchange.domain.TokenExchangeGeneratorPolicy;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorMapping;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorPolicy;
import org.sourceid.oauth20.exchange.manager.ProcessorPolicy2TokenGeneratorManager;
import org.sourceid.oauth20.exchange.manager.TokenExchangeGeneratorPolicyManager;
import org.sourceid.oauth20.exchange.manager.TokenExchangeProcessorPolicyManager;
import org.sourceid.oauth20.exchange.manager.exception.TokenExchangeProcessorPolicyException;
import org.sourceid.oauth20.handlers.AccessTokenRequestException;
import org.sourceid.oauth20.handlers.ContextUtil;
import org.sourceid.oauth20.handlers.OAuthSourceId;
import org.sourceid.oauth20.handlers.process.exchange.TokenExchangeRequest;
import org.sourceid.oauth20.handlers.process.exchange.execution.InputProcessingStrategy;
import org.sourceid.oauth20.handlers.process.exchange.execution.OutputGenerationStrategy;
import org.sourceid.oauth20.handlers.process.exchange.execution.TokenExchangeExecutionStrategy;
import org.sourceid.oauth20.handlers.process.exchange.execution.exception.TokenExchangeExecutionStrategyException;
import org.sourceid.oauth20.handlers.process.exchange.execution.impl.AccessTokenManagerSelector;
import org.sourceid.oauth20.handlers.process.exchange.execution.impl.AccessTokenMappingOutputGenerationStrategy;
import org.sourceid.oauth20.handlers.process.exchange.execution.impl.OidcPolicySelector;
import org.sourceid.oauth20.handlers.process.exchange.execution.impl.TokenExchangeGeneratorPolicySelector;
import org.sourceid.oauth20.handlers.process.exchange.execution.impl.TokenGeneratorOutputGenerationStrategy;
import org.sourceid.oauth20.handlers.process.exchange.execution.impl.TokenProcessorInputProcessingStrategy;
import org.sourceid.openid.connect.domain.ConnectProviderRuntimePolicySupport;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderPolicy;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.wstrust.mgmt.TokenGeneratorManager;
import org.sourceid.wstrust.mgmt.TokenProcessorManager;
import org.sourceid.wstrust.model.SecurityToken;
import org.sourceid.wstrust.plugin.process.TokenProcessor;

public class TokenExchangeExecutionStrategyImpl
implements TokenExchangeExecutionStrategy {
    private static final Logger logger = LogManager.getLogger(TokenExchangeExecutionStrategyImpl.class);
    private static final String ACCESS_TOKEN_TYPE = "urn:ietf:params:oauth:token-type:access_token";
    private static final String TOKEN_PROCESSOR_NOT_FOUND = "%s ID matching with [%s] was not found, Please review the server configuration.";
    private final TokenExchangeProcessorPolicyManager processorPolicyMgr;
    private final TokenProcessorManager tokenProcessorMgr;
    private final TokenGeneratorManager tokenGeneratorMgr;
    private final ProcessorPolicy2TokenGeneratorManager pp2TgMgr;
    private final ContextUtil contextUtil;
    private final AuthzServerManager authzServerMgr;
    private final BearerAccessTokenMgmtPluginManager atmManager;
    private final AccessTokenManagerSelector atmSelector;
    private final TokenExchangeGeneratorPolicySelector teggSelector;
    private final OidcPolicySelector oidcPolicySelector;
    private final ConnectProviderRuntimePolicySupport oidcPolicySupport;

    public TokenExchangeExecutionStrategyImpl(TokenExchangeProcessorPolicyManager processorPolicyMgr, TokenExchangeGeneratorPolicyManager generatorPolicyMgr, TokenProcessorManager tokenProcessorMgr, TokenGeneratorManager tokenGeneratorMgr, ProcessorPolicy2TokenGeneratorManager pp2TgMgr, ClientManager clientMgr, AuthzServerManager authzServerMgr, BearerAccessTokenMgmtPluginManager atmManager) {
        this.processorPolicyMgr = processorPolicyMgr;
        this.tokenProcessorMgr = tokenProcessorMgr;
        this.tokenGeneratorMgr = tokenGeneratorMgr;
        this.pp2TgMgr = pp2TgMgr;
        this.authzServerMgr = authzServerMgr;
        this.atmManager = atmManager;
        this.contextUtil = new ContextUtil();
        this.atmSelector = new AccessTokenManagerSelector(clientMgr, atmManager);
        this.teggSelector = new TokenExchangeGeneratorPolicySelector(generatorPolicyMgr);
        this.oidcPolicySupport = new ConnectProviderRuntimePolicySupport();
        this.oidcPolicySelector = new OidcPolicySelector(clientMgr, this.oidcPolicySupport);
    }

    @Override
    public InputProcessingStrategy createInputProcessingStrategy(Client client, TokenExchangeRequest request) throws TokenExchangeExecutionStrategyException {
        try {
            TokenExchangeProcessorPolicy policy = this.processorPolicyMgr.getPolicyByClient(client);
            TokenExchangeProcessorMapping mapping = policy.getTokenExchangeProcessorMapping(request);
            if (mapping == null) {
                logger.error("Token Exchange Processor mapping not found");
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("Token Exchange Processor mapping not found for [%s]", request));
                }
                throw new TokenExchangeExecutionStrategyException("Invalid configuration");
            }
            TokenProcessor<SecurityToken> subjectProcessor = this.tokenProcessorMgr.getTokenProcessor(mapping.getSubjectTokenProcessorId());
            if (subjectProcessor == null) {
                String type = "'Subject Token' token processor";
                String msg = String.format(TOKEN_PROCESSOR_NOT_FOUND, type, mapping.getSubjectTokenProcessorId());
                logger.error(msg);
                throw new TokenExchangeExecutionStrategyException("Invalid configuration");
            }
            TokenProcessorInputProcessingStrategy strategy = new TokenProcessorInputProcessingStrategy(policy, mapping.getAttributeMapping(), request.getSubjectToken(), request.getSubjectTokenType(), mapping.getSubjectTokenProcessorId(), subjectProcessor);
            String actorTokenProcessorId = mapping.getActorTokenProcessorId();
            if (StringUtils.isNotBlank((String)actorTokenProcessorId)) {
                TokenProcessor<SecurityToken> tokenProcessor = this.tokenProcessorMgr.getTokenProcessor(actorTokenProcessorId);
                if (tokenProcessor == null) {
                    String type = "'Actor Token' token processor";
                    String msg = String.format(TOKEN_PROCESSOR_NOT_FOUND, type, actorTokenProcessorId);
                    logger.error(msg);
                }
                strategy.setActorToken(request.getActorToken());
                strategy.setActorTokenType(request.getActorTokenType());
                strategy.setActorTokenProcessor(tokenProcessor);
            }
            return strategy;
        }
        catch (TokenExchangeProcessorPolicyException e) {
            throw new TokenExchangeExecutionStrategyException(e.getMessage());
        }
    }

    @Override
    public OutputGenerationStrategy createOutputGenerationStrategy(Client client, TokenExchangeRequest request, TokenExchangeProcessorPolicy processorPolicy) throws TokenExchangeExecutionStrategyException {
        boolean usePolicyMapping;
        boolean accessTokenRequested;
        Set<BearerAccessTokenMgmtPluginInstance> atms = this.atmSelector.select(request, client);
        Set<TokenExchangeGeneratorPolicy> policies = this.teggSelector.select(request, client);
        boolean bl = accessTokenRequested = StringUtils.isBlank((String)request.getRequestedTokenType()) || ACCESS_TOKEN_TYPE.equals(request.getRequestedTokenType());
        if (accessTokenRequested && atms.size() > 1) {
            throw this.getInvalidTargetException("Access Token Manager");
        }
        boolean useAtmMapping = !atms.isEmpty() && accessTokenRequested;
        boolean bl2 = usePolicyMapping = !policies.isEmpty() && (StringUtils.isNotBlank((String)request.getRequestedTokenType()) || !useAtmMapping);
        if (useAtmMapping) {
            BearerAccessTokenMgmtPluginInstance atmInstance = atms.iterator().next();
            if (!atmInstance.isClientAllowed(client.getClientId())) {
                String msg = String.format("Client '%s' is not allowed to use Access Token Manager '%s', access control is configured on the ATM.", client.getClientId(), atmInstance.getId());
                logger.error(msg);
                throw new TokenExchangeExecutionStrategyException(AccessTokenRequestException.Error.invalid_target, "Cannot generate access token.");
            }
            return this.getAccessTokenMappingOutputGenerationStrategy(request, atmInstance, processorPolicy, client);
        }
        if (usePolicyMapping) {
            if (policies.size() > 1) {
                throw this.getInvalidTargetException("Token Generator Group");
            }
            TokenExchangeGeneratorPolicy generatorPolicy = policies.iterator().next();
            return this.getTokenGeneratorOutputGenerationStrategy(request, processorPolicy, generatorPolicy);
        }
        String message = request.getRequestedTokenType() != null ? String.format("Unable to find a token generation policy instance to issue [%s] requested token type", request.getRequestedTokenType()) : "Unable to find a token generation policy instance to issue a token";
        logger.error(message);
        throw new TokenExchangeExecutionStrategyException(message);
    }

    private TokenExchangeExecutionStrategyException getInvalidTargetException(String targetType) {
        logger.error("Unable to find a unique [" + targetType + "] to generate the target token.");
        String msg = "Unable to obtain a unique target";
        return new TokenExchangeExecutionStrategyException(AccessTokenRequestException.Error.invalid_target, msg);
    }

    private OutputGenerationStrategy getTokenGeneratorOutputGenerationStrategy(TokenExchangeRequest request, TokenExchangeProcessorPolicy processorPolicy, TokenExchangeGeneratorPolicy generatorPolicy) throws TokenExchangeExecutionStrategyException {
        String requestedTokenType = request.getRequestedTokenType();
        if (StringUtils.isNotBlank((String)requestedTokenType)) {
            TokenExchangeGeneratorMapping mapping = generatorPolicy.getMapping(requestedTokenType);
            if (mapping != null) {
                return this.getTokenGeneratorOutputGenerationStrategy(mapping, this.pp2TgMgr, this.tokenGeneratorMgr, processorPolicy);
            }
            String msg = String.format("Cannot process '%s' requested token type", requestedTokenType);
            throw new TokenExchangeExecutionStrategyException(msg);
        }
        TokenExchangeGeneratorMapping mapping = generatorPolicy.getDefaultMapping();
        if (mapping != null) {
            return this.getTokenGeneratorOutputGenerationStrategy(mapping, this.pp2TgMgr, this.tokenGeneratorMgr, processorPolicy);
        }
        throw new TokenExchangeExecutionStrategyException(AccessTokenRequestException.Error.server_error, "Invalid server configuration");
    }

    private OutputGenerationStrategy getTokenGeneratorOutputGenerationStrategy(TokenExchangeGeneratorMapping mapping, ProcessorPolicy2TokenGeneratorManager pp2TgMgr, TokenGeneratorManager tokenGeneratorMgr, TokenExchangeProcessorPolicy processorPolicy) throws TokenExchangeExecutionStrategyException {
        String tokenType = mapping.getTokenType();
        String tokenGeneratorId = mapping.getTokenGeneratorId();
        ProcessorPolicy2GeneratorMapping pp2TgMapping = (ProcessorPolicy2GeneratorMapping)pp2TgMgr.getMapping(processorPolicy.getId(), tokenGeneratorId);
        if (pp2TgMapping == null) {
            String msg = String.format("Token Exchange Processor policy '%s' to token generator '%s' mapping not found", processorPolicy.getId(), tokenGeneratorId);
            logger.error(msg);
            throw new TokenExchangeExecutionStrategyException(AccessTokenRequestException.Error.server_error, "Invalid server configuration");
        }
        return new TokenGeneratorOutputGenerationStrategy(tokenType, tokenGeneratorId, pp2TgMapping, tokenGeneratorMgr);
    }

    /*
     * Enabled aggressive block sorting
     */
    private OutputGenerationStrategy getAccessTokenMappingOutputGenerationStrategy(TokenExchangeRequest request, BearerAccessTokenMgmtPluginInstance atmInstance, TokenExchangeProcessorPolicy processorPolicy, Client client) throws TokenExchangeExecutionStrategyException {
        String accessTokenManagerId = atmInstance.getId();
        OAuthSourceId oAuthSourceId = new OAuthSourceId(OAuthSourceId.Type.TOKEN_EXCHANGE_PROCESSOR_POLICY, processorPolicy.getId());
        String id = this.contextUtil.buildQualifiedId("urn:ietf:params:oauth:grant-type:token-exchange", oAuthSourceId);
        UserKeyToAccessTokenMapping mapping = this.authzServerMgr.getUserKeyToAccessTokenMapping(id, accessTokenManagerId);
        if (mapping == null) {
            String msg = String.format("Could not find a Access Token Mapping for the selected Policy Processor '%s' and Access Token Manager '%s'.", processorPolicy.getId(), accessTokenManagerId);
            logger.error(msg);
            throw new TokenExchangeExecutionStrategyException(AccessTokenRequestException.Error.invalid_request, msg);
        }
        boolean isIncludeRefreshToken = client.isGrantTypeAllowed("refresh_token");
        if (isIncludeRefreshToken && this.authzServerMgr.getTeppToUserKeyMapping(processorPolicy.getId()) == null) {
            if (logger.isDebugEnabled()) {
                String msg = String.format("Could not find a Persistent Grant Mapping for the selected Policy Processor '%s'. A Refresh Token will not be returned.", processorPolicy.getId());
                logger.debug(msg);
            }
            isIncludeRefreshToken = false;
        }
        Scope requestedScope = request.getScope();
        boolean isExpandScopeGroup = ((BearerAccessTokenMgmtPluginInstance)this.atmManager.getInstance(accessTokenManagerId)).isExpandScopeGroups();
        boolean isIncludeIdToken = false;
        String oidcPolicyId = null;
        if (!requestedScope.hasScope("openid")) return new AccessTokenMappingOutputGenerationStrategy(ACCESS_TOKEN_TYPE, requestedScope, accessTokenManagerId, mapping, isExpandScopeGroup, processorPolicy.getId(), isIncludeRefreshToken, isIncludeIdToken, oidcPolicyId, this.authzServerMgr);
        Set<OpenIdConnectProviderPolicy.PolicyGroup> oidcPolicies = this.oidcPolicySelector.select(request, client);
        if (oidcPolicies.isEmpty()) {
            String msg = "The openid scope was requested, but there are no OpenID Connect Policies configured. An ID Token will not be issued.";
            logger.debug(msg);
            return new AccessTokenMappingOutputGenerationStrategy(ACCESS_TOKEN_TYPE, requestedScope, accessTokenManagerId, mapping, isExpandScopeGroup, processorPolicy.getId(), isIncludeRefreshToken, isIncludeIdToken, oidcPolicyId, this.authzServerMgr);
        }
        OpenIdConnectProviderPolicy.PolicyGroup oidcPolicy = oidcPolicies.iterator().next();
        if (!oidcPolicy.isReturnIdTokenOnTokenExchangeGrant()) {
            String msg = "The openid scope was requested, but the OpenID Connect Provider Policy " + oidcPolicy.getPolicyId() + " does not return an ID Token on a Token Exchange Grant.";
            logger.debug(msg);
            return new AccessTokenMappingOutputGenerationStrategy(ACCESS_TOKEN_TYPE, requestedScope, accessTokenManagerId, mapping, isExpandScopeGroup, processorPolicy.getId(), isIncludeRefreshToken, isIncludeIdToken, oidcPolicyId, this.authzServerMgr);
        }
        if (oidcPolicy.getAccessTokenManagerId().equals(accessTokenManagerId)) {
            isIncludeIdToken = true;
            oidcPolicyId = oidcPolicy.getPolicyId();
            return new AccessTokenMappingOutputGenerationStrategy(ACCESS_TOKEN_TYPE, requestedScope, accessTokenManagerId, mapping, isExpandScopeGroup, processorPolicy.getId(), isIncludeRefreshToken, isIncludeIdToken, oidcPolicyId, this.authzServerMgr);
        }
        String msg = String.format("The Access Token Manager '%s' does not match the OpenID Connect Provider Policy '%s' that is configured to return an ID Token on a Token Exchange Grant.", accessTokenManagerId, oidcPolicy.getPolicyId());
        logger.error(msg);
        throw new TokenExchangeExecutionStrategyException(AccessTokenRequestException.Error.invalid_target, msg);
    }
}

