/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers.process.exchange.execution.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.exchange.domain.TokenExchangeGeneratorPolicy;
import org.sourceid.oauth20.exchange.manager.TokenExchangeGeneratorPolicyManager;
import org.sourceid.oauth20.handlers.process.exchange.TokenExchangeRequest;
import org.sourceid.oauth20.handlers.process.exchange.execution.OutputCreatorSelector;

public final class TokenExchangeGeneratorPolicySelector
implements OutputCreatorSelector<TokenExchangeGeneratorPolicy> {
    private final TokenExchangeGeneratorPolicyManager generatorPolicyMgr;

    public TokenExchangeGeneratorPolicySelector(TokenExchangeGeneratorPolicyManager generatorPolicyMgr) {
        this.generatorPolicyMgr = generatorPolicyMgr;
    }

    @Override
    public Set<TokenExchangeGeneratorPolicy> select(TokenExchangeRequest request, Client requestingClient) {
        Map<String, Set<TokenExchangeGeneratorPolicy>> policyByResource = this.getGeneratorPolicyByResource(request.getResource(), this.generatorPolicyMgr);
        Set<TokenExchangeGeneratorPolicy> policies = policyByResource.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        if (request.getResource().isEmpty() && policies.isEmpty() && this.generatorPolicyMgr.getTokenExchangeGeneratorPolicies().hasDefaultInstanceId()) {
            policies.add(this.generatorPolicyMgr.getDefaultPolicy());
        }
        return policies;
    }

    private Map<String, Set<TokenExchangeGeneratorPolicy>> getGeneratorPolicyByResource(Set<String> resource, TokenExchangeGeneratorPolicyManager generatorPolicyMgr) {
        HashMap<String, Set<TokenExchangeGeneratorPolicy>> result = new HashMap<String, Set<TokenExchangeGeneratorPolicy>>();
        if (resource == null || resource.isEmpty()) {
            return result;
        }
        for (String res : resource) {
            Set<TokenExchangeGeneratorPolicy> policies = generatorPolicyMgr.getPoliciesByResourceUri(res);
            if (policies.isEmpty()) continue;
            result.putIfAbsent(res, policies);
        }
        return result;
    }
}

