/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers.process.exchange.execution.impl;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.pingcommons.crypto.B64;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.oauth20.exchange.domain.ProcessorPolicy2GeneratorMapping;
import org.sourceid.oauth20.handlers.AccessTokenRequestException;
import org.sourceid.oauth20.handlers.process.GrantContext;
import org.sourceid.oauth20.handlers.process.exchange.execution.OutputGenerationStrategy;
import org.sourceid.oauth20.handlers.process.exchange.execution.exception.TokenExchangeExecutionException;
import org.sourceid.oauth20.token.AccessTokenResponse;
import org.sourceid.oauth20.token.TokenResponse;
import org.sourceid.saml20.domain.AttrLookupException;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.profiles.idp.AsAuditLogger;
import org.sourceid.websso.wrapper.OutMessageContext;
import org.sourceid.wstrust.mgmt.TokenGeneratorManager;
import org.sourceid.wstrust.model.BinarySecurityToken;
import org.sourceid.wstrust.model.SamlSecurityToken;
import org.sourceid.wstrust.model.SecurityToken;
import org.sourceid.wstrust.model.StringSecurityToken;
import org.sourceid.wstrust.plugin.TokenProcessingException;
import org.sourceid.wstrust.plugin.generate.TokenContext;
import org.sourceid.wstrust.plugin.generate.TokenGenerator;

public class TokenGeneratorOutputGenerationStrategy
implements OutputGenerationStrategy {
    private static final String END_OF_LINE = System.getProperty("line.separator");
    private static final Logger logger = LogManager.getLogger(TokenGeneratorOutputGenerationStrategy.class);
    public static final String FAILURE_MSG = "Failed to issue a new [%s] token type using [%s] token generator.";
    private final String requestedTokenType;
    private final String tokenGeneratorId;
    private final ProcessorPolicy2GeneratorMapping mapping;
    private final TokenGeneratorManager tokenGeneratorManager;

    public TokenGeneratorOutputGenerationStrategy(String requestedTokenType, String tokenGeneratorId, ProcessorPolicy2GeneratorMapping mapping, TokenGeneratorManager tokenGeneratorManager) {
        this.requestedTokenType = requestedTokenType;
        this.tokenGeneratorId = tokenGeneratorId;
        this.mapping = mapping;
        this.tokenGeneratorManager = tokenGeneratorManager;
    }

    @Override
    public GrantContext generate(AttributeMap inputAttrs, AttributeMap contextAttrs) throws TokenExchangeExecutionException {
        try {
            Set<String> targetNames = this.mapping.getAttributeMapping().keySet();
            AttributeMap resultFromPp2PGgMapping = this.mapping.executeMapping(inputAttrs, targetNames, contextAttrs);
            TokenGenerator tokenGenerator = this.tokenGeneratorManager.getTokenGenerator(this.tokenGeneratorId);
            TokenContext tokenContext = new TokenContext();
            tokenContext.setSubjectAttributes((Map)resultFromPp2PGgMapping);
            SecurityToken securityToken = tokenGenerator.generateToken(tokenContext);
            return new GrantContext<SecurityTokenTokenResponse>(new SecurityTokenTokenResponse(securityToken, this.requestedTokenType));
        }
        catch (TokenProcessingException e) {
            String msg = String.format(FAILURE_MSG, this.requestedTokenType, this.tokenGeneratorId);
            logger.error(msg);
            throw new TokenExchangeExecutionException(AccessTokenRequestException.Error.invalid_request, e.getMessage());
        }
        catch (AttrLookupException e) {
            String msg = String.format(FAILURE_MSG, this.requestedTokenType, this.tokenGeneratorId);
            logger.error(msg);
            throw new TokenExchangeExecutionException(AccessTokenRequestException.Error.server_error, e.getMessage(), e);
        }
        catch (AuthorizationException e) {
            String msg = String.format(FAILURE_MSG, this.requestedTokenType, this.tokenGeneratorId);
            logger.error(msg);
            throw new TokenExchangeExecutionException(AccessTokenRequestException.Error.access_denied, e.getMessage(), e);
        }
    }

    @Override
    public StringBuilder getInfo() {
        StringBuilder builder = new StringBuilder();
        builder.append("Type: ").append(this.getType()).append(END_OF_LINE);
        builder.append("Requested Token Type: ").append(this.requestedTokenType).append(END_OF_LINE);
        builder.append("Token Generator ID: ").append(this.tokenGeneratorId).append(END_OF_LINE);
        return builder;
    }

    @Override
    public String getType() {
        return "Security Token Generator";
    }

    private static class SecurityTokenTokenResponse
    extends AccessTokenResponse
    implements TokenResponse {
        private final SecurityToken securityToken;
        private final String requestedTokenType;

        private SecurityTokenTokenResponse(SecurityToken securityToken, String requestedTokenType) {
            super(null, null, null, null, null);
            this.securityToken = securityToken;
            this.requestedTokenType = requestedTokenType;
        }

        @Override
        public void tokenResponseToOutContext(OutMessageContext outMsgCtx) {
            if (this.securityToken instanceof SamlSecurityToken) {
                XmlObject xmlObject = ((SamlSecurityToken)this.securityToken).getAssertion();
                outMsgCtx.setParam("access_token", B64.encode((String)XmlBeansUtil.xmlText(xmlObject)), true);
            } else if (this.securityToken instanceof BinarySecurityToken) {
                String accessTokenData = ((BinarySecurityToken)this.securityToken).getEncodedData();
                outMsgCtx.setParam("access_token", accessTokenData, true);
            } else if (this.securityToken instanceof StringSecurityToken) {
                String data = ((StringSecurityToken)this.securityToken).getData();
                outMsgCtx.setParam("access_token", data, true);
            } else {
                throw new RuntimeException("Unsupported Security Token type");
            }
            outMsgCtx.setParam("issued_token_type", this.requestedTokenType);
            outMsgCtx.setParam("token_type", "N_A");
            if (this.securityToken.getExpiryDate() != null) {
                long millis = this.securityToken.getExpiryDate().getTime() - System.currentTimeMillis();
                long expiresIn = millis / 1000L;
                outMsgCtx.setParam("expires_in", expiresIn);
            }
            AsAuditLogger.setOutMsgCtx(outMsgCtx);
        }
    }
}

