/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers.utils;

import com.pingidentity.sdk.authorizationdetails.AuthorizationDetails;
import com.pingidentity.sdk.oauth20.Scope;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.handlers.AuthorizationRequestException;
import org.sourceid.oauth20.model.UserKeyAttributes;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public interface AuthorizationProcessor {
    public AuthorizationResult doAuthorize(HttpServletRequest var1, HttpServletResponse var2, InMessageContext var3, OutMessageContext var4, Map<String, Object> var5, Client var6, String var7, UserKeyAttributes var8, Scope var9, AuthorizationDetails var10) throws AuthorizationRequestException;

    public static final class AuthorizationResult {
        private final Status status;
        private final Scope approvedScope;
        private final AuthorizationDetails approvedAuthorizationDetails;

        public static AuthorizationResult getInProgressInstance() {
            return new AuthorizationResult(Status.IN_PROGRESS, null, null);
        }

        public static AuthorizationResult getDenyInstance() {
            return new AuthorizationResult(Status.DENY, null, null);
        }

        public AuthorizationResult(Status status, Scope approvedScope, AuthorizationDetails approvedAuthorizationDetails) {
            this.status = status;
            this.approvedScope = approvedScope;
            this.approvedAuthorizationDetails = approvedAuthorizationDetails;
        }

        public Status getStatus() {
            return this.status;
        }

        public Scope getApprovedScope() {
            return this.approvedScope;
        }

        public AuthorizationDetails getApprovedAuthorizationDetails() {
            return this.approvedAuthorizationDetails;
        }

        public static enum Status {
            ALLOW("allow"),
            DENY("deny"),
            IN_PROGRESS("in-progress");

            private String value;

            private Status(String value) {
                this.value = value;
            }

            public String getValue() {
                return this.value;
            }
        }
    }
}

