/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers.utils;

import com.pingidentity.sdk.authorizationdetails.AuthorizationDetail;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetails;
import com.pingidentity.sdk.oauth20.Scope;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.oauth20.authorizationdetails.domain.AuthorizationDetailsUtil;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.handlers.AuthorizationRequestException;
import org.sourceid.oauth20.handlers.utils.AuthorizationProcessor;
import org.sourceid.oauth20.model.UserKeyAttributes;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.idp.authn.AuthnPolicy;
import org.sourceid.saml20.service.AdapterAuthnSourceKey;
import org.sourceid.saml20.state.StateSupport;
import org.sourceid.websso.authn.AdapterAuthnProcessor;
import org.sourceid.websso.authn.AuthnProcessorResult;
import org.sourceid.websso.servlet.reqparam.HttpServletReqProxy;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class ExternalAuthorizationProcessor
implements AuthorizationProcessor {
    private static final Log log = LogFactory.getLog(ExternalAuthorizationProcessor.class);
    private static final String HTTP_REQ_PARAMS_REMOVED = "http:req:params:removed";
    protected final AuthzServerManager authzServerMgr;
    private final StateSupport stateSupport;
    private final AuthnPolicy authnPolicy;

    public ExternalAuthorizationProcessor(StateSupport stateSupport, AuthnPolicy authnPolicy, AuthzServerManager authzServerMgr) {
        this.stateSupport = stateSupport;
        this.authnPolicy = authnPolicy;
        this.authzServerMgr = authzServerMgr;
    }

    @Override
    public AuthorizationProcessor.AuthorizationResult doAuthorize(HttpServletRequest req, HttpServletResponse resp, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, Map<String, Object> otherState, Client client, String userKeyValue, UserKeyAttributes userKeyAttrs, Scope requestedScope, AuthorizationDetails requestedAuthorizationDetails) throws AuthorizationRequestException {
        Scope approvedScope = requestedScope;
        AuthorizationDetails approvedAuthorizationDetails = requestedAuthorizationDetails;
        try {
            if (!otherState.containsKey(HTTP_REQ_PARAMS_REMOVED)) {
                ((HttpServletReqProxy)req).clearParameters();
                otherState.put(HTTP_REQ_PARAMS_REMOVED, true);
            }
            String resumePath = this.stateSupport.saveState(req, resp, inMsgCtx, outMsgCtx, otherState, null);
            HashMap<String, AttributeValue> chainedAttr = new HashMap<String, AttributeValue>();
            chainedAttr.put("USER_KEY", new AttributeValue(userKeyValue));
            chainedAttr.put("USER_NAME", new AttributeValue(userKeyAttrs.getUserNameValue()));
            otherState.put("chainedAttributes", chainedAttr);
            AdapterAuthnSourceKey adapterAuthnSourceKey = new AdapterAuthnSourceKey(this.authzServerMgr.getExternalConsentAdapterId());
            otherState.put("adapterAction", "com.pingidentity.adapter.action.external.consent");
            AdapterAuthnProcessor adapterAuthnProcessor = new AdapterAuthnProcessor();
            AuthnProcessorResult adapterResponse = adapterAuthnProcessor.lookupAuthN(req, resp, adapterAuthnSourceKey, this.authnPolicy, resumePath, otherState, false);
            switch (adapterResponse.getAuthnStatus()) {
                case IN_PROGRESS: {
                    log.debug((Object)("Attempting to get approval for requested scopes and/or authorization details from external consent system using adapter Id: " + this.authzServerMgr.getExternalConsentAdapterId()));
                    return AuthorizationProcessor.AuthorizationResult.getInProgressInstance();
                }
                case FAILURE: {
                    log.debug((Object)"External Consent adapter failed or the user did not approve the requested scopes and/or authorization details.");
                    return AuthorizationProcessor.AuthorizationResult.getDenyInstance();
                }
                case SUCCESS: {
                    log.debug((Object)"External Consent adapter succeeded and returned approved scopes and/or authorization details");
                    if (adapterResponse.getAuthnBean() == null) {
                        approvedScope = new Scope(new String[0]);
                        approvedAuthorizationDetails = new AuthorizationDetails();
                    } else if (adapterResponse.getAuthnBean().getAuthnIdentifiersMap() != null) {
                        Object returnedScopes = adapterResponse.getAuthnBean().getAuthnIdentifiersMap().get(this.authzServerMgr.getReturnedScopeAttributeName());
                        approvedScope = this.getApprovedScopes(returnedScopes);
                        Object returnedAuthorizationDetails = adapterResponse.getAuthnBean().getAuthnIdentifiersMap().get(this.authzServerMgr.getReturnedAuthorizationDetailsAttributeName());
                        approvedAuthorizationDetails = this.getApprovedAuthorizationDetails(returnedAuthorizationDetails);
                    }
                    return new AuthorizationProcessor.AuthorizationResult(AuthorizationProcessor.AuthorizationResult.Status.ALLOW, approvedScope, approvedAuthorizationDetails);
                }
            }
            log.debug((Object)("Adapter must return IN_PROGRESS, FAILURE, or SUCCESS result back. It received " + adapterResponse.getAuthnStatus()));
            return AuthorizationProcessor.AuthorizationResult.getDenyInstance();
        }
        catch (IOException | AuthnAdapterException e) {
            String msg = "External Consent adapter failed or the user did not approve the requested scopes and/or authorization details.";
            log.debug((Object)msg, e);
            if (e instanceof AuthnAdapterException && StringUtils.isNotBlank((String)e.getMessage())) {
                msg = e.getMessage();
            }
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.server_error, msg);
        }
    }

    private AuthorizationDetails getApprovedAuthorizationDetails(Object returnedAuthorizationDetails) {
        try {
            if (returnedAuthorizationDetails instanceof String) {
                return new AuthorizationDetails((String)returnedAuthorizationDetails);
            }
            if (returnedAuthorizationDetails instanceof AuthorizationDetail[]) {
                return new AuthorizationDetails((AuthorizationDetail[])returnedAuthorizationDetails);
            }
            if (returnedAuthorizationDetails instanceof Collection) {
                return AuthorizationDetailsUtil.getAuthorizationDetailsFromCollection((Collection)returnedAuthorizationDetails);
            }
            if (returnedAuthorizationDetails instanceof AttributeValue) {
                return AuthorizationDetailsUtil.getAuthorizationDetailsAttributeValue((AttributeValue)returnedAuthorizationDetails);
            }
            if (returnedAuthorizationDetails != null) {
                log.warn((Object)("Invalid return type for authorization details: " + returnedAuthorizationDetails.getClass()));
            }
            return new AuthorizationDetails();
        }
        catch (IOException e) {
            log.debug((Object)"error processing returned authorization details", (Throwable)e);
            return new AuthorizationDetails();
        }
    }

    private Scope getApprovedScopes(Object returnedScopes) {
        if (returnedScopes instanceof String) {
            return Scope.getScope((String)((String)returnedScopes));
        }
        if (returnedScopes instanceof String[]) {
            return new Scope((String[])returnedScopes);
        }
        if (returnedScopes instanceof Collection) {
            return new Scope((Set)new AttributeValue((Collection)returnedScopes).getValuesAsHashSet());
        }
        if (returnedScopes instanceof AttributeValue) {
            return new Scope((Set)((AttributeValue)returnedScopes).getValuesAsHashSet());
        }
        if (returnedScopes != null) {
            log.warn((Object)("Invalid returned scope type: " + returnedScopes.getClass()));
        }
        return new Scope(new String[0]);
    }
}

