/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.handlers.utils;

import com.pingidentity.access.AuthorizationDetailProcessorAccessor;
import com.pingidentity.common.util.CrossSiteRequestForgeryHelper;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetail;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetailContext;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetails;
import com.pingidentity.sdk.locale.LocaleUtil;
import com.pingidentity.sdk.oauth20.Scope;
import com.pingidentity.templates.mgmt.DefaultTemplateParams;
import com.pingidentity.templates.mgmt.TemplateParamUtil;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.IDGenerator;
import org.sourceid.common.ResponseTemplateRenderer;
import org.sourceid.common.ResponseTemplateRendererException;
import org.sourceid.oauth20.authorizationdetails.domain.AuthorizationDetailsUtil;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ScopeUtil;
import org.sourceid.oauth20.handlers.AuthorizationRequestException;
import org.sourceid.oauth20.handlers.HandlerUtil;
import org.sourceid.oauth20.handlers.utils.AuthorizationProcessor;
import org.sourceid.oauth20.model.UserKeyAttributes;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.saml20.state.StateSupport;
import org.sourceid.websso.profiles.idp.AsAuditLogger;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class PingFederateAuthorizationProcessor
implements AuthorizationProcessor {
    private static final Log log = LogFactory.getLog(PingFederateAuthorizationProcessor.class);
    private final StateSupport stateSupport;

    public PingFederateAuthorizationProcessor(StateSupport stateSupport) {
        this.stateSupport = stateSupport;
    }

    @Override
    public final AuthorizationProcessor.AuthorizationResult doAuthorize(HttpServletRequest req, HttpServletResponse resp, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, Map<String, Object> otherState, Client client, String userKeyValue, UserKeyAttributes userKeyAttrs, Scope requestedScope, AuthorizationDetails requestedAuthorizationDetails) throws AuthorizationRequestException {
        String authzDecision = req.getParameter("pf.oauth.authz.consent");
        if (!StringUtils.isEmpty((String)authzDecision)) {
            this.validateCSRF(req, otherState);
            if (AuthorizationProcessor.AuthorizationResult.Status.DENY.getValue().equals(authzDecision)) {
                return AuthorizationProcessor.AuthorizationResult.getDenyInstance();
            }
            Scope approvedScope = requestedScope;
            approvedScope = this.getApprovedScope(req, requestedScope, approvedScope);
            AuthorizationDetails approvedAuthorizationDetails = this.getApprovedAuthorizationDetails(requestedAuthorizationDetails, req, client.getClientId(), approvedScope, otherState);
            return new AuthorizationProcessor.AuthorizationResult(AuthorizationProcessor.AuthorizationResult.Status.ALLOW, approvedScope, approvedAuthorizationDetails);
        }
        this.renderAuthorizationForm(inMsgCtx, req, resp, outMsgCtx, otherState, userKeyAttrs, userKeyValue, requestedScope, client, requestedAuthorizationDetails);
        return AuthorizationProcessor.AuthorizationResult.getInProgressInstance();
    }

    private void renderAuthorizationForm(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx, Map<String, Object> otherState, UserKeyAttributes userKeyAttrs, String userKeyValue, Scope requestedScope, Client client, AuthorizationDetails enrichedAuthorizationDetails) throws AuthorizationRequestException {
        String cSRFToken = IDGenerator.rndAlphaNumeric(20);
        otherState.put("csrfToken", cSRFToken);
        String resumePath = this.stateSupport.saveState(req, resp, inMsgCtx, outMsgCtx, otherState, null);
        Map<String, Object> params = new DefaultTemplateParams.Builder(DefaultTemplateParams.Role.IDP).clientId(client.getClientId()).build();
        params.put("cSRFToken", cSRFToken);
        params.put("userKeyAttributes", (Object)userKeyAttrs);
        params.put("userKey", userKeyValue);
        params.put("userName", userKeyAttrs.getUserNameValue());
        params.put("client", client);
        params.put("clientLogoUrl", client.getLogoUrl());
        params.put("clientName", client.getName());
        params.put("clientDescription", client.getDescription());
        Locale locale = LocaleUtil.getUserLocale((HttpServletRequest)req);
        Map<String, String> scopeDescriptions = ScopeUtil.getDescriptionsForRequestedScope(client, requestedScope, locale);
        params.put("scopeDescriptions", scopeDescriptions);
        String defaultScopeDesc = ScopeUtil.getDefaultScopeDescription(locale);
        params.put("defaultScopeDescription", defaultScopeDesc);
        Map<String, String> authorizationDetailsDescriptions = AuthorizationDetailsUtil.getDescriptionsWithIdentifiers(enrichedAuthorizationDetails, req, client.getClientId(), requestedScope, otherState);
        params.put("authorizationDetailsDescriptions", authorizationDetailsDescriptions);
        params.put("action", resumePath);
        params.put(Parameters.CLIENT_ID, client.getClientId());
        params.put("grantAttributes", TemplateParamUtil.convertAttributeMapToTemplateParams(userKeyAttrs.getExtendedAttributes()));
        req = HandlerUtil.checkUiLocalesForRequest(inMsgCtx, req);
        ResponseTemplateRenderer renderer = ResponseTemplateRenderer.getInstance();
        try {
            renderer.render(req, resp, "oauth.approval.page.template.html", params);
        }
        catch (ResponseTemplateRendererException e) {
            AsAuditLogger.setDescription(AuthorizationRequestException.Error.invalid_request);
            log.debug((Object)e);
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request);
        }
    }

    private void validateCSRF(HttpServletRequest req, Map<String, Object> otherState) throws AuthorizationRequestException {
        String cSRFTokenOnForm = req.getParameter("cSRFToken");
        String cSRFToken = (String)otherState.get("csrfToken");
        CrossSiteRequestForgeryHelper.ValidationStatus status = CrossSiteRequestForgeryHelper.validateCSRFToken(cSRFToken, cSRFTokenOnForm);
        if (!status.isValid()) {
            AsAuditLogger.setDescription(AuthorizationRequestException.Error.invalid_request);
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request, status.getErrorMessage());
        }
    }

    private Scope getApprovedScope(HttpServletRequest req, Scope requestedScope, Scope approvedScope) throws AuthorizationRequestException {
        String[] approvedScopeStrings;
        if (Boolean.parseBoolean(req.getParameter("check-user-approved-scope")) && !(approvedScope = new Scope(approvedScopeStrings = req.getParameterValues(Parameters.SCOPE))).isEqualOrLesserThan(requestedScope)) {
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_scope, "approved scope cannot exceed the requested scope");
        }
        return approvedScope;
    }

    private AuthorizationDetails getApprovedAuthorizationDetails(AuthorizationDetails requestedAuthorizationDetails, HttpServletRequest req, String clientId, Scope approvedScope, Map<String, Object> otherState) throws AuthorizationRequestException {
        AuthorizationDetailContext context;
        String[] approvedAuthorizationDetailsId;
        AuthorizationDetail[] approvedAuthorizationDetailsArray;
        String stateAuthorizationDetails = (String)otherState.get("authorization_details");
        if (stateAuthorizationDetails != null) {
            try {
                requestedAuthorizationDetails = new AuthorizationDetails(stateAuthorizationDetails);
            }
            catch (IOException e) {
                log.error((Object)"Error deserializing state enriched authorization details", (Throwable)e);
                throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_authorization_details);
            }
        }
        AuthorizationDetails approvedAuthorizationDetails = requestedAuthorizationDetails;
        if (Boolean.parseBoolean(req.getParameter("check-user-approved-scope")) && !AuthorizationDetailProcessorAccessor.isEqualOrSubset((AuthorizationDetails)(approvedAuthorizationDetails = new AuthorizationDetails(approvedAuthorizationDetailsArray = AuthorizationDetailsUtil.getDetailsFromIdentifiers(approvedAuthorizationDetailsId = req.getParameterValues("authorization_details"), otherState))), (AuthorizationDetails)requestedAuthorizationDetails, (AuthorizationDetailContext)(context = new AuthorizationDetailContext(req, clientId, approvedScope)))) {
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_authorization_details, "approved authorization details cannot exceed the requested authorization details");
        }
        return approvedAuthorizationDetails;
    }
}

