/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.issuer.domain;

import com.pingidentity.common.util.PropertyInfo;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.sourceid.oauth.issuer.xmlbinding.OAuthIssuerType;
import org.sourceid.util.BaseUrlUtil;

public class OAuthIssuer
implements Serializable {
    private static final long serialVersionUID = 2020020101L;
    private String id;
    private final String name;
    private final String desc;
    private final String host;
    private final String path;

    public OAuthIssuer(OAuthIssuerType oAuthIssuerType) {
        this(oAuthIssuerType.getId(), oAuthIssuerType.getName(), oAuthIssuerType.getDescription(), oAuthIssuerType.getHost(), oAuthIssuerType.getPath());
    }

    public OAuthIssuer(String id, String name, String desc, String host, String path) {
        this.id = id;
        this.name = name;
        this.desc = desc;
        this.host = host;
        this.path = path;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getHost() {
        return this.host;
    }

    public String getPath() {
        return this.path;
    }

    public String constructIssuer(HttpServletRequest request) {
        StringBuilder builder = this.buildUrl(request);
        builder.append(this.path);
        return builder.toString();
    }

    public String constructIssuerWithoutPort() {
        StringBuilder builder = new StringBuilder();
        builder.append("https://").append(this.host);
        builder.append(this.path);
        return builder.toString();
    }

    public String normalizePathInfo(String pathInfo) {
        if (StringUtils.isBlank((String)this.path)) {
            return pathInfo;
        }
        if (pathInfo.startsWith(this.path + "/")) {
            String normalizedPath = pathInfo.substring(this.path.length() + 1);
            Object contextPath = PropertyInfo.getContextPath();
            if (!((String)contextPath).endsWith("/")) {
                contextPath = (String)contextPath + "/";
            }
            return (String)contextPath + normalizedPath;
        }
        return null;
    }

    public String constructCurrentRequestUrl(HttpServletRequest request) {
        Object contextPath = PropertyInfo.getContextPath();
        if (!((String)contextPath).endsWith("/")) {
            contextPath = (String)contextPath + "/";
        }
        String requestURI = request.getRequestURI().substring(((String)contextPath).length());
        return this.constructIssuer(request) + "/" + requestURI;
    }

    public String toString() {
        return "OAuthIssuer{id='" + this.id + "', name='" + this.name + "', desc='" + this.desc + "', host='" + this.host + "', path='" + this.path + "'}";
    }

    private StringBuilder buildUrl(HttpServletRequest request) {
        StringBuilder builder = new StringBuilder();
        builder.append("https://").append(this.host);
        int port = BaseUrlUtil.getPort(request);
        if (port > 0) {
            builder.append(":").append(port);
        }
        return builder;
    }
}

