/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.profiles;

import com.pingidentity.common.util.CrossSiteRequestForgeryHelper;
import com.pingidentity.locale.LocaleUtil;
import com.pingidentity.sdk.accessgrant.AccessGrant;
import com.pingidentity.sdk.accessgrant.AccessGrantManager;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.owasp.encoder.Encode;
import org.sourceid.common.ResponseTemplateRenderer;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.issuer.OAuthIssuerUtils;
import org.sourceid.oauth20.issuer.domain.OAuthIssuer;
import org.sourceid.oauth20.model.UserKeyAttributes;
import org.sourceid.oauth20.utils.AccessGrantUtils;
import org.sourceid.saml20.adapter.state.ApplicationSessionStateSupport;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.profiles.AdapterPathSupport;
import org.sourceid.saml20.service.AdapterAuthnSourceKey;
import org.sourceid.saml20.service.IdpConnAuthnSourceKey;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.RequestCreatorBase;
import org.sourceid.websso.profiles.idp.AsAuditLogger;
import org.sourceid.websso.wrapper.OutMessageContext;

public class OAuthAccessGrantsRequestCreator
extends RequestCreatorBase {
    private static final String PF_IDP_ADAPTER_ID = "pfidpadapterid";
    private static final String PARTNER_IDP_ID = "PartnerIdpId";
    private static final String IDP = "idp";
    private final AccessGrantManager accessGrantMgr = MgmtFactory.getAccessGrantManager();
    private final OAuthIssuerUtils oAuthIssuerUtils = OAuthIssuerUtils.getInstance();
    private final ClientManager clientManager = MgmtFactory.getClientManager();

    @Override
    public OutMessageContext doProcess(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        AsAuditLogger.setEvent("OAuth");
        AsAuditLogger.setProtocol("OAuth20");
        ApplicationSessionStateSupport applicationSessionStateSupport = new ApplicationSessionStateSupport("oauth.access.grants", (sessionStateSupport, request, response) -> sessionStateSupport.removeAttribute("attrs", request, response));
        UserKeyAttributes userKeyAttrs = (UserKeyAttributes)((Object)applicationSessionStateSupport.getAttribute("attrs", req, resp));
        Object oAuthIssuer = applicationSessionStateSupport.getAttribute("oauth.issuer", req, resp);
        if (oAuthIssuer instanceof OAuthIssuer) {
            this.oAuthIssuerUtils.addOAuthIssuerToRequest(req, (OAuthIssuer)oAuthIssuer);
        }
        AsAuditLogger.setAttributes(userKeyAttrs);
        this.getAuditLogParamsFromReq(req);
        if (userKeyAttrs == null || req.getParameter(IDP) != null || req.getParameter(PARTNER_IDP_ID) != null || req.getParameter(PF_IDP_ADAPTER_ID) != null) {
            resp.sendRedirect(AdapterPathSupport.convertPath(req, resp, "/as/grants.oauth2") + this.createRedirectionParams(req));
        } else {
            String cSRFToken = (String)applicationSessionStateSupport.getAttribute("csrfToken", req, resp);
            if (req.getParameterValues("guid") != null) {
                String cSRFTokenOnForm = req.getParameter("cSRFToken");
                CrossSiteRequestForgeryHelper.ValidationStatus status = CrossSiteRequestForgeryHelper.validateCSRFToken(cSRFToken, cSRFTokenOnForm);
                if (!status.isValid()) {
                    AsAuditLogger.setStatus("failure");
                    AsAuditLogger.setDescription("Invalid Request");
                    AsAuditLogger.log("Invalid Request");
                    throw new ProcessRuntimeException("Invalid request");
                }
                Object[] guids = req.getParameterValues("guid");
                if (guids != null) {
                    for (String string : guids) {
                        this.accessGrantMgr.revokeGrant(userKeyAttrs.getUserKeyValue(), string);
                    }
                    if (guids.length == 1) {
                        AsAuditLogger.setAccessGrantGuid(guids[0]);
                    } else if (guids.length > 1) {
                        AsAuditLogger.setAccessGrantGuid(Arrays.toString(guids));
                    }
                    AsAuditLogger.setStatus("success");
                    AsAuditLogger.log("Token Revoked");
                }
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            SimpleDateFormat sdf = new SimpleDateFormat("MMM d, yyyy, hh:mm:ss a (z)", LocaleUtil.getUserLocale(req));
            Collection grants = this.accessGrantMgr.getByUserKey(userKeyAttrs.getUserKeyValue()).stream().filter(AccessGrantUtils::isAccessGrant).map(grant -> new AccessGrantWrapper((AccessGrant)grant, this.clientManager.getCachedClient(grant.getClientId()))).collect(Collectors.toList());
            params.put("dateformat", sdf);
            params.put("grants", grants);
            params.put("action", AdapterPathSupport.convertPath(req, resp, "/as/oauth_access_grants.ping"));
            params.put("userName", userKeyAttrs.getUserNameValue());
            params.put("cSRFToken", cSRFToken);
            ResponseTemplateRenderer renderer = ResponseTemplateRenderer.getInstance();
            renderer.render(req, resp, "oauth.access.grants.page.template.html", params);
        }
        return null;
    }

    private String createRedirectionParams(HttpServletRequest req) {
        String nameValuePair;
        StringBuilder sb = new StringBuilder();
        if (req.getParameter(IDP) != null) {
            nameValuePair = "idp=" + Encode.forUriComponent((String)req.getParameter(IDP));
            sb.append(sb.length() == 0 ? "?" : "&").append(nameValuePair);
        }
        if (req.getParameter(PARTNER_IDP_ID) != null) {
            nameValuePair = "PartnerIdpId=" + Encode.forUriComponent((String)req.getParameter(PARTNER_IDP_ID));
            sb.append(sb.length() == 0 ? "?" : "&").append(nameValuePair);
        }
        if (req.getParameter(PF_IDP_ADAPTER_ID) != null) {
            nameValuePair = "pfidpadapterid=" + Encode.forUriComponent((String)req.getParameter(PF_IDP_ADAPTER_ID));
            sb.append(sb.length() == 0 ? "?" : "&").append(nameValuePair);
        }
        return sb.toString();
    }

    private void getAuditLogParamsFromReq(HttpServletRequest req) {
        String partnerId;
        String pfidpadapterid = req.getParameter(PF_IDP_ADAPTER_ID);
        if (StringUtils.isNotBlank((String)pfidpadapterid)) {
            AuditLogger.setAuthnSourceId(new AdapterAuthnSourceKey(pfidpadapterid));
        }
        if (StringUtils.isNotBlank((String)(partnerId = req.getParameter(PARTNER_IDP_ID)))) {
            AuditLogger.setPartnerId(partnerId);
            AuditLogger.setAuthnSourceId(new IdpConnAuthnSourceKey(pfidpadapterid));
        }
    }

    public static class AccessGrantWrapper {
        private final Client client;
        private final AccessGrant grant;

        public AccessGrantWrapper(AccessGrant grant, Client client) {
            this.grant = grant;
            this.client = client;
        }

        public Client getClient() {
            return this.client;
        }

        public AccessGrant getGrant() {
            return this.grant;
        }
    }
}

