/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.protocol;

import java.util.ArrayList;
import java.util.List;

public class GrantTypes {
    public static final String AUTHORIZATION_CODE = "authorization_code";
    public static final String RESOURCE_OWNER_PASSWORD_CREDENTIALS = "password";
    public static final String CLIENT_CREDENTIALS = "client_credentials";
    public static final String REFRESH_TOKEN = "refresh_token";
    public static final String IMPLICIT = "implicit";
    public static final String EXTENSION = "extension";
    public static final String PING_VALIDATE = "urn:pingidentity.com:oauth2:grant_type:validate_bearer";
    public static final String SAML2_BEARER = "urn:ietf:params:oauth:grant-type:saml2-bearer";
    public static final String JWT_BEARER = "urn:ietf:params:oauth:grant-type:jwt-bearer";
    public static final String DEVICE_CODE = "urn:ietf:params:oauth:grant-type:device_code";
    public static final String CIBA = "urn:openid:params:grant-type:ciba";
    public static final String TOKEN_EXCHANGE = "urn:ietf:params:oauth:grant-type:token-exchange";
    private static final List<String> extensionGrantTypes = new ArrayList<String>();

    public static boolean isExtensionGrantType(String grantType) {
        return extensionGrantTypes.contains(grantType);
    }

    public static boolean isValidGrant(String grant) {
        return grant.equals(AUTHORIZATION_CODE) || grant.equals(RESOURCE_OWNER_PASSWORD_CREDENTIALS) || grant.equals(CLIENT_CREDENTIALS) || grant.equals(REFRESH_TOKEN) || grant.equals(IMPLICIT) || grant.equals(EXTENSION) || grant.equals(PING_VALIDATE) || grant.equals(SAML2_BEARER) || grant.equals(DEVICE_CODE) || grant.equals(CIBA) || grant.equals(TOKEN_EXCHANGE);
    }

    static {
        extensionGrantTypes.add(SAML2_BEARER);
        extensionGrantTypes.add(JWT_BEARER);
    }
}

