/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.protocol;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.SpaceDelimitedStringUtil;
import org.sourceid.oauth20.domain.Client;

public class ResponseType
implements Serializable {
    public static final String CODE = "code";
    public static final String TOKEN = "token";
    public static final String ID_TOKEN = "id_token";
    public static final String POST = "x_post";
    protected static final String NONE = "none";
    private final String responseTypeString;
    private final Set<String> parts;
    private String responseModeString;

    public ResponseType(String rawTypeValue, String requestedResponseMode) {
        this.responseTypeString = rawTypeValue;
        this.parts = new HashSet<String>();
        SpaceDelimitedStringUtil.fromString((String)this.responseTypeString, this.parts);
        if (StringUtils.isNotBlank((String)requestedResponseMode)) {
            this.responseModeString = requestedResponseMode;
        }
    }

    ResponseMode getRequestedResponseMode() {
        if (this.responseModeString == null) {
            return null;
        }
        try {
            return ResponseMode.forIdentifier(this.responseModeString);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return null;
        }
    }

    public boolean isResponseModeValid() {
        return this.responseModeString == null || this.getRequestedResponseMode() != null;
    }

    public ResponseMode getResponseMode() {
        ResponseMode requestedResponseMode = this.getRequestedResponseMode();
        return requestedResponseMode == null ? this.getDefaultResponseMode() : requestedResponseMode;
    }

    ResponseMode getDefaultResponseMode() {
        if (this.has(POST)) {
            return ResponseMode.form_post;
        }
        if (this.hasExactly(CODE)) {
            return ResponseMode.query;
        }
        if (this.hasAny(ID_TOKEN, TOKEN)) {
            return ResponseMode.fragment;
        }
        return null;
    }

    public boolean sendsIdTokenFrontChannel() {
        return this.parts.contains(ID_TOKEN);
    }

    public String getFirstImpliedGrantType() {
        return this.hasExactly(CODE) ? "authorization_code" : "implicit";
    }

    public String[] getImpliedGrantTypes() {
        boolean code = this.has(CODE);
        boolean implicit = this.hasAny(TOKEN, ID_TOKEN);
        if (code && !implicit) {
            return new String[]{"authorization_code"};
        }
        if (!code && implicit) {
            return new String[]{"implicit"};
        }
        if (code && implicit) {
            return new String[]{"implicit", "authorization_code"};
        }
        return new String[0];
    }

    public boolean has(String responseTypePart) {
        return this.parts.contains(responseTypePart);
    }

    public boolean hasAll(String ... responseTypeParts) {
        for (String part : responseTypeParts) {
            if (this.has(part)) continue;
            return false;
        }
        return true;
    }

    public boolean hasAny(String ... responseTypeParts) {
        for (String part : responseTypeParts) {
            if (!this.has(part)) continue;
            return true;
        }
        return false;
    }

    public boolean hasExactly(String ... responseTypeParts) {
        return this.parts.size() == responseTypeParts.length && this.hasAll(responseTypeParts);
    }

    public String getResponseTypeString() {
        return this.responseTypeString;
    }

    public boolean isValidResponseType() {
        if (this.parts.isEmpty() || this.parts.size() > 4) {
            return false;
        }
        if (this.parts.contains(NONE)) {
            return false;
        }
        if (this.hasExactly(POST)) {
            return false;
        }
        HashSet<String> temp = new HashSet<String>(this.parts);
        temp.remove(CODE);
        temp.remove(TOKEN);
        temp.remove(ID_TOKEN);
        temp.remove(POST);
        return temp.isEmpty();
    }

    public boolean isValidModeTypeCombination() {
        ResponseMode requestedResponseMode = this.getRequestedResponseMode();
        return requestedResponseMode != ResponseMode.query || !this.hasAny(TOKEN, ID_TOKEN);
    }

    public boolean isValidJarmModeTypeCombination(Client client) {
        ResponseMode requestedResponseMode = this.getRequestedResponseMode();
        return !StringUtils.isBlank((String)client.getAuthorizationResponseEncryptionAlgorithm()) || requestedResponseMode != ResponseMode.query_jwt || !this.hasAny(TOKEN, ID_TOKEN);
    }

    public boolean isReturnClaimsInIdToken() {
        return this.hasExactly(ID_TOKEN) || this.hasExactly(ID_TOKEN, POST);
    }

    public String[] getParts() {
        return this.parts.toArray(new String[this.parts.size()]);
    }

    public static enum ResponseMode {
        fragment("fragment"),
        fragment_jwt("fragment.jwt"),
        query("query"),
        query_jwt("query.jwt"),
        form_post("form_post"),
        form_post_jwt("form_post.jwt"),
        jwt("jwt"),
        pi_flow("pi.flow");

        private final String identifier;

        private ResponseMode(String identifier) {
            this.identifier = identifier;
        }

        public static ResponseMode forIdentifier(String identifier) {
            for (ResponseMode mode : ResponseMode.values()) {
                if (!mode.identifier.equals(identifier)) continue;
                return mode;
            }
            throw new IllegalArgumentException("Unrecognized response mode: " + identifier);
        }

        public static boolean isJarmType(String identifier) {
            if (StringUtils.isBlank((String)identifier)) {
                return false;
            }
            ResponseMode responseMode = ResponseMode.forIdentifier(identifier);
            return responseMode.equals((Object)jwt) || responseMode.equals((Object)query_jwt) || responseMode.equals((Object)fragment_jwt) || responseMode.equals((Object)form_post_jwt);
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String toString() {
            return this.identifier;
        }
    }
}

