/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.token;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.common.util.Obfuscator;
import com.pingidentity.common.util.ServiceInformation;
import com.pingidentity.common.util.ldap.LDAPUtil;
import com.pingidentity.sdk.accessgrant.AccessGrant;
import com.pingidentity.sdk.accessgrant.exception.AccessGrantManagementException;
import com.sun.jndi.ldap.LdapName;
import java.util.Collection;
import java.util.Collections;
import javax.naming.NamingException;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import org.apache.commons.lang.StringUtils;
import org.sourceid.oauth20.token.AccessGrantAttribute;
import org.sourceid.oauth20.token.AccessGrantManagerLDAPADImpl;

public class AccessGrantManagerLDAPOracleImpl
extends AccessGrantManagerLDAPADImpl {
    @Override
    public void deleteGrant(String accessGrantGuid) {
        try {
            this.checkConfiguration();
            StringBuffer s = new StringBuffer();
            s.append(this.FIELDNAME_GUID).append("=").append(accessGrantGuid);
            LdapName ldapName = new LdapName(s.toString() + "," + this.searchBase);
            LDAPUtil.newInstance(this.getLdapDataSource(), (ServiceInformation)this).deleteAccessGrant(ldapName);
        }
        catch (NamingException e) {
            this.log.error((Object)("Unable to delete grant due to : " + e.getMessage()));
            this.setAuditLogParams();
            throw new AccessGrantManagementException((Throwable)e);
        }
    }

    @Override
    protected void saveGrant(AccessGrant accessGrant, Collection<AccessGrantAttribute> attributes) {
        this.checkConfiguration();
        try {
            StringBuffer s = new StringBuffer();
            BasicAttributes attrsToLdap = new BasicAttributes();
            attrsToLdap.put("objectclass", this.accessGrantObjectClassName);
            attrsToLdap.put(this.FIELDNAME_GUID, accessGrant.getGuid());
            s.append(this.FIELDNAME_GUID).append("=").append(accessGrant.getGuid());
            if (!StringUtils.isBlank((String)accessGrant.getUniqueUserIdentifer())) {
                attrsToLdap.put(this.FIELDNAME_UNIQUE_USER_ID, accessGrant.getUniqueUserIdentifer());
            }
            if (!StringUtils.isBlank((String)accessGrant.getHashedRefreshTokenValue())) {
                attrsToLdap.put(this.FIELDNAME_HASHED_REFRESH_TOKEN, accessGrant.getHashedRefreshTokenValue());
            }
            if (!StringUtils.isBlank((String)accessGrant.getScope().getScopeStr())) {
                attrsToLdap.put(this.FIELDNAME_SCOPE, accessGrant.getScope().getScopeStr());
            }
            if (!StringUtils.isBlank((String)accessGrant.getClientId())) {
                attrsToLdap.put(this.FIELDNAME_CLIENT_ID, accessGrant.getClientId());
            }
            if (!StringUtils.isBlank((String)accessGrant.getGrantType())) {
                attrsToLdap.put(this.FIELDNAME_GRANT_TYPE, accessGrant.getGrantType());
            }
            if (!StringUtils.isBlank((String)accessGrant.getContextualQualifier())) {
                attrsToLdap.put(this.FIELDNAME_CONTEXT_QUALIFIER, accessGrant.getContextualQualifier());
            }
            attrsToLdap.put(this.FIELDNAME_ISSUED, Long.toString(accessGrant.getIssued()));
            attrsToLdap.put(this.FIELDNAME_UPDATED, Long.toString(accessGrant.getUpdated()));
            if (accessGrant.getExpires() != null) {
                attrsToLdap.put(this.FIELDNAME_EXPIRES, accessGrant.getExpires().toString());
            }
            if (accessGrant.getAuthorizationDetails() != null && accessGrant.getAuthorizationDetails().getDetails() != null && !accessGrant.getAuthorizationDetails().getDetails().isEmpty()) {
                AccessGrantAttribute attribute = new AccessGrantAttribute(accessGrant.getGuid(), 2, "authorization_details_", accessGrant.getAuthorizationDetails().toJson(), false);
                attributes.add(attribute);
            }
            this.saveGrantAttributes(attrsToLdap, attributes);
            LdapName ldapName = new LdapName(s.toString() + "," + this.searchBase);
            LDAPUtil.newInstance(this.getLdapDataSource(), (ServiceInformation)this).addAccessGrant(ldapName, attrsToLdap);
        }
        catch (JsonProcessingException | NamingException e) {
            this.log.error((Object)("Unable to save grant due to : " + e.getMessage()));
            this.setAuditLogParams();
            throw new AccessGrantManagementException(e);
        }
        this.checkPersistentGrantLimit(accessGrant, this.maxGrantAllowed, this.maxGrantsToDelete);
    }

    @Override
    public void updateRefreshToken(AccessGrant accessGrant) {
        this.checkConfiguration();
        try {
            StringBuffer s = new StringBuffer();
            s.append(this.FIELDNAME_GUID).append("=").append(accessGrant.getGuid());
            LdapName ldapName = new LdapName(s.toString() + "," + this.searchBase);
            BasicAttributes attributes = new BasicAttributes();
            attributes.put(this.FIELDNAME_HASHED_REFRESH_TOKEN, accessGrant.getHashedRefreshTokenValue());
            attributes.put(this.FIELDNAME_UPDATED, Long.toString(System.currentTimeMillis()));
            if (accessGrant.getExpires() != null) {
                attributes.put(this.FIELDNAME_EXPIRES, Long.toString(accessGrant.getExpires()));
            }
            LDAPUtil.newInstance(this.getLdapDataSource(), (ServiceInformation)this).modifyItem(ldapName, attributes, 2);
            this.log.debug((Object)"The LDAP datastore was modified successfully.");
        }
        catch (NamingException e) {
            this.log.error((Object)("Unable to update grant due to : " + e.getMessage()));
            this.setAuditLogParams();
            throw new AccessGrantManagementException((Throwable)e);
        }
    }

    @Override
    public void updateExpiry(AccessGrant accessGrant) throws AccessGrantManagementException {
        this.checkConfiguration();
        try {
            StringBuffer s = new StringBuffer();
            s.append(this.FIELDNAME_GUID).append("=").append(accessGrant.getGuid());
            LdapName ldapName = new LdapName(s.toString() + "," + this.searchBase);
            BasicAttributes attributes = new BasicAttributes();
            if (accessGrant.getExpires() != null) {
                attributes.put(this.FIELDNAME_EXPIRES, accessGrant.getExpires().toString());
            } else {
                attributes.put(new BasicAttribute(this.FIELDNAME_EXPIRES));
            }
            attributes.put(this.FIELDNAME_UPDATED, Long.toString(System.currentTimeMillis()));
            LDAPUtil.newInstance(this.getLdapDataSource(), (ServiceInformation)this).modifyItem(ldapName, attributes, 2);
            this.log.debug((Object)"The LDAP datastore was modified successfully.");
        }
        catch (NamingException e) {
            this.log.error((Object)("Unable to update grant due to : " + e.getMessage()));
            this.setAuditLogParams();
            throw new AccessGrantManagementException((Throwable)e);
        }
    }

    @Override
    protected void updateGrantAttributes(String accessGrantGuid, Collection<AccessGrantAttribute> attributes) {
        this.checkConfiguration();
        try {
            Collection<AccessGrantAttribute> authorizationDetailsAttribute = this.retrieveAttributesBySourceType(accessGrantGuid, Collections.singletonList(2));
            if (authorizationDetailsAttribute != null) {
                attributes.addAll(authorizationDetailsAttribute);
            }
            StringBuffer s = new StringBuffer();
            s.append(this.FIELDNAME_GUID).append("=").append(accessGrantGuid);
            LdapName ldapName = new LdapName(s.toString() + "," + this.searchBase);
            BasicAttributes attributesToLdap = new BasicAttributes();
            ObjectMapper mapper = new ObjectMapper();
            String jsonInString = mapper.writeValueAsString(attributes);
            attributesToLdap.put(this.FIELDNAME_ATTRIBUTES, Obfuscator.obfuscate(jsonInString));
            LDAPUtil.newInstance(this.getLdapDataSource(), (ServiceInformation)this).modifyItem(ldapName, attributesToLdap, 2);
            this.log.debug((Object)"The LDAP datastore was modified successfully.");
        }
        catch (JsonProcessingException | NamingException e) {
            this.log.error((Object)("Unable to update grant attributes due to : " + e.getMessage()));
            this.setAuditLogParams();
            throw new AccessGrantManagementException(e);
        }
    }
}

