/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.token;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.pingidentity.common.util.ServiceInformation;
import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.sdk.accessgrant.AccessGrant;
import com.pingidentity.sdk.accessgrant.AccessGrantAttributesHolder;
import com.pingidentity.sdk.accessgrant.AccessGrantManager;
import com.pingidentity.sdk.accessgrant.exception.AccessGrantManagementException;
import com.pingidentity.sdk.oauth20.Scope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.ThreadContext;
import org.sourceid.oauth20.handlers.ContextUtil;
import org.sourceid.oauth20.handlers.OAuthSourceId;
import org.sourceid.oauth20.token.AccessGrantAttribute;
import org.sourceid.oauth20.token.TokenUtil;
import org.sourceid.oauth20.token.refresh.RefreshToken;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.AdapterAuthnSourceKey;
import org.sourceid.util.json.JsonUtils;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.profiles.idp.AsAuditLogger;

public abstract class BaseAccessGrantManager
implements AccessGrantManager,
ServiceInformation,
AutoReloadable {
    private static final Log log = LogFactory.getLog(BaseAccessGrantManager.class);
    protected static final int SOURCE_TYPE_PERSISTENT_GRANT = 0;
    protected static final int SOURCE_TYPE_AUTHN_CONTEXT = 1;
    protected static final int SOURCE_TYPE_AUTHORIZATION_DETAILS = 2;
    protected static final String AUTHORIZATION_DETAIL_KEY = "authorization_details_";
    protected static final String MAX_PERSISTENT_GRANT_CONFIG_FIELD_NAME = "maxPersistentGrants";
    protected static final String MAX_PERSISTENT_GRANT_TO_REMOVE_BATCH_SIZE_CONFIG_FIELD_NAME = "maxPersistentGrantsToRemoveBatchSize";
    protected static final int MAX_PERSISTENT_GRANT_DEFAULT = -1;
    protected static final int MAX_PERSISTENT_GRANT_TO_REMOVE_DEFAULT = -1;

    public String getServiceName() {
        return "access-grant-manager";
    }

    public abstract AccessGrant doGetByRefreshToken(String var1);

    public final AccessGrant getByRefreshToken(String refreshTokenValue) {
        if (refreshTokenValue == null) {
            return null;
        }
        RefreshToken refreshToken = TokenUtil.getRefreshToken(refreshTokenValue);
        return refreshToken.findAccessGrant(this);
    }

    public AccessGrant getByGuid(String accessGrantGuid) {
        if (accessGrantGuid == null) {
            return null;
        }
        return this.getByGuidInternal(accessGrantGuid);
    }

    protected abstract AccessGrant getByGuidInternal(String var1);

    public abstract void deleteGrant(String var1);

    protected abstract void saveGrant(AccessGrant var1, Collection<AccessGrantAttribute> var2);

    public abstract Collection<AccessGrant> getByUserKey(String var1);

    public abstract void updateRefreshToken(AccessGrant var1);

    public abstract void updateExpiry(AccessGrant var1) throws AccessGrantManagementException;

    protected abstract Collection<AccessGrantAttribute> retrieveGrantAttributes(String var1);

    protected abstract void updateGrantAttributes(String var1, Collection<AccessGrantAttribute> var2);

    public void saveGrant(AccessGrant accessGrant, AccessGrantAttributesHolder attrHolder) {
        ArrayList<AccessGrantAttribute> attributes = new ArrayList<AccessGrantAttribute>();
        if (attrHolder != null) {
            this.addMapToAttributes(attributes, accessGrant.getGuid(), attrHolder.getExtendedGrantAttrs(), 0);
            this.addMapToAttributes(attributes, accessGrant.getGuid(), attrHolder.getAuthnContextAttrs(), 1);
        }
        this.saveGrant(accessGrant, attributes);
    }

    public void updateGrantAttributes(String accessGrantGuid, AccessGrantAttributesHolder attrHolder) {
        ArrayList<AccessGrantAttribute> attributes = new ArrayList<AccessGrantAttribute>();
        if (attrHolder != null) {
            this.addMapToAttributes(attributes, accessGrantGuid, attrHolder.getExtendedGrantAttrs(), 0);
            this.addMapToAttributes(attributes, accessGrantGuid, attrHolder.getAuthnContextAttrs(), 1);
        }
        this.updateGrantAttributes(accessGrantGuid, attributes);
    }

    private void addMapToAttributes(Collection<AccessGrantAttribute> attributes, String grantGuid, AttributeMap attrMap, int sourceType) {
        if (attrMap != null) {
            for (Map.Entry entry : attrMap.entrySet()) {
                AttributeValue attributeValue = (AttributeValue)entry.getValue();
                Iterable objectValues = attributeValue.getAllObjectValues();
                for (Object o : objectValues) {
                    if (o instanceof String) {
                        AccessGrantAttribute attr = new AccessGrantAttribute(grantGuid, sourceType, (String)entry.getKey(), (String)o, ((AttributeValue)entry.getValue()).isMasked(), false, attributeValue.isMultiValue());
                        attributes.add(attr);
                        continue;
                    }
                    try {
                        String serialized = JsonUtils.getInstance().writeValueAsString(o);
                        AccessGrantAttribute attr = new AccessGrantAttribute(grantGuid, sourceType, (String)entry.getKey(), serialized, ((AttributeValue)entry.getValue()).isMasked(), true, attributeValue.isMultiValue());
                        attributes.add(attr);
                    }
                    catch (JsonProcessingException e) {
                        log.error((Object)"Error serializing grant attributes.", (Throwable)e);
                    }
                }
            }
        }
    }

    public AccessGrantAttributesHolder getGrantAttributes(String accessGrantGuid) {
        Collection<AccessGrantAttribute> attrs = this.retrieveGrantAttributes(accessGrantGuid);
        AttributeMap extendedGrantAttrs = this.makeAttributeMap(attrs, 0);
        AttributeMap authnContextAttrs = this.makeAttributeMap(attrs, 1);
        return new AccessGrantAttributesHolder(extendedGrantAttrs, authnContextAttrs);
    }

    private AttributeMap makeAttributeMap(Collection<AccessGrantAttribute> attributes, int sourceType) {
        HashMap<String, ArrayList<String>> jsonAttributes = new HashMap<String, ArrayList<String>>();
        HashMap<String, ArrayList<String>> stringAttributes = new HashMap<String, ArrayList<String>>();
        HashSet<String> maskedAttributes = new HashSet<String>();
        for (AccessGrantAttribute attribute : attributes) {
            Collection<String> values;
            if (attribute.getSourceType() != sourceType) continue;
            if (attribute.isMasked()) {
                maskedAttributes.add(attribute.getName());
            }
            if (attribute.isJsonAttribute()) {
                values = (ArrayList<String>)jsonAttributes.get(attribute.getName());
                if (values == null) {
                    values = new ArrayList<String>();
                    jsonAttributes.put(attribute.getName(), (ArrayList<String>)values);
                }
                values.add(attribute.getValue());
                continue;
            }
            values = (Collection)stringAttributes.get(attribute.getName());
            if (values == null) {
                values = new ArrayList();
                stringAttributes.put(attribute.getName(), (ArrayList<String>)values);
            }
            values.add(attribute.getValue());
        }
        AttributeMap result = new AttributeMap();
        for (Map.Entry entry : jsonAttributes.entrySet()) {
            ArrayList<String> objects = new ArrayList<String>();
            for (String value : (Collection)entry.getValue()) {
                Object o;
                try {
                    JsonNode jsonNode = JsonUtils.getInstance().readTree(value);
                    o = jsonNode instanceof TextNode ? jsonNode.textValue() : (jsonNode instanceof NumericNode ? jsonNode.numberValue() : (jsonNode instanceof BooleanNode ? Boolean.valueOf(jsonNode.booleanValue()) : (jsonNode instanceof ObjectNode ? JsonUtils.getInstance().toMap(jsonNode) : (jsonNode instanceof ArrayNode ? JsonUtils.getInstance().toList(jsonNode) : value))));
                }
                catch (JsonProcessingException e) {
                    log.debug((Object)"Error parsing Access Grant Attribute", (Throwable)e);
                    o = value;
                }
                objects.add((String)o);
            }
            AttributeValue attrValue = new AttributeValue((Collection)entry.getValue(), objects);
            attrValue.setMasked(maskedAttributes.contains(entry.getKey()));
            result.put((String)entry.getKey(), attrValue);
        }
        for (Map.Entry entry : stringAttributes.entrySet()) {
            AttributeValue attrValue = new AttributeValue((Collection)entry.getValue());
            attrValue.setMasked(maskedAttributes.contains(entry.getKey()));
            result.put((String)entry.getKey(), attrValue);
        }
        return result;
    }

    public void revokeGrant(String userKey, String accessGrantGuid) {
        AccessGrant accessGrant = MgmtFactory.getAccessGrantManager().getByGuid(accessGrantGuid);
        if (accessGrant != null) {
            AsAuditLogger.setUserName(userKey);
            ThreadContext.put((String)AuditLogger.MDC_KEY.IN_MESSAGE_TYPE.toString(), (String)"TokenRevoke");
            AsAuditLogger.setConnectionId(accessGrant.getClientId());
            AsAuditLogger.setGrantType(accessGrant.getGrantType());
            this.setAdapterId(accessGrant);
            if (!accessGrant.getUniqueUserIdentifer().equals(userKey)) {
                AsAuditLogger.setStatus("failure");
                AsAuditLogger.setDescription("User not grant owner");
                AsAuditLogger.log("User not grant owner");
                throw new AccessGrantManagementException("The user attempting to revoke the grant is not the grant owner");
            }
            this.revokeGrant(accessGrantGuid);
        } else {
            log.warn((Object)"Unable to revoke access grant.  Grant not found or expired.");
            AsAuditLogger.setStatus("failure");
            AsAuditLogger.setDescription("Grant not found or expired");
            AsAuditLogger.log("Grant not found or expired");
        }
    }

    public void revokeGrant(String accessGrantGuid) {
        this.deleteGrant(accessGrantGuid);
        BearerAccessTokenMgmtPluginManager bearerAccessTokenMgmtPluginMgr = MgmtFactory.getBearerAccessTokenMgmtPluginMgr();
        bearerAccessTokenMgmtPluginMgr.onAccessGrantRevoked(accessGrantGuid);
    }

    public AccessGrant getByUserKeyScopeClientIdGrantTypeContext(String userKey, Scope scope, String clientId, String grantType, String contextQualifier) {
        Collection<AccessGrant> grants = this.getByUserKey(userKey);
        for (AccessGrant ag : grants) {
            if (!StringUtils.equals((String)ag.getClientId(), (String)clientId) || !scope.isEqualOrLesserThan(ag.getScope()) || !StringUtils.equals((String)ag.getGrantType(), (String)grantType) || !StringUtils.equals((String)ag.getContextualQualifier(), (String)contextQualifier)) continue;
            return ag;
        }
        return null;
    }

    protected void updateContextualQualifier(AccessGrant ag) {
        IdpConnection idpConn;
        if (ag.getContextualQualifier() == null) {
            return;
        }
        ContextUtil ctxUtil = new ContextUtil();
        ContextUtil.Ctx ctx = ctxUtil.splitForAccessGrant(ag.getContextualQualifier());
        if (ctx != null && ctx.getQualifier().equals("authz_req") && ctx.getOAuthSourceId().getType() == OAuthSourceId.Type.LEGACY_IDP_CONNECTION && (idpConn = OAuthSourceId.getIdpConnFromLegacyId(ctx.getOAuthSourceId())) != null) {
            ag.setContextualQualifier(ctxUtil.buildQualifiedIdForAccessGrant(ctx.getQualifier(), new OAuthSourceId(OAuthSourceId.Type.IDP_CONNECTION, idpConn.getId())));
        }
    }

    private void setAdapterId(AccessGrant accessGrant) {
        String contextualQualifier = accessGrant.getContextualQualifier();
        if (StringUtils.isNotBlank((String)contextualQualifier) && contextualQualifier.contains("|")) {
            AsAuditLogger.setAuthnSourceId(new AdapterAuthnSourceKey(StringUtils.substringAfter((String)contextualQualifier, (String)"|")));
        }
    }
}

