/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.token;

import com.pingidentity.common.util.Base64URL;
import com.pingidentity.common.util.TimeUtil;
import com.pingidentity.sdk.accessgrant.AccessGrant;
import com.pingidentity.sdk.accessgrant.AccessGrantAttributesHolder;
import java.time.LocalDateTime;
import org.sourceid.common.HashAlgorithm;
import org.sourceid.common.HashUtil;
import org.sourceid.common.IDGenerator;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.RefreshTokenRollingIntervalHelper;
import org.sourceid.oauth20.protocol.InternalPersistentGrantAttributes;
import org.sourceid.oauth20.token.refresh.MultiPartRefreshToken;
import org.sourceid.oauth20.token.refresh.RefreshToken;
import org.sourceid.oauth20.token.refresh.SimpleRefreshToken;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public final class TokenUtil {
    private TokenUtil() {
    }

    public static String digestToken(String token) {
        return Base64URL.encodeToString((byte[])HashUtil.hashToBytes((String)token, (HashAlgorithm)HashAlgorithm.SHA256));
    }

    @Deprecated
    public static String newRefreshTokenValue() {
        AuthzServerManager authzServerManager = MgmtFactory.getAuthzServerManager();
        return IDGenerator.rndAlphaNumeric(authzServerManager.getRefreshTokenLength());
    }

    public static RefreshToken generateNewRefreshToken(AuthzServerManager authzServerManager, Client client) {
        int refreshTokenLength = authzServerManager.getRefreshTokenLength();
        if (TokenUtil.useMultipartRefreshToken(authzServerManager, client)) {
            return MultiPartRefreshToken.newInstance(refreshTokenLength);
        }
        return SimpleRefreshToken.newInstance(refreshTokenLength);
    }

    public static RefreshToken getRefreshToken(String refreshToken) {
        return RefreshToken.newInstance(refreshToken);
    }

    public static RefreshToken rollRefreshToken(AuthzServerManager authzServerManager, Client client, RefreshToken refreshToken) {
        int refreshTokenLength = authzServerManager.getRefreshTokenLength();
        if (TokenUtil.useMultipartRefreshToken(authzServerManager, client)) {
            if (refreshToken instanceof MultiPartRefreshToken) {
                return refreshToken.roll(authzServerManager);
            }
            return MultiPartRefreshToken.newInstance(refreshTokenLength);
        }
        return SimpleRefreshToken.newInstance(refreshTokenLength);
    }

    public static void storeOldRefreshTokenReference(AuthzServerManager authzServerManager, Client client, AccessGrant accessGrant, AccessGrantAttributesHolder accessGrantAttributes, RefreshToken refreshToken, RefreshToken oldRefreshToken) {
        int gracePeriodInMilliseconds = TokenUtil.getEffectiveGracePeriodInMilliseconds(authzServerManager, client);
        if (gracePeriodInMilliseconds > 0) {
            long expiresAt = System.currentTimeMillis() + (long)gracePeriodInMilliseconds;
            if (accessGrant.getExpires() != null && expiresAt > accessGrant.getExpires()) {
                expiresAt = accessGrant.getExpires();
            }
            refreshToken.storeOldRefreshToken(accessGrantAttributes, oldRefreshToken, expiresAt);
        }
    }

    private static int getEffectiveGracePeriodInMilliseconds(AuthzServerManager authzServerManager, Client client) {
        if ("OVERRIDE_SERVER_DEFAULT".equals(client.getRefreshTokenRollingGracePeriodType())) {
            Integer refreshTokenRollingGracePeriod = client.getRefreshTokenRollingGracePeriod();
            if (refreshTokenRollingGracePeriod != null) {
                return refreshTokenRollingGracePeriod * 1000;
            }
            return 0;
        }
        return authzServerManager.getRefreshTokenRollingGracePeriod() * 1000;
    }

    private static boolean isRefreshTokenRollingConfigured(AuthzServerManager authzServerManager, Client client) {
        if ("true".equals(client.getRefreshRolling())) {
            return true;
        }
        return !"false".equals(client.getRefreshRolling()) && authzServerManager.defaultRefreshTokenRollingPolicy();
    }

    public static Long getRefreshTokenLastRolledAt(AccessGrantAttributesHolder holder) {
        AttributeValue value = (AttributeValue)holder.getExtendedGrantAttrs().get((Object)InternalPersistentGrantAttributes.REFRESH_TOKEN_LAST_ROLLED_AT.getKey());
        if (value == null) {
            return null;
        }
        return Long.parseLong(value.getValue());
    }

    public static boolean applyLastRolledAt(AccessGrantAttributesHolder holder, AuthzServerManager authzServerManager, Client client) {
        if (!TokenUtil.isRefreshTokenRollingConfigured(authzServerManager, client)) {
            return TokenUtil.removeRefreshRolledAtIfNeeded(holder);
        }
        long refreshTokenRollAfterValue = TokenUtil.getRefreshTokenRollAfterValue(authzServerManager, client);
        if (refreshTokenRollAfterValue == 0L) {
            return TokenUtil.removeRefreshRolledAtIfNeeded(holder);
        }
        String currentTimestamp = String.valueOf(TimeUtil.getCurrentEpochSecond());
        holder.getExtendedGrantAttrs().put(InternalPersistentGrantAttributes.REFRESH_TOKEN_LAST_ROLLED_AT.getKey(), currentTimestamp);
        return true;
    }

    private static boolean removeRefreshRolledAtIfNeeded(AccessGrantAttributesHolder holder) {
        if (holder.getExtendedGrantAttrs().get((Object)InternalPersistentGrantAttributes.REFRESH_TOKEN_LAST_ROLLED_AT.getKey()) != null) {
            holder.getExtendedGrantAttrs().remove((Object)InternalPersistentGrantAttributes.REFRESH_TOKEN_LAST_ROLLED_AT.getKey());
            return true;
        }
        return false;
    }

    public static boolean refreshTokenMustRoll(long lastRolledAt, long rollingInterval, String rollingIntervalTimeUnit) {
        if (rollingInterval == 0L) {
            return false;
        }
        long rollingIntervalInSeconds = RefreshTokenRollingIntervalHelper.convertIntervalToSeconds(rollingInterval, rollingIntervalTimeUnit);
        LocalDateTime lastRolledAtLocalDateTime = TimeUtil.epochSecondToLocalDateTime(lastRolledAt);
        LocalDateTime currentUtcLocalDateTime = TimeUtil.getCurrentUtcLocalDateTime();
        return lastRolledAtLocalDateTime.plusSeconds(rollingIntervalInSeconds).isBefore(currentUtcLocalDateTime);
    }

    private static long getRefreshTokenRollAfterValue(AuthzServerManager authzServerManager, Client client) {
        Long refreshTokenRollingIntervalInHours = client.getRefreshTokenRollingInterval();
        if (refreshTokenRollingIntervalInHours == null) {
            refreshTokenRollingIntervalInHours = authzServerManager.getRefreshRollingInterval();
        }
        return refreshTokenRollingIntervalInHours;
    }

    private static boolean useMultipartRefreshToken(AuthzServerManager authzServerManager, Client client) {
        if (!TokenUtil.isRefreshTokenRollingConfigured(authzServerManager, client)) {
            return false;
        }
        boolean revokeReplayedRefreshToken = authzServerManager.isRevokeReplayedRefreshToken();
        boolean hasGracePeriod = TokenUtil.getEffectiveGracePeriodInMilliseconds(authzServerManager, client) > 0;
        return revokeReplayedRefreshToken || hasGracePeriod;
    }
}

