/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.token.plugin.impl;

import com.pingidentity.access.AccessGrantManagerAccessor;
import com.pingidentity.sdk.ConfigurablePlugin;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.PluginFipsStatus;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetails;
import com.pingidentity.sdk.oauth20.AccessToken;
import com.pingidentity.sdk.oauth20.AccessTokenRevocable;
import com.pingidentity.sdk.oauth20.BearerAccessTokenManagementPlugin;
import com.pingidentity.sdk.oauth20.IssuedAccessToken;
import com.pingidentity.sdk.oauth20.Scope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.IDGenerator;
import org.sourceid.common.SpaceDelimitedStringUtil;
import org.sourceid.oauth20.token.TokenUtil;
import org.sourceid.oauth20.token.plugin.impl.AccessTokenWrapper;
import org.sourceid.oauth20.token.plugin.impl.ReferenceBearerAccessTokenTracker;
import org.sourceid.oauth20.token.plugin.impl.ReferenceBearerAccessTokenTrackerMemoryImpl;
import org.sourceid.oauth20.token.plugin.impl.ReferenceBearerAccessTokenTrackerRpcImpl;
import org.sourceid.oauth20.token.plugin.impl.ReferenceBearerAccessTokenTrackerWrapper;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.FieldList;
import org.sourceid.saml20.adapter.gui.AbstractSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.SelectFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;
import org.sourceid.saml20.adapter.gui.validation.impl.IntegerValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;
import org.sourceid.saml20.service.impl.grouprpc.RpcResponseMode;
import org.sourceid.saml20.service.impl.proxy.ImplSelector;

public class ReferenceBearerAccessTokenManagementPlugin
implements BearerAccessTokenManagementPlugin,
AccessTokenRevocable {
    public static final String SCOPE_ATTRIBUTE_NAME = "scope";
    private static Log log = LogFactory.getLog(ReferenceBearerAccessTokenManagementPlugin.class);
    private static ReferenceBearerAccessTokenTrackerMemoryImpl globalInMemoryTracker;
    private ReferenceBearerAccessTokenTrackerWrapper trackerWrapper;
    private static int GET_ALL;
    private static int GET_MAJORITY;
    private String instanceId;
    private int tokenLength;
    private long tokenLife;
    private LifetimeExtensionPlicy lifetimeExtensionPolicy;
    private static final String LIFETIME_EXTENSION_POLICY_FIELD_NAME = "Lifetime Extension Policy";
    private static final String MAX_TOKEN_LIFETIME_FIELD_NAME = "Maximum Token Lifetime";
    private static final String LIFETIME_EXTENSION_THRESHOLD_PERCENTAGE_FIELD_NAME = "Lifetime Extension Threshold Percentage";
    private static final String MODE_FOR_SYNCHRONOUS_RPC_FIELD_NAME = "Mode for Synchronous RPC";
    private static final String RPC_TIMEOUT_FIELD_NAME = "RPC Timeout";
    private static final String EXPAND_SCOPE_GROUPS_FIELD_NAME = "Expand Scope Groups";
    private long lifetimeExtensionThreshold;
    private Long absoluteMaximumTokenLife;
    private boolean expandScopeGroups;
    private static final String TOKEN_LENGTH_FIELD_NAME = "Token Length";
    public static final String TOKEN_LIFETIME_FIELD_NAME = "Token Lifetime";
    private PluginDescriptor pluginDescriptor;

    public ReferenceBearerAccessTokenManagementPlugin() {
        GuiConfigDescriptor gui = new GuiConfigDescriptor();
        TextFieldDescriptor tokenLenDesc = new TextFieldDescriptor(TOKEN_LENGTH_FIELD_NAME, "Defines how many alphanumeric characters make up an access token. Note that the first 4 characters are reserved and don't count towards the randomness of the token.");
        tokenLenDesc.addValidator((FieldValidator)new RequiredFieldValidator());
        tokenLenDesc.addValidator((FieldValidator)new IntegerValidator(22, 256), true);
        tokenLenDesc.setDefaultValue("28");
        gui.addField((FieldDescriptor)tokenLenDesc);
        TextFieldDescriptor tokenLifeDesc = new TextFieldDescriptor(TOKEN_LIFETIME_FIELD_NAME, "Defines how long, in minutes, an access token is valid. ");
        tokenLifeDesc.addValidator((FieldValidator)new RequiredFieldValidator());
        tokenLifeDesc.addValidator((FieldValidator)new IntegerValidator(1, Integer.MAX_VALUE), true);
        tokenLifeDesc.setDefaultValue("120");
        gui.addField((FieldDescriptor)tokenLifeDesc);
        ArrayList<AbstractSelectionFieldDescriptor.OptionValue> list = new ArrayList<AbstractSelectionFieldDescriptor.OptionValue>();
        list.add(new AbstractSelectionFieldDescriptor.OptionValue("No Extension", LifetimeExtensionPlicy.NONE.toString()));
        list.add(new AbstractSelectionFieldDescriptor.OptionValue("Tokens Not Backed by Persistent Access Grants (Transient Grants)", LifetimeExtensionPlicy.TRANSIENT.toString()));
        list.add(new AbstractSelectionFieldDescriptor.OptionValue("All Tokens", LifetimeExtensionPlicy.ALL.toString()));
        Object desc = "Dictates which tokens are eligible for lifetime extension. Similar to a session inactivity timeout, the lifetime period of an access token can be reset each time the token is validated at the AS (subject to the values defined for the Lifetime Extension Threshold Percentage and the Maximum Token Lifetime). ";
        SelectFieldDescriptor lifetimeExtPolicyFieldDesc = new SelectFieldDescriptor(LIFETIME_EXTENSION_POLICY_FIELD_NAME, (String)desc, list);
        lifetimeExtPolicyFieldDesc.setDefaultValue(LifetimeExtensionPlicy.NONE.toString());
        gui.addField((FieldDescriptor)lifetimeExtPolicyFieldDesc);
        desc = "(Optional) Defines an absolute maximum token lifetime, in minutes, for use with the Lifetime Extension Policy. ";
        desc = (String)desc + "An access token's lifetime cannot be extended beyond this setting.";
        TextFieldDescriptor maxTokenLifeDesc = new TextFieldDescriptor(MAX_TOKEN_LIFETIME_FIELD_NAME, (String)desc);
        maxTokenLifeDesc.addValidator((FieldValidator)new IntegerValidator(1, Integer.MAX_VALUE), true);
        gui.addField((FieldDescriptor)maxTokenLifeDesc);
        desc = "Defines the percentage of a token's lifetime remaining before the lifetime is actually extended, which can improve cluster performance.";
        TextFieldDescriptor lifetimeExtensionThresholdPctFieldDesc = new TextFieldDescriptor(LIFETIME_EXTENSION_THRESHOLD_PERCENTAGE_FIELD_NAME, (String)desc);
        lifetimeExtensionThresholdPctFieldDesc.addValidator((FieldValidator)new RequiredFieldValidator());
        lifetimeExtensionThresholdPctFieldDesc.addValidator((FieldValidator)new IntegerValidator(1, 100), true);
        lifetimeExtensionThresholdPctFieldDesc.setDefaultValue("30");
        gui.addField((FieldDescriptor)lifetimeExtensionThresholdPctFieldDesc);
        list = new ArrayList();
        String majorityName = "Majority of Nodes";
        list.add(new AbstractSelectionFieldDescriptor.OptionValue(majorityName, String.valueOf(GET_MAJORITY)));
        String allName = "All Nodes";
        list.add(new AbstractSelectionFieldDescriptor.OptionValue(allName, String.valueOf(GET_ALL)));
        desc = "For clustered deployments, indicates how many responses to wait for when making synchronous RPC calls. When '" + majorityName + "' is selected, the server waits for the majority of recipients to respond. When '" + allName + "' is selected, it waits for all recipients to respond.";
        SelectFieldDescriptor rpcModeFieldDesc = new SelectFieldDescriptor(MODE_FOR_SYNCHRONOUS_RPC_FIELD_NAME, (String)desc, list);
        rpcModeFieldDesc.setDefaultValue(String.valueOf(GET_MAJORITY));
        gui.addAdvancedField((FieldDescriptor)rpcModeFieldDesc);
        desc = "For clustered deployments, indicates how long, in milliseconds, the server waits before timing out unresponsive RPC invocations.";
        TextFieldDescriptor rpcTimoutFieldDesc = new TextFieldDescriptor(RPC_TIMEOUT_FIELD_NAME, (String)desc);
        rpcTimoutFieldDesc.setDefaultValue("500");
        rpcTimoutFieldDesc.addValidator((FieldValidator)new RequiredFieldValidator());
        rpcTimoutFieldDesc.addValidator((FieldValidator)new IntegerValidator(0, 60000), true);
        gui.addAdvancedField((FieldDescriptor)rpcTimoutFieldDesc);
        desc = "Expand scope groups into their corresponding scopes in the Access Token contents and introspection response. By default this is disabled.";
        CheckBoxFieldDescriptor expandScopeGroups = new CheckBoxFieldDescriptor(EXPAND_SCOPE_GROUPS_FIELD_NAME, (String)desc);
        expandScopeGroups.setDefaultValue(false);
        expandScopeGroups.setDefaultForLegacyConfig(Boolean.toString(false));
        gui.addAdvancedField((FieldDescriptor)expandScopeGroups);
        gui.addValidator(new ConfigurationValidator(){

            public void validate(Configuration config) throws ValidationException {
                int maxTokenLife = config.getIntFieldValue(ReferenceBearerAccessTokenManagementPlugin.MAX_TOKEN_LIFETIME_FIELD_NAME);
                int tokenLife = config.getIntFieldValue(ReferenceBearerAccessTokenManagementPlugin.TOKEN_LIFETIME_FIELD_NAME);
                if (maxTokenLife > 0 && maxTokenLife < tokenLife) {
                    throw new ValidationException("The Maximum Token Lifetime value cannot be less than the Token Lifetime value.");
                }
            }
        });
        this.pluginDescriptor = new PluginDescriptor("Internally Managed Reference Tokens", (ConfigurablePlugin)this, gui);
        this.pluginDescriptor.setMetadata(Collections.singletonMap("FipsStatus", PluginFipsStatus.COMPLIANT));
    }

    public AccessToken validateAccessToken(String accessTokenValue) {
        AccessToken accessToken = null;
        String hashedTokenValue = TokenUtil.digestToken(accessTokenValue);
        AccessTokenWrapper accessTokenWrapper = this.trackerWrapper.get(hashedTokenValue);
        if (accessTokenWrapper != null) {
            accessToken = accessTokenWrapper.getAccessToken();
            String accessGrantGuid = accessToken.getAccessGrantGuid();
            if (StringUtils.isNotBlank((String)accessGrantGuid) && AccessGrantManagerAccessor.getAccessGrantManager().getByGuid(accessGrantGuid) == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Access token is not valid: Revoked, expired or otherwise invalid/unknown access grant guid: %s", accessGrantGuid));
                }
                return null;
            }
            if (this.isExpirationExtendable(accessToken) && !accessToken.isExpired()) {
                long expiresAt = accessToken.getExpiresAt();
                long updateAt = expiresAt - this.lifetimeExtensionThreshold;
                if (System.currentTimeMillis() > updateAt) {
                    long updatedExpiresAt = this.computeExpiresAtTime();
                    if (this.absoluteMaximumTokenLife != null) {
                        long issuedAt = accessTokenWrapper.getIssuedAt();
                        long max = issuedAt + this.absoluteMaximumTokenLife;
                        long l = updatedExpiresAt = updatedExpiresAt > max ? max : updatedExpiresAt;
                    }
                    if (updatedExpiresAt > expiresAt) {
                        this.trackerWrapper.updateExpiration(hashedTokenValue, updatedExpiresAt);
                        accessToken.setExpiresAt(updatedExpiresAt);
                    }
                }
            }
        }
        return accessToken;
    }

    public IssuedAccessToken issueAccessToken(Map<String, AttributeValue> attributes, Scope scope, String clientId, String accessGrantGuid, int tokenManagerSequenceNumber, AuthorizationDetails authorizationDetails) {
        String accessTokenString = this.buildAtmAwareTokenString(tokenManagerSequenceNumber);
        long expiresAt = this.computeExpiresAtTime();
        String scopeString = this.getScopeString(this.expandScopeGroups, scope, attributes);
        AccessToken token = new AccessToken(expiresAt, attributes, scopeString, clientId, accessGrantGuid, authorizationDetails);
        this.trackerWrapper.store(TokenUtil.digestToken(accessTokenString), new AccessTokenWrapper(System.currentTimeMillis(), token));
        return new IssuedAccessToken(accessTokenString, "Bearer", this.isExpirationExtendable(token) ? null : Long.valueOf(expiresAt));
    }

    public boolean issuedToken(String accessTokenValue, int tokenManagerSequenceNumber) {
        int parsedInteger;
        try {
            parsedInteger = Integer.parseInt(accessTokenValue.substring(0, 4), 36);
        }
        catch (IndexOutOfBoundsException | NumberFormatException ex) {
            return true;
        }
        return tokenManagerSequenceNumber == parsedInteger;
    }

    private String buildAtmAwareTokenString(int tokenManagerSequenceNumber) {
        String base36String = Integer.toString(tokenManagerSequenceNumber, 36);
        String encodedAtmSequence = StringUtils.leftPad((String)base36String, (int)4, (char)'0');
        String baseTokenString = IDGenerator.rndAlphaNumeric(this.tokenLength - 4);
        return encodedAtmSequence + baseTokenString;
    }

    public void revokeAllAccessTokens(String accessGrantGuid) {
        this.trackerWrapper.revokeAllAccessTokens(accessGrantGuid);
    }

    public void revokeAllAccessTokensByClient(String clientId) {
        this.trackerWrapper.revokeAllAccessTokensByClient(clientId);
    }

    public boolean revokeAccessToken(String accessTokenString) {
        String hashedTokenValue = TokenUtil.digestToken(accessTokenString);
        return this.trackerWrapper.revokeAccessToken(hashedTokenValue);
    }

    private long computeExpiresAtTime() {
        return System.currentTimeMillis() + this.tokenLife;
    }

    private boolean isExpirationExtendable(AccessToken accessToken) {
        boolean isExtendable = false;
        switch (this.lifetimeExtensionPolicy) {
            case ALL: {
                isExtendable = true;
                break;
            }
            case TRANSIENT: {
                isExtendable = !accessToken.hasAccessGrantGuid();
            }
        }
        return isExtendable;
    }

    public void configure(Configuration configuration) {
        this.instanceId = configuration.getId();
        this.trackerWrapper = ReferenceBearerAccessTokenManagementPlugin.createTrackerWrapper(this.instanceId);
        this.tokenLength = configuration.getIntFieldValue(TOKEN_LENGTH_FIELD_NAME);
        this.tokenLife = 60000L * (long)configuration.getIntFieldValue(TOKEN_LIFETIME_FIELD_NAME);
        String lifePolicyStr = configuration.getFieldValue(LIFETIME_EXTENSION_POLICY_FIELD_NAME);
        this.lifetimeExtensionPolicy = LifetimeExtensionPlicy.valueOf(lifePolicyStr);
        float lifetimeExtensionThresholdPct = configuration.getFloatFieldValue(LIFETIME_EXTENSION_THRESHOLD_PERCENTAGE_FIELD_NAME);
        this.lifetimeExtensionThreshold = (long)(lifetimeExtensionThresholdPct / 100.0f * (float)this.tokenLife);
        long maxLife = configuration.getIntFieldValue(MAX_TOKEN_LIFETIME_FIELD_NAME);
        if (maxLife > 0L) {
            this.absoluteMaximumTokenLife = maxLife * 1000L * 60L;
        }
        FieldList advancedFields = configuration.getAdvancedFields();
        int value = advancedFields.getIntFieldValue(MODE_FOR_SYNCHRONOUS_RPC_FIELD_NAME);
        this.trackerWrapper.setRpcResponseMode(this.getRpcResponseModeFromIntValue(value));
        this.trackerWrapper.setRpcTimeout(advancedFields.getIntFieldValue(RPC_TIMEOUT_FIELD_NAME));
        this.expandScopeGroups = configuration.getBooleanFieldValue(EXPAND_SCOPE_GROUPS_FIELD_NAME);
    }

    public PluginDescriptor getPluginDescriptor() {
        return this.pluginDescriptor;
    }

    private static synchronized ReferenceBearerAccessTokenTrackerWrapper createTrackerWrapper(String tokenManagerId) {
        ReferenceBearerAccessTokenTracker tracker = globalInMemoryTracker;
        if (tracker == null) {
            Class<ReferenceBearerAccessTokenTrackerRpcImpl> distributable = ReferenceBearerAccessTokenTrackerRpcImpl.class;
            Class<ReferenceBearerAccessTokenTrackerMemoryImpl> local = ReferenceBearerAccessTokenTrackerMemoryImpl.class;
            try {
                tracker = (ReferenceBearerAccessTokenTracker)ImplSelector.create(distributable, local);
            }
            catch (Exception e) {
                tracker = new ReferenceBearerAccessTokenTrackerMemoryImpl();
                log.error((Object)("Unable to create proper implementation of " + ReferenceBearerAccessTokenTracker.class + " so using " + tracker.getClass()), (Throwable)e);
            }
            if (tracker instanceof ReferenceBearerAccessTokenTrackerMemoryImpl) {
                globalInMemoryTracker = (ReferenceBearerAccessTokenTrackerMemoryImpl)tracker;
            }
        }
        return new ReferenceBearerAccessTokenTrackerWrapper(tokenManagerId, tracker);
    }

    private RpcResponseMode getRpcResponseModeFromIntValue(int value) {
        if (value == GET_ALL) {
            return RpcResponseMode.GET_ALL;
        }
        if (value == GET_MAJORITY) {
            return RpcResponseMode.GET_MAJORITY;
        }
        throw new IllegalArgumentException("Illegal response mode: " + value);
    }

    public AccessToken getAccessToken(String accessTokenString) {
        String hashedTokenValue = TokenUtil.digestToken(accessTokenString);
        AccessTokenWrapper wrapper = this.trackerWrapper.get(hashedTokenValue);
        if (wrapper != null) {
            return wrapper.getAccessToken();
        }
        return null;
    }

    public Map<String, Integer> getSize() {
        ReferenceBearerAccessTokenTracker tracker = this.trackerWrapper.getTracker();
        return tracker.getHashValueToTokenMapSizes();
    }

    private String getScopeString(boolean expandScopeGroups, Scope scope, Map<String, AttributeValue> attributes) {
        if (attributes.containsKey(SCOPE_ATTRIBUTE_NAME)) {
            AttributeValue attributeValue = attributes.get(SCOPE_ATTRIBUTE_NAME);
            if (attributeValue.isMultiValue()) {
                return SpaceDelimitedStringUtil.toString((Collection)attributeValue.getValuesAsCollection());
            }
            return attributeValue.getValue();
        }
        if (expandScopeGroups) {
            return scope.expanded().getScopeStr();
        }
        return scope.getScopeStr();
    }

    static {
        GET_ALL = 2;
        GET_MAJORITY = 3;
    }

    private static enum LifetimeExtensionPlicy {
        NONE,
        TRANSIENT,
        ALL;

    }
}

