/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.token.plugin.impl;

import com.pingidentity.common.util.DistributableCache;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.sdk.oauth20.AccessToken;
import java.io.Serializable;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.sourceid.oauth20.token.plugin.impl.AccessTokenWrapper;
import org.sourceid.oauth20.token.plugin.impl.ReferenceBearerAccessTokenTracker;
import org.sourceid.saml20.domain.mgmt.impl.ModeSupport;
import org.sourceid.saml20.service.StateService;
import org.sourceid.saml20.service.StateServiceId;
import org.sourceid.saml20.state.ConsistentHashTracker;
import org.sourceid.saml20.state.StateMgmtFactory;

public class ReferenceBearerAccessTokenTrackerMemoryImpl
implements ReferenceBearerAccessTokenTracker,
StateService<TokenEntry> {
    private final Map<String, TrackerState> stateMap = new HashMap<String, TrackerState>();
    private Clock clock = Clock.systemDefaultZone();

    public ReferenceBearerAccessTokenTrackerMemoryImpl() {
        StateMgmtFactory.getStateServiceRegistry().registerService(this);
    }

    @Override
    public synchronized AccessTokenWrapper get(String tokenManagerId, String hashedTokenValue) {
        TrackerState state = this.getTrackerState(tokenManagerId);
        if (state == null) {
            return null;
        }
        return (AccessTokenWrapper)state.getHashValueToTokenMap().get(hashedTokenValue);
    }

    @Override
    public synchronized void updateExpiration(String tokenManagerId, String hashedTokenValue, Long expiresAt) {
        TrackerState state = this.getTrackerState(tokenManagerId);
        if (state == null) {
            return;
        }
        AccessTokenWrapper accessTokenWrapper = (AccessTokenWrapper)state.getHashValueToTokenMap().remove(hashedTokenValue);
        if (accessTokenWrapper != null) {
            boolean inserted;
            AccessToken accessToken = accessTokenWrapper.getAccessToken();
            if (accessToken != null) {
                accessToken.setExpiresAt(expiresAt.longValue());
            }
            if (!(inserted = state.getHashValueToTokenMap().tryPutWithTimestamp(hashedTokenValue, accessTokenWrapper, expiresAt))) {
                this.removeTokenFromGrantGuidSet(hashedTokenValue, tokenManagerId, accessTokenWrapper);
            }
        }
    }

    @Override
    public synchronized void revokeAllAccessTokens(String tokenManagerId, String accessGrantGuid) {
        TrackerState state = this.getTrackerState(tokenManagerId);
        if (state == null) {
            return;
        }
        Set<String> hashedTokensSet = state.getAccessGrantGuidToHashedTokensMap().remove(accessGrantGuid);
        if (hashedTokensSet != null) {
            for (String hashedTokenValue : hashedTokensSet) {
                this.revokeAccessToken(tokenManagerId, hashedTokenValue);
            }
        }
    }

    @Override
    public synchronized void revokeAllAccessTokensByClient(String tokenManagerId, String clientId) {
        TrackerState state = this.getTrackerState(tokenManagerId);
        if (state == null || StringUtils.isBlank((String)clientId)) {
            return;
        }
        List hashedTokenValues = state.getHashValueToTokenMap().entrySet().stream().filter(entry -> ((AccessTokenWrapper)entry.getValue()).getAccessToken() != null && clientId.equals(((AccessTokenWrapper)entry.getValue()).getAccessToken().getClientId())).map(Map.Entry::getKey).collect(Collectors.toList());
        for (String hashedTokenValue : hashedTokenValues) {
            this.revokeAccessToken(tokenManagerId, hashedTokenValue);
        }
    }

    @Override
    public synchronized Boolean revokeAccessToken(String tokenManagerId, String hashedTokenValue) {
        TrackerState state = this.getTrackerState(tokenManagerId);
        if (state == null) {
            return Boolean.FALSE;
        }
        if (this.isAdaptiveClusteringMode()) {
            AccessTokenWrapper accessTokenWrapper = this.get(tokenManagerId, hashedTokenValue);
            if (accessTokenWrapper == null || accessTokenWrapper.isTombstone()) {
                return Boolean.FALSE;
            }
            boolean result = this.removeTokenFromGrantGuidSet(hashedTokenValue, tokenManagerId, accessTokenWrapper);
            if (result) {
                accessTokenWrapper.setTombstone();
                return true;
            }
            return false;
        }
        AccessTokenWrapper accessTokenWrapper = (AccessTokenWrapper)state.getHashValueToTokenMap().remove(hashedTokenValue);
        return this.removeTokenFromGrantGuidSet(hashedTokenValue, tokenManagerId, accessTokenWrapper);
    }

    private synchronized boolean removeTokenFromGrantGuidSet(String hashedTokenValue, String tokenManagerId, AccessTokenWrapper accessTokenWrapper) {
        TrackerState state = this.getTrackerState(tokenManagerId);
        if (state == null) {
            return false;
        }
        if (accessTokenWrapper != null) {
            if (accessTokenWrapper.getAccessToken() != null) {
                String accessGrantGuid = accessTokenWrapper.getAccessToken().getAccessGrantGuid();
                Set<String> hashedTokens = state.getAccessGrantGuidToHashedTokensMap().get(accessGrantGuid);
                if (hashedTokens != null) {
                    hashedTokens.remove(hashedTokenValue);
                    if (hashedTokens.isEmpty()) {
                        state.getAccessGrantGuidToHashedTokensMap().remove(accessGrantGuid);
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized void store(String tokenManagerId, String hashedTokenValue, AccessTokenWrapper tokenWrapper) {
        this.store(tokenManagerId, hashedTokenValue, tokenWrapper, tokenWrapper.getAccessToken().getExpiresAt());
    }

    synchronized void store(String tokenManagerId, String hashedTokenValue, AccessTokenWrapper tokenWrapper, long expiryTime) {
        AccessToken accessToken;
        boolean inserted;
        TrackerState state = this.getTrackerState(tokenManagerId);
        if (state == null) {
            state = new TrackerState(tokenManagerId);
            this.stateMap.put(tokenManagerId, state);
        }
        if ((inserted = state.getHashValueToTokenMap().tryPutWithTimestamp(hashedTokenValue, tokenWrapper, expiryTime)) && (accessToken = tokenWrapper.getAccessToken()) != null && accessToken.hasAccessGrantGuid()) {
            String guid = accessToken.getAccessGrantGuid();
            Set<String> hashedTokenValuesSet = state.getAccessGrantGuidToHashedTokensMap().get(guid);
            if (hashedTokenValuesSet == null) {
                hashedTokenValuesSet = new HashSet<String>();
                state.getAccessGrantGuidToHashedTokensMap().put(guid, hashedTokenValuesSet);
            }
            hashedTokenValuesSet.add(hashedTokenValue);
        }
    }

    synchronized int numberOfTokens(String tokenManagerId) {
        TrackerState state = this.getTrackerState(tokenManagerId);
        if (state == null) {
            return 0;
        }
        return state.getHashValueToTokenMap().size();
    }

    synchronized int numberOfAccessGuids(String tokenManagerId) {
        TrackerState state = this.getTrackerState(tokenManagerId);
        if (state == null) {
            return 0;
        }
        return state.getAccessGrantGuidToHashedTokensMap().size();
    }

    private synchronized TrackerState getTrackerState(String tokenManagerId) {
        return this.stateMap.get(tokenManagerId);
    }

    @Override
    public synchronized Map<String, Integer> getHashValueToTokenMapSizes() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (Map.Entry<String, TrackerState> entry : this.stateMap.entrySet()) {
            TrackerState state = entry.getValue();
            map.put(entry.getKey(), state.hashValueToTokenMap.size());
        }
        return map;
    }

    protected boolean isAdaptiveClusteringMode() {
        return ModeSupport.isDistributable() && PropertyInfo.isAdaptiveClusteringEnabled();
    }

    @Override
    public synchronized StateServiceId getServiceId() {
        return StateServiceId.OAUTH_REF_TOKEN_TRACKER;
    }

    @Override
    public synchronized void importRecords(Collection<TokenEntry> tokenEntries) {
        for (TokenEntry tokenEntry : tokenEntries) {
            TrackerState trackerState = this.stateMap.get(tokenEntry.getTokenManagerId());
            long insertTime = tokenEntry.getTimestamp();
            if (trackerState != null && trackerState.getHashValueToTokenMap().containsKey(tokenEntry.getHashTokenKey())) {
                insertTime = Math.max(insertTime, trackerState.getHashValueToTokenMap().getTimestampForKey(tokenEntry.getHashTokenKey()));
                if (tokenEntry.getAccessTokenWrapper().getAccessToken() != null) {
                    tokenEntry.getAccessTokenWrapper().getAccessToken().setExpiresAt(insertTime);
                }
            }
            this.store(tokenEntry.getTokenManagerId(), tokenEntry.getHashTokenKey(), tokenEntry.getAccessTokenWrapper(), insertTime);
        }
    }

    @Override
    public synchronized Collection<TokenEntry> getRecords(int startHash, int endHashExclusive) {
        ArrayList<TokenEntry> records = new ArrayList<TokenEntry>();
        for (Map.Entry<String, TrackerState> entry : this.stateMap.entrySet()) {
            TrackerState trackerState = entry.getValue();
            String tokenManagerId = entry.getKey();
            TokenMap tokenMap = trackerState.getHashValueToTokenMap();
            Collection<String> ids = tokenMap.getKeysForRange(startHash, endHashExclusive);
            for (String id : ids) {
                AccessTokenWrapper accessTokenWrapper = (AccessTokenWrapper)tokenMap.get(id);
                if (accessTokenWrapper == null) continue;
                TokenEntry record = new TokenEntry(tokenManagerId, id, accessTokenWrapper, tokenMap.getTimestampForKey(id));
                records.add(record);
            }
        }
        return records;
    }

    @Override
    public synchronized void purgeRecords(int startHash, int endHashExclusive) {
        for (Map.Entry<String, TrackerState> entry : this.stateMap.entrySet()) {
            TrackerState trackerState = entry.getValue();
            String tokenManagerId = entry.getKey();
            TokenMap tokenMap = trackerState.getHashValueToTokenMap();
            Collection<String> ids = tokenMap.getKeysForRange(startHash, endHashExclusive);
            for (String id : ids) {
                AccessTokenWrapper wrapper = (AccessTokenWrapper)tokenMap.remove(id);
                this.removeTokenFromGrantGuidSet(id, tokenManagerId, wrapper);
            }
        }
    }

    protected Clock getClock() {
        return this.clock;
    }

    protected ConsistentHashTracker makeConsistentHashTracker() {
        return StateMgmtFactory.makeConsistentHashTracker(true, true);
    }

    static class TokenEntry
    implements Serializable {
        private String tokenManagerId;
        private String hashTokenKey;
        private AccessTokenWrapper accessTokenWrapper;
        private long timestamp;

        TokenEntry(String tokenManagerId, String hashedTokenKey, AccessTokenWrapper accessTokenWrapper, long timestamp) {
            this.hashTokenKey = hashedTokenKey;
            this.tokenManagerId = tokenManagerId;
            this.accessTokenWrapper = accessTokenWrapper;
            this.timestamp = timestamp;
        }

        public String getTokenManagerId() {
            return this.tokenManagerId;
        }

        public String getHashTokenKey() {
            return this.hashTokenKey;
        }

        public AccessTokenWrapper getAccessTokenWrapper() {
            return this.accessTokenWrapper;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }

    class TokenMap
    extends DistributableCache<AccessTokenWrapper> {
        private static final long serialVersionUID = 1L;
        private final String tokenManagerId;

        TokenMap(String tokenManagerId) {
            super(0L, Integer.MAX_VALUE, false, ReferenceBearerAccessTokenTrackerMemoryImpl.this.makeConsistentHashTracker());
            this.tokenManagerId = tokenManagerId;
        }

        @Override
        protected void onEntryPurged(String key, AccessTokenWrapper value, boolean expired, long timestamp) {
            ReferenceBearerAccessTokenTrackerMemoryImpl.this.removeTokenFromGrantGuidSet(key, this.tokenManagerId, value);
        }

        @Override
        public boolean equals(Object other) {
            return super.equals(other);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    private class TrackerState {
        private final TokenMap hashValueToTokenMap;
        private final Map<String, Set<String>> accessGrantGuidToHashedTokensMap = new HashMap<String, Set<String>>();

        TrackerState(String tokenManagerId) {
            this.hashValueToTokenMap = new TokenMap(tokenManagerId);
            this.hashValueToTokenMap.setClock(ReferenceBearerAccessTokenTrackerMemoryImpl.this.getClock());
        }

        private TokenMap getHashValueToTokenMap() {
            return this.hashValueToTokenMap;
        }

        private Map<String, Set<String>> getAccessGrantGuidToHashedTokensMap() {
            return this.accessGrantGuidToHashedTokensMap;
        }
    }
}

