/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.token.plugin.impl;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.oauth20.token.plugin.impl.AccessTokenWrapper;
import org.sourceid.oauth20.token.plugin.impl.ReferenceBearerAccessTokenTracker;
import org.sourceid.oauth20.token.plugin.impl.ReferenceBearerAccessTokenTrackerMemoryImpl;
import org.sourceid.oauth20.token.plugin.impl.ReferenceBearerAccessTokenTrackerRpcImpl;
import org.sourceid.saml20.service.impl.grouprpc.RpcResponseMode;

public class ReferenceBearerAccessTokenTrackerWrapper {
    private final Log log = LogFactory.getLog(this.getClass());
    private String tokenManagerId;
    private ReferenceBearerAccessTokenTracker tracker;

    public ReferenceBearerAccessTokenTrackerWrapper(String tokenManagerId, ReferenceBearerAccessTokenTracker tracker) {
        this.tokenManagerId = tokenManagerId;
        this.tracker = tracker;
    }

    public AccessTokenWrapper get(String hashedTokenValue) {
        AccessTokenWrapper result = this.tracker.get(this.tokenManagerId, hashedTokenValue);
        this.logTokenAction("Retrieved access token", hashedTokenValue, result);
        return result;
    }

    public void updateExpiration(String hashedTokenValue, long expiresAt) {
        if (this.log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Updating stored token ").append(hashedTokenValue).append(" on token manager ").append(this.tokenManagerId).append(", expires at ").append(this.getUnixEpochWithLocalTime(expiresAt));
            this.log.debug((Object)sb);
        }
        this.tracker.updateExpiration(this.tokenManagerId, hashedTokenValue, expiresAt);
    }

    public void store(String hashedTokenValue, AccessTokenWrapper token) {
        this.logTokenAction("Saving token", hashedTokenValue, token);
        this.tracker.store(this.tokenManagerId, hashedTokenValue, token);
    }

    public void revokeAllAccessTokens(String accessGrantGuid) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Revoking all access tokens for access grant (" + accessGrantGuid + ") in " + this.tokenManagerId));
        }
        this.tracker.revokeAllAccessTokens(this.tokenManagerId, accessGrantGuid);
    }

    public void revokeAllAccessTokensByClient(String clientId) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Revoking all access tokens for client (" + clientId + ") in " + this.tokenManagerId));
        }
        this.tracker.revokeAllAccessTokensByClient(this.tokenManagerId, clientId);
    }

    public Boolean revokeAccessToken(String hashedTokenValue) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Revoking access token (hashed: " + hashedTokenValue + ") in " + this.tokenManagerId));
        }
        return this.tracker.revokeAccessToken(this.tokenManagerId, hashedTokenValue);
    }

    public void setRpcResponseMode(RpcResponseMode rpcResponseMode) {
        if (this.tracker instanceof ReferenceBearerAccessTokenTrackerRpcImpl) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Set RPC response mode to " + rpcResponseMode));
            }
            ((ReferenceBearerAccessTokenTrackerRpcImpl)this.tracker).setRpcResponseMode(rpcResponseMode);
        }
    }

    public void setRpcTimeout(int rpcTimeout) {
        if (this.tracker instanceof ReferenceBearerAccessTokenTrackerRpcImpl) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Set RPC response timeout to " + rpcTimeout));
            }
            ((ReferenceBearerAccessTokenTrackerRpcImpl)this.tracker).setRpcTimeout(rpcTimeout);
        }
    }

    void store(String hashedTokenValue, AccessTokenWrapper tokenWrapper, long currentTime) {
        if (!(this.tracker instanceof ReferenceBearerAccessTokenTrackerMemoryImpl)) {
            throw new UnsupportedOperationException();
        }
        ((ReferenceBearerAccessTokenTrackerMemoryImpl)this.tracker).store(this.tokenManagerId, hashedTokenValue, tokenWrapper, currentTime);
    }

    int numberOfTokens() {
        if (this.tracker instanceof ReferenceBearerAccessTokenTrackerMemoryImpl) {
            return ((ReferenceBearerAccessTokenTrackerMemoryImpl)this.tracker).numberOfTokens(this.tokenManagerId);
        }
        throw new UnsupportedOperationException();
    }

    int numberOfAccessGuids() {
        if (this.tracker instanceof ReferenceBearerAccessTokenTrackerMemoryImpl) {
            return ((ReferenceBearerAccessTokenTrackerMemoryImpl)this.tracker).numberOfAccessGuids(this.tokenManagerId);
        }
        throw new UnsupportedOperationException();
    }

    public ReferenceBearerAccessTokenTracker getTracker() {
        return this.tracker;
    }

    private void logTokenAction(String actionDescription, String hashedTokenValue, AccessTokenWrapper accessTokenWrapper) {
        if (this.log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(actionDescription).append(" for ").append(hashedTokenValue).append(" from ").append(this.tokenManagerId);
            if (accessTokenWrapper != null) {
                if (accessTokenWrapper.getAccessToken() != null) {
                    sb.append(", token will expire at Unix epoch ").append(this.getUnixEpochWithLocalTime(accessTokenWrapper.getAccessToken().getExpiresAt()));
                }
                sb.append(", tombstone status is ").append(accessTokenWrapper.isTombstone());
                sb.append(", issued at Unix epoch ").append(this.getUnixEpochWithLocalTime(accessTokenWrapper.getIssuedAt()));
            }
            this.log.debug((Object)sb);
        }
    }

    private String getUnixEpochWithLocalTime(long epoch) {
        ZoneId timezone = ZoneId.systemDefault();
        LocalDateTime date = Instant.ofEpochMilli(epoch).atZone(timezone).toLocalDateTime();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return epoch + " (" + dateTimeFormatter.format(date) + " " + timezone.toString() + ")";
    }
}

