/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.utils;

import java.security.Key;
import java.util.Objects;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.auth.BasicAuthHelp;
import org.sourceid.auth.BasicAuthValue;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.protocol.Parameters;

public final class ClientSecretUtils {
    private static final String CLIENT_SECRET_ATTRIBUTE_NAME = "REQ_ATTRIBUTE_AUTHENTICATED_CLIENT_SECRET";
    private static final Log log = LogFactory.getLog(ClientSecretUtils.class);

    private ClientSecretUtils() {
        throw new AssertionError((Object)"not allowed");
    }

    public static String getClientSecretFromRequest(HttpServletRequest req) {
        String clientSecretParam = req.getParameter(Parameters.CLIENT_SECRET);
        if (clientSecretParam != null) {
            return clientSecretParam;
        }
        String authHeader = BasicAuthHelp.getAuthTokenFromHeaders(req);
        if (authHeader != null) {
            try {
                BasicAuthValue basicAuthValue = BasicAuthHelp.getValues(authHeader, false, true);
                return basicAuthValue.getPassword();
            }
            catch (LoginException e) {
                log.debug((Object)"Could not parse basic authorization header", (Throwable)e);
            }
        }
        return null;
    }

    public static boolean isSecondarySecret(String clientSecret, Client client) {
        return client.getSecondarySecrets().validateSecret(clientSecret);
    }

    public static void logSecondarySecretUsage(ActivityType activityType, String clientId) {
        String msg = "[%s] Secondary client secret was used for %s";
        log.debug((Object)String.format(msg, clientId, activityType.getActivityTypeMsg()));
    }

    public static void setSecretToRequestAttributes(HttpServletRequest request, byte[] clientSecret) {
        Objects.requireNonNull(request, "HttpServletRequest");
        Objects.requireNonNull(clientSecret, "clientSecret");
        request.setAttribute(CLIENT_SECRET_ATTRIBUTE_NAME, (Object)clientSecret);
    }

    public static void setSecretToRequestAttributes(HttpServletRequest request, Key key) {
        Objects.requireNonNull(key, "key");
        ClientSecretUtils.setSecretToRequestAttributes(request, key.getEncoded());
    }

    public static byte[] getSecretFromRequestAttribute(HttpServletRequest request) {
        Object attribute = request.getAttribute(CLIENT_SECRET_ATTRIBUTE_NAME);
        if (attribute instanceof byte[]) {
            return (byte[])attribute;
        }
        return null;
    }

    public static enum ActivityType {
        CLIENT_AUTHENTICATION("client authentication"),
        TOKEN_ENCRYPTION("token encryption"),
        TOKEN_SIGNING("token signing"),
        REQUEST_OBJ_DECRYPTION("request object decryption"),
        ID_TOKEN_HINT_DECRYPTION("id token hint decryption");

        private final String activityTypeMsg;

        private ActivityType(String activityType) {
            this.activityTypeMsg = activityType;
        }

        public String getActivityTypeMsg() {
            return this.activityTypeMsg;
        }
    }
}

