/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.utils;

import com.pingidentity.common.util.HierarchicalUriComparison;
import com.pingidentity.common.util.LogGuard;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.sourceid.oauth20.handlers.AccessTokenRequestException;
import org.sourceid.oauth20.handlers.AuthorizationRequestException;
import org.sourceid.oauth20.protocol.HttpRequestUtil;
import org.sourceid.websso.profiles.RequestProcessingException;
import org.sourceid.websso.profiles.idp.AsAuditLogger;

public final class ResourceIndicatorsUtils {
    private static final Log log = LogFactory.getLog(ResourceIndicatorsUtils.class);

    public static Set<String> getResourceParams(HttpServletRequest req) {
        List<String> resources = HttpRequestUtil.getParameters(req, "resource");
        if (CollectionUtils.isEmpty(resources)) {
            return Collections.emptySet();
        }
        return new HashSet<String>(resources);
    }

    public static Set<String> getResourceParams(HttpServletRequest req, JwtClaims claims) throws AuthorizationRequestException {
        List<String> resources;
        if (claims == null) {
            return ResourceIndicatorsUtils.getResourceParams(req);
        }
        try {
            resources = claims.isClaimValueString("resource") ? Collections.singletonList(claims.getStringClaimValue("resource")) : claims.getStringListClaimValue("resource");
        }
        catch (MalformedClaimException e) {
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_target, e.getMessage(), e);
        }
        if (CollectionUtils.isEmpty(resources)) {
            return Collections.emptySet();
        }
        return new HashSet<String>(resources);
    }

    public static void validateResourcesAuthorized(Set<String> requestedResources, Set<String> authorizedResources) throws AccessTokenRequestException {
        if (CollectionUtils.isEmpty(requestedResources)) {
            return;
        }
        if (CollectionUtils.isEmpty(authorizedResources)) {
            AsAuditLogger.setDescription("The resource(s) is not authorized");
            log.error((Object)("Resource parameter(s) " + requestedResources.stream().map(LogGuard::encode).collect(Collectors.joining(", ")) + " is not authorized"));
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_target, "The specified resource(s) is not authorized");
        }
        if (authorizedResources.containsAll(requestedResources)) {
            return;
        }
        for (String requestedResource : requestedResources) {
            URI requestedResourceUri;
            try {
                requestedResourceUri = new URI(requestedResource);
            }
            catch (URISyntaxException e) {
                AsAuditLogger.setDescription("The resource(s) is not a valid URI");
                log.error((Object)("Resource parameter is not a valid URI: " + LogGuard.encode(requestedResource)));
                throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_target, "The specified resource(s) is not a valid URI");
            }
            boolean isAuthorized = false;
            for (String authorizedResource : authorizedResources) {
                try {
                    URI authorizedResourceUri = new URI(authorizedResource);
                    int compareResult = HierarchicalUriComparison.compare(requestedResourceUri, authorizedResourceUri, true);
                    if (compareResult < 0) continue;
                    isAuthorized = true;
                    break;
                }
                catch (URISyntaxException e) {
                    log.debug((Object)("Invalid token manager resource URI: " + LogGuard.encode(authorizedResource)));
                }
            }
            if (isAuthorized) continue;
            AsAuditLogger.setDescription("The resource(s) is not authorized");
            log.error((Object)("Resource parameter " + LogGuard.encode(requestedResource) + " is not authorized"));
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_target, "The specified resource(s) is not authorized");
        }
    }

    public static void validateResources(Set<String> resources) throws RequestProcessingException {
        for (String resource : resources) {
            try {
                URI resourceUri = new URI(resource);
                if (!resourceUri.isAbsolute()) {
                    AsAuditLogger.setDescription("The resource(s) must be an absolute URI");
                    log.error((Object)("Resource parameter must be an absolute URI: " + LogGuard.encode(resource)));
                    throw new RequestProcessingException("The specified resource(s) must be an absolute URI");
                }
                if (resourceUri.getFragment() == null) continue;
                AsAuditLogger.setDescription("The resource(s) must not include a fragment component");
                log.error((Object)("Resource parameter must not include a fragment component: " + LogGuard.encode(resource)));
                throw new RequestProcessingException("The specified resource(s) must not include a fragment component");
            }
            catch (URISyntaxException e) {
                AsAuditLogger.setDescription("The resource(s) is not a valid URI");
                log.error((Object)("Resource parameter is not a valid URI: " + LogGuard.encode(resource)));
                throw new RequestProcessingException("The specified resource(s) is not a valid URI", e);
            }
        }
    }

    private ResourceIndicatorsUtils() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }
}

