/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.validate.admin.auth;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.oauth20.validate.admin.auth.OAuth2AdminAuthValidator;
import org.sourceid.openid.connect.domain.OAuthClientConnection;
import org.sourceid.openid.connect.domain.OAuthClientTokenValidateConnection;
import org.sourceid.saml20.domain.mgmt.AdminUserManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class OAuth2AdminApiAuthValidator
extends OAuth2AdminAuthValidator {
    private final OAuthClientConnection connection;
    private final String usernameAttrName;
    private final String roleAttributeName;
    private static final Log log = LogFactory.getLog(OAuth2AdminApiAuthValidator.class);

    public OAuth2AdminApiAuthValidator() {
        AdminUserManager adminUserManager = MgmtFactory.getAdminApiUserManager();
        this.connection = adminUserManager.getConnection();
        this.usernameAttrName = adminUserManager.getUsernameAttributeName();
        this.roleAttributeName = adminUserManager.getRoleAttributeName();
    }

    public OAuth2AdminApiAuthValidator(OAuthClientConnection connection, String usernameAttrName, String roleAttributeName) {
        this.connection = connection;
        this.usernameAttrName = usernameAttrName;
        this.roleAttributeName = roleAttributeName;
    }

    @Override
    protected String getAdminAuthName() {
        return "OAuth";
    }

    @Override
    public boolean validate() {
        OAuthClientTokenValidateConnection oAuthConnection = (OAuthClientTokenValidateConnection)this.connection;
        boolean isValid = this.validateValue(oAuthConnection.getClientId(), true, false, "Client Identification");
        isValid = isValid && this.validateClientSecret(oAuthConnection.getClientSecret() == null ? null : oAuthConnection.getClientSecret().getStrValue(), "Client Secret", oAuthConnection.getClientAuthType());
        isValid = isValid && this.validateClientAuthType(oAuthConnection.getClientAuthType(), "Client Authentication Type");
        isValid = isValid && this.validateValue(oAuthConnection.getIntrospectionEndpoint(), true, true, "Introspection Endpoint");
        isValid = isValid && this.validateValue(this.usernameAttrName, true, false, "Username Attribute name");
        isValid = isValid && this.validateValue(this.roleAttributeName, true, false, "Role Attribute name");
        isValid = isValid && this.validateValue(oAuthConnection.getSpaceSeparatedScope(), false, false, "required.scopes");
        return isValid;
    }

    @Override
    protected boolean validateClientAuthType(String value, String friendlyName) {
        boolean isValid = this.validateValue(value, true, false, friendlyName);
        if (!(value == null || "private_key_jwt".equals(value) || "client_secret_basic".equals(value) || "client_secret_post".equals(value) || "client_secret_jwt".equals(value) || "NONE".equalsIgnoreCase(value))) {
            log.error((Object)(this.getAdminAuthName() + " ADMIN AUTH ERROR: '" + value + "' is not a valid " + friendlyName + " . The supported authentication types are: client_secret_basic , client_secret_post , client_secret_jwt , private_key_jwt and none."));
            return false;
        }
        return isValid;
    }
}

