/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.validate.admin.auth;

import com.pingidentity.common.util.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.oauth20.validate.admin.auth.OAuth2AdminAuthValidator;
import org.sourceid.openid.connect.domain.OAuthClientConnection;
import org.sourceid.openid.connect.domain.OIDCProviderConnection;
import org.sourceid.saml20.domain.OIDCRequestParamSetting;
import org.sourceid.saml20.domain.mgmt.AdminUserManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class OIDCAdminAuthValidator
extends OAuth2AdminAuthValidator {
    private static final Log log = LogFactory.getLog(OIDCAdminAuthValidator.class);

    @Override
    protected String getAdminAuthName() {
        return "OIDC";
    }

    @Override
    public boolean validate() {
        AdminUserManager adminUserManager = MgmtFactory.getAdminUserManager();
        OAuthClientConnection connection = adminUserManager.getConnection();
        OIDCProviderConnection oidcProviderConnection = (OIDCProviderConnection)connection;
        boolean isValid = this.validate(oidcProviderConnection);
        isValid = isValid && this.validateValue(adminUserManager.getUsernameAttributeName(), true, false, "Username claim name");
        isValid = isValid && this.validateValue(adminUserManager.getRoleAttributeName(), true, false, "Role Attribute claim name");
        return isValid;
    }

    public boolean validate(OIDCProviderConnection oidcProviderConnection) {
        boolean isValid = this.validateValue(oidcProviderConnection.getClientId(), true, false, "Client Identification");
        isValid = isValid && this.validateClientAuthType(oidcProviderConnection.getClientAuthType(), "Client Authentication Type");
        isValid = isValid && this.validateValue(oidcProviderConnection.getAuthorizationEndpoint(), true, true, "Authorization Endpoint");
        isValid = isValid && this.validateValue(oidcProviderConnection.getTokenEndpoint(), true, true, "Token Endpoint");
        isValid = isValid && this.validateValue(oidcProviderConnection.getUserInfoEndpoint(), false, true, "UserInfo Endpoint");
        isValid = isValid && this.validateValue(oidcProviderConnection.getEndSessionEndpoint(), false, true, "End Session Endpoint", false);
        isValid = isValid && this.validateValue(oidcProviderConnection.getIssuer(), true, false, "Issuer");
        isValid = isValid && this.validateRequestParameters(oidcProviderConnection.getRequestParamSettings());
        isValid = isValid && this.validateValue(oidcProviderConnection.getPushedAuthorizationRequestEndpoint(), false, true, "Pushed Authorization Request Endpoint");
        isValid = isValid && this.validateValue(oidcProviderConnection.getAudience(), false, false, "Audience");
        isValid = isValid && this.validateValue(oidcProviderConnection.getType(), false, false, "Type");
        return isValid;
    }

    public boolean validateClientSecret() {
        AdminUserManager adminUserManager = MgmtFactory.getAdminUserManager();
        OAuthClientConnection connection = adminUserManager.getConnection();
        OIDCProviderConnection oidcProviderConnection = (OIDCProviderConnection)connection;
        return this.validateClientSecret(oidcProviderConnection.getClientSecret() == null ? null : oidcProviderConnection.getClientSecret().getStrValue(), "Client Secret", oidcProviderConnection.getClientAuthType());
    }

    private boolean validateRequestParameters(Collection<OIDCRequestParamSetting> requestParamSettings) {
        HashSet<Pair<String, String>> visitedRequestParameters = new HashSet<Pair<String, String>>();
        if (!requestParamSettings.isEmpty()) {
            for (OIDCRequestParamSetting requestParamSetting : requestParamSettings) {
                if (this.isParameterNameValid(requestParamSetting) && this.isParameterValueValid(requestParamSetting) && this.isMultiValueParameterValid(requestParamSetting, visitedRequestParameters)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isParameterNameValid(OIDCRequestParamSetting requestParamSetting) {
        String paramName = requestParamSetting.getName();
        if (StringUtils.isBlank((String)paramName)) {
            log.error((Object)"Missing request parameter name.");
            return false;
        }
        return true;
    }

    private boolean isParameterValueValid(OIDCRequestParamSetting requestParamSetting) {
        String value = requestParamSetting.getValue().getValue();
        boolean overridable = requestParamSetting.isOverride();
        if (StringUtils.isBlank((String)value) && !overridable) {
            log.error((Object)"Default request parameter value is required when the value of Request Parameter Overridable is false or empty.");
            return false;
        }
        return true;
    }

    private boolean isMultiValueParameterValid(OIDCRequestParamSetting requestParamSetting, Set<Pair<String, String>> visitedRequestParameters) {
        String value;
        String name = requestParamSetting.getName();
        Pair nameValuePair = new Pair((Object)name, (Object)(value = requestParamSetting.getValue().getValue()));
        if (visitedRequestParameters.contains(nameValuePair)) {
            log.error((Object)"Duplicated request parameter values found.");
            return false;
        }
        visitedRequestParameters.add((Pair<String, String>)nameValuePair);
        return true;
    }
}

