/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.wrapper;

import com.pingidentity.sdk.api.authn.internal.InternalAuthnApiSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.servlet.streams.LengthLimitServletInputStream;

public class AuthnApiRequestProxy
extends HttpServletRequestWrapper {
    private static final Log log = LogFactory.getLog(AuthnApiRequestProxy.class);
    protected HttpServletRequest request;
    ByteArrayOutputStream apiCachedBytes;
    private String contentType;
    private Map<String, Cookie> cookies = null;
    private final boolean cookiesUpdated;

    public AuthnApiRequestProxy(HttpServletRequest request) {
        super(request);
        this.request = request;
        this.cookiesUpdated = false;
    }

    public AuthnApiRequestProxy(HttpServletRequest request, Map<String, Cookie> cookies) {
        super(request);
        this.request = request;
        this.cookiesUpdated = true;
        this.cookies = cookies;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.apiCachedBytes == null) {
            this.apiCachedBytes = new ByteArrayOutputStream();
            try (LengthLimitServletInputStream input = new LengthLimitServletInputStream(this.request.getInputStream());){
                IOUtils.copy((InputStream)((Object)input), (OutputStream)this.apiCachedBytes);
            }
        }
        return new CachedServletInputStream(this.apiCachedBytes);
    }

    public String getMethod() {
        if (InternalAuthnApiSupport.getDefault().isRequestBodyConsumed(this.request)) {
            return "GET";
        }
        return this.request.getMethod();
    }

    public Cookie[] getCookies() {
        if (this.cookiesUpdated) {
            return this.cookies.values().toArray(new Cookie[0]);
        }
        return super.getCookies();
    }

    public String getContentType() {
        if (InternalAuthnApiSupport.getDefault().isRequestBodyConsumed(this.request)) {
            return null;
        }
        if (this.contentType != null) {
            return this.contentType;
        }
        String actionParam = this.request.getParameter("action");
        if (!StringUtils.isBlank((String)actionParam)) {
            this.contentType = "application/vnd.pingidentity." + actionParam.trim() + "+json";
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting Content-Type to '" + this.contentType + "' based on 'action' query param"));
            }
        } else {
            this.contentType = this.request.getContentType();
        }
        return this.contentType;
    }

    private static class CachedServletInputStream
    extends ServletInputStream {
        private ByteArrayInputStream input;

        public CachedServletInputStream(ByteArrayOutputStream cachedBytes) {
            this.input = new ByteArrayInputStream(cachedBytes.toByteArray());
        }

        public int read() throws IOException {
            return this.input.read();
        }

        public boolean isFinished() {
            return this.input.available() == 0;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener listener) {
            throw new UnsupportedOperationException("setReadListener not implemented");
        }
    }
}

