/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.wwwauth;

import com.pingidentity.sdk.oauth20.Scope;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.sourceid.auth.AuthorizationHeaderSupport;
import org.sourceid.oauth20.dpop.DpopUtil;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.websso.servlet.HttpStatusCodeException;

public class AccessTokenUtil {
    private static final String ACCESS_TOKEN = "access_token";
    private static final String BEARER = "Bearer";
    private static final String DPOP = "DPoP";
    private static final String ERROR = "error";
    private static final String ERROR_DESC = "error_description";
    private static final String ERROR_RESPONSE_CONTENT_TYPE_REQ_ATTR = "pf_global_error_response_content_type";
    private final Scope suggestedScopes;
    private final String realm;

    public AccessTokenUtil(Scope suggestedScopes, String realm) {
        this.suggestedScopes = suggestedScopes == null ? new Scope(new String[0]) : suggestedScopes;
        this.realm = realm;
    }

    public String getBearerAccessToken(HttpServletRequest request) throws HttpStatusCodeException {
        return this.getBearerAccessToken(request, true);
    }

    public String getBearerAccessToken(HttpServletRequest request, boolean throwExceptionIfNotFound) throws HttpStatusCodeException {
        String token;
        String tokenFromHeader = this.getAccessTokenFromHeader(request);
        String tokenFromParam = this.getAccessTokenFromParm(request);
        if (tokenFromHeader != null && tokenFromParam != null) {
            String msg = "Access token sent using more than one method";
            throw this.statusCodeEx(400, ErrorCode.invalid_request, msg);
        }
        String string = token = tokenFromHeader != null ? tokenFromHeader : tokenFromParam;
        if (token == null && throwExceptionIfNotFound) {
            throw this.statusCodeEx(401, ErrorCode.invalid_request, "No access token sent");
        }
        return token;
    }

    private String getAccessTokenFromParm(HttpServletRequest request) {
        return request.getParameter(ACCESS_TOKEN);
    }

    private String getAccessTokenFromHeader(HttpServletRequest request) {
        return AuthorizationHeaderSupport.getAuthTokenValue(request, BEARER);
    }

    public HttpStatusCodeException statusCodeEx(int sc, ErrorCode errorCode, String errorDesc) {
        return this.statusCodeEx(sc, errorCode, errorDesc, false);
    }

    public HttpStatusCodeException statusCodeEx(int sc, ErrorCode errorCode, String errorDesc, boolean isDpopScheme) {
        HttpStatusCodeException statusCodeException = new HttpStatusCodeException(sc);
        String headerValue = this.buildWwwAuthHeaderValue(isDpopScheme ? DPOP : BEARER, errorCode, errorDesc);
        statusCodeException.setHeader("WWW-Authenticate", headerValue);
        return statusCodeException;
    }

    public HttpStatusCodeException statusCodeExBearerAndDpop(int sc, ErrorCode errorCode, String errorDesc) {
        HttpStatusCodeException statusCodeException = new HttpStatusCodeException(sc);
        String headerValue = this.buildWwwAuthHeaderValueBearerAndDpop(errorCode, errorDesc);
        statusCodeException.setHeader("WWW-Authenticate", headerValue);
        return statusCodeException;
    }

    public String buildWwwAuthHeaderValue(String authScheme, ErrorCode errorCode, String errorDesc) {
        StringBuilder headerValue = new StringBuilder();
        this.appendAuthSchemeHeaderValue(headerValue, authScheme);
        if (DPOP.equals(authScheme)) {
            this.appendDpoPAlgorithmsHeaderValue(headerValue);
        }
        this.appendErrorAndErrorDescHeaderValues(headerValue, errorCode, errorDesc);
        this.appendRealmAndScopeHeaderValues(headerValue);
        return headerValue.toString();
    }

    public String buildWwwAuthHeaderValueBearerAndDpop(ErrorCode errorCode, String errorDesc) {
        StringBuilder headerValue = new StringBuilder();
        this.appendAuthSchemeHeaderValue(headerValue, BEARER);
        this.appendErrorAndErrorDescHeaderValues(headerValue, errorCode, errorDesc);
        this.appendAuthSchemeHeaderValue(headerValue, DPOP);
        this.appendDpoPAlgorithmsHeaderValue(headerValue);
        this.appendErrorAndErrorDescHeaderValues(headerValue, errorCode, errorDesc);
        this.appendRealmAndScopeHeaderValues(headerValue);
        return headerValue.toString();
    }

    private void appendAuthSchemeHeaderValue(StringBuilder headerValue, String schemeName) {
        this.appendCommaOrSpaceHeaderValue(headerValue);
        headerValue.append(schemeName);
    }

    private void appendDpoPAlgorithmsHeaderValue(StringBuilder headerValue) {
        this.appendCommaOrSpaceHeaderValue(headerValue);
        headerValue.append("algs=\"").append(String.join((CharSequence)" ", DpopUtil.getSupportedSigningAlgorithms())).append("\"");
    }

    private void appendErrorAndErrorDescHeaderValues(StringBuilder headerValue, ErrorCode errorCode, String errorDesc) {
        if (errorCode != null) {
            this.appendCommaOrSpaceHeaderValue(headerValue);
            headerValue.append(ERROR).append("=\"").append((Object)errorCode).append("\"");
        }
        if (errorDesc != null) {
            this.appendCommaOrSpaceHeaderValue(headerValue);
            headerValue.append(ERROR_DESC).append("=\"").append(errorDesc).append("\"");
        }
    }

    private void appendRealmAndScopeHeaderValues(StringBuilder headerValue) {
        if (this.realm != null) {
            this.appendCommaOrSpaceHeaderValue(headerValue);
            headerValue.append("realm").append("=\"").append(this.realm).append("\"");
        }
        if (!this.suggestedScopes.getScopeSet().isEmpty()) {
            this.appendCommaOrSpaceHeaderValue(headerValue);
            headerValue.append(Parameters.SCOPE).append("=\"").append(this.suggestedScopes.getScopeStr()).append("\"");
        }
    }

    private void appendCommaOrSpaceHeaderValue(StringBuilder headerValue) {
        if (headerValue.length() > 0 && !StringUtils.endsWith((CharSequence)headerValue, (CharSequence)BEARER) && !StringUtils.endsWith((CharSequence)headerValue, (CharSequence)DPOP)) {
            headerValue.append(", ");
        } else if (headerValue.length() > 0) {
            headerValue.append(" ");
        }
    }

    public static void setErrorResponseContentType(HttpServletRequest request, String contentType) {
        request.setAttribute(ERROR_RESPONSE_CONTENT_TYPE_REQ_ATTR, (Object)contentType);
    }

    public static String getErrorResponseContentType(HttpServletRequest request) {
        Object attribute = request.getAttribute(ERROR_RESPONSE_CONTENT_TYPE_REQ_ATTR);
        if (attribute instanceof String) {
            return (String)attribute;
        }
        return null;
    }

    public static enum ErrorCode {
        invalid_request,
        invalid_token,
        insufficient_scope,
        use_dpop_nonce;

    }
}

