/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.ciba.domain;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.configservice.XmlLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.openid.ciba.domain.CibaServerPolicy;
import org.sourceid.openid.ciba.domain.CibaServerPolicyManager;
import org.sourceid.openid.ciba.xmlbinding.AlternativeLoginHintTokenIssuerType;
import org.sourceid.openid.ciba.xmlbinding.CibaRequestHandlingPolicyType;
import org.sourceid.openid.ciba.xmlbinding.CibaServerPolicyDocument;
import org.sourceid.openid.ciba.xmlbinding.CibaServerPolicyType;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.metadata.partner.ConnectionUtil;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.AttributeMappingType;

public class CibaServerPolicyManagerImpl
implements CibaServerPolicyManager,
AutoReloadable {
    private static final String FILENAME = "ciba-server-policy.xml";
    private XmlLoader xmlLoader;
    private String directory;
    private final ConnectionUtil connUtil = new ConnectionUtil();
    private CibaServerPolicy cibaServerPolicy;

    public CibaServerPolicyManagerImpl() {
    }

    public CibaServerPolicyManagerImpl(XmlLoader xmlLoader, SysDirInfo sysDirInfo) {
        this.xmlLoader = xmlLoader;
        this.directory = sysDirInfo.getDataDirectory();
        this.loadConfig();
    }

    @Override
    public synchronized CibaServerPolicy getCibaServerPolicy() {
        return this.cibaServerPolicy;
    }

    @Override
    public synchronized boolean isDataSourceInUse(String id) {
        for (CibaServerPolicy.RequestHandlingPolicy policy : this.cibaServerPolicy.getRequestHandlingPolicies().values()) {
            if (this.dataSourceInUseMapping(id, policy.getEnhanceRequestHintContractMapping())) {
                return true;
            }
            if (!this.dataSourceInUseMapping(id, policy.getHintContractToOOBAuthPluginMapping())) continue;
            return true;
        }
        return false;
    }

    private synchronized boolean dataSourceInUseMapping(String id, AttributeMapping mapping) {
        for (AttributeSource attributeSource : mapping.getAttributeSources()) {
            if (attributeSource == null || !id.equals(attributeSource.getDataSourceId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized List<CibaServerPolicy.RequestHandlingPolicy> getPoliciesWithDSInUse(String id) {
        AttributeMapping mapping;
        HashSet<CibaServerPolicy.RequestHandlingPolicy> policiesWithDSInUse = new HashSet<CibaServerPolicy.RequestHandlingPolicy>();
        for (CibaServerPolicy.RequestHandlingPolicy policy : this.cibaServerPolicy.getRequestHandlingPolicies().values()) {
            mapping = policy.getEnhanceRequestHintContractMapping();
            this.addPolicyToInUseCollection(id, policiesWithDSInUse, policy, mapping);
        }
        for (CibaServerPolicy.RequestHandlingPolicy policy : this.cibaServerPolicy.getRequestHandlingPolicies().values()) {
            mapping = policy.getHintContractToOOBAuthPluginMapping();
            this.addPolicyToInUseCollection(id, policiesWithDSInUse, policy, mapping);
        }
        return new ArrayList<CibaServerPolicy.RequestHandlingPolicy>(policiesWithDSInUse);
    }

    @Override
    public synchronized List<CibaServerPolicy.RequestHandlingPolicy> getPoliciesWithPCVInUse(String id) {
        HashSet<CibaServerPolicy.RequestHandlingPolicy> policies = new HashSet<CibaServerPolicy.RequestHandlingPolicy>();
        for (CibaServerPolicy.RequestHandlingPolicy policy : this.cibaServerPolicy.getRequestHandlingPolicies().values()) {
            if (!id.equals(policy.getUserCodePcvId())) continue;
            policies.add(policy);
        }
        return new ArrayList<CibaServerPolicy.RequestHandlingPolicy>(policies);
    }

    @Override
    public synchronized List<CibaServerPolicy.RequestHandlingPolicy> getPoliciesWithOOBAuthInUse(String id) {
        HashSet<CibaServerPolicy.RequestHandlingPolicy> policies = new HashSet<CibaServerPolicy.RequestHandlingPolicy>();
        for (CibaServerPolicy.RequestHandlingPolicy policy : this.cibaServerPolicy.getRequestHandlingPolicies().values()) {
            if (!id.equals(policy.getPluginId())) continue;
            policies.add(policy);
        }
        return new ArrayList<CibaServerPolicy.RequestHandlingPolicy>(policies);
    }

    private void addPolicyToInUseCollection(String id, Set<CibaServerPolicy.RequestHandlingPolicy> policyGroupsWithDSInUse, CibaServerPolicy.RequestHandlingPolicy policy, AttributeMapping mapping) {
        for (AttributeSource attributeSource : mapping.getAttributeSources()) {
            if (attributeSource == null || !id.equals(attributeSource.getDataSourceId())) continue;
            policyGroupsWithDSInUse.add(policy);
        }
    }

    @Override
    public synchronized void saveCibaServerPolicy(CibaServerPolicy policyToSave) {
        Collection<CibaServerPolicy.RequestHandlingPolicy> requestHandlingPolicies;
        AdminAuditLogger.Event event;
        this.loadConfig();
        CibaServerPolicy existingCibaServerPolicy = this.getCibaServerPolicy();
        String message = null;
        if (policyToSave.getRequestHandlingPolicies().size() == existingCibaServerPolicy.getRequestHandlingPolicies().size()) {
            event = AdminAuditLogger.Event.MODIFY;
            if (policyToSave.getDefaultRequestHandlingPolicyId() != null && existingCibaServerPolicy.getDefaultRequestHandlingPolicyId() != null && !policyToSave.getDefaultRequestHandlingPolicyId().equals(existingCibaServerPolicy.getDefaultRequestHandlingPolicyId())) {
                message = "Default instance modified to " + policyToSave.getDefaultRequestHandlingPolicyId();
            }
        } else {
            event = policyToSave.getRequestHandlingPolicies().size() > existingCibaServerPolicy.getRequestHandlingPolicies().size() ? AdminAuditLogger.Event.CREATE : AdminAuditLogger.Event.DELETE;
        }
        CibaServerPolicyDocument doc = CibaServerPolicyDocument.Factory.newInstance();
        CibaServerPolicyType cibaServerPolicyType = doc.addNewCibaServerPolicy();
        if (policyToSave.getRequestHandlingPolicies().isEmpty()) {
            policyToSave.setDefaultRequestHandlingPolicyId(null);
        }
        if ((requestHandlingPolicies = policyToSave.getRequestHandlingPolicies().values()).size() == 1) {
            String defaultRequestHandlingPolicyId = requestHandlingPolicies.iterator().next().getId();
            cibaServerPolicyType.setDefaultRequestHandlingPolicyId(defaultRequestHandlingPolicyId);
        } else {
            cibaServerPolicyType.setDefaultRequestHandlingPolicyId(policyToSave.getDefaultRequestHandlingPolicyId());
        }
        for (CibaServerPolicy.RequestHandlingPolicy rhp : requestHandlingPolicies) {
            CibaRequestHandlingPolicyType cibaReqHandlingPolicyType = cibaServerPolicyType.addNewCibaRequestHandlingPolicy();
            cibaReqHandlingPolicyType.setId(rhp.getId());
            cibaReqHandlingPolicyType.setName(rhp.getName());
            cibaReqHandlingPolicyType.setPluginId(rhp.getPluginId());
            cibaReqHandlingPolicyType.setTransactionLifeInSeconds(rhp.getTransactionLifeInSeconds());
            cibaReqHandlingPolicyType.setAllowUnsignedLoginHintToken(rhp.isAllowUnsignedLoginHintToken());
            cibaReqHandlingPolicyType.setRequireHintToken(rhp.isRequireTokenForHint());
            cibaReqHandlingPolicyType.setUserCodePcvId(rhp.getUserCodePcvId());
            if (rhp.getLastModified() != null) {
                cibaReqHandlingPolicyType.setLastModified(rhp.getLastModified());
            }
            for (CibaServerPolicy.RequestHandlingPolicy.AlternativeLoginHintTokenIssuer altLoginHintTokenIssuer : rhp.getAlternativeLoginHintTokenIssuers()) {
                AlternativeLoginHintTokenIssuerType altLoginHintTokenIssuerType = cibaReqHandlingPolicyType.addNewAlternativeLoginHintTokenIssuer();
                altLoginHintTokenIssuerType.setIssuer(altLoginHintTokenIssuer.getIssuer());
                altLoginHintTokenIssuerType.setJwksData(altLoginHintTokenIssuer.getJwksData());
                altLoginHintTokenIssuerType.setJwksDataIsReference(altLoginHintTokenIssuer.isJwksDataReference());
            }
            AttributeMappingType hintMappingType = cibaReqHandlingPolicyType.addNewHintContractToOOBAuthPluginMapping();
            this.connUtil.fillInAttributeMappingType(hintMappingType, rhp.getHintContractToOOBAuthPluginMapping());
            if (rhp.getEnhanceRequestHintContractMapping() != null) {
                AttributeMappingType attrMappingType = cibaReqHandlingPolicyType.addNewEnhanceRequestHintContractMapping();
                this.connUtil.fillInAttributeMappingType(attrMappingType, rhp.getEnhanceRequestHintContractMapping());
            }
            List<String> requestHintContract = rhp.getRequestHintAttributeContract();
            cibaReqHandlingPolicyType.setRequestHintAttributeArray(requestHintContract.toArray(new String[0]));
        }
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.xmlLoader.save(this.directory, FILENAME, (XmlObject)doc);
            auditLoggerScope.log(AdminAuditLogger.Component.OAUTH_CIBA_POLICY, event, message);
        }
        this.loadConfig();
    }

    private synchronized void loadConfig() {
        CibaServerPolicyDocument doc;
        if (this.xmlLoader.xmlExists(this.directory, FILENAME)) {
            XmlObject xmlObject = this.xmlLoader.load(this.directory, FILENAME);
            doc = (CibaServerPolicyDocument)xmlObject;
        } else {
            doc = CibaServerPolicyDocument.Factory.newInstance();
            doc.addNewCibaServerPolicy();
        }
        CibaServerPolicyType cibaServerPolicyType = doc.getCibaServerPolicy();
        CibaServerPolicy domainPolicy = new CibaServerPolicy();
        domainPolicy.setDefaultRequestHandlingPolicyId(cibaServerPolicyType.getDefaultRequestHandlingPolicyId());
        for (CibaRequestHandlingPolicyType crhpType : cibaServerPolicyType.getCibaRequestHandlingPolicyArray()) {
            CibaServerPolicy.RequestHandlingPolicy requestHandlingPolicy = new CibaServerPolicy.RequestHandlingPolicy();
            requestHandlingPolicy.setId(crhpType.getId());
            requestHandlingPolicy.setName(crhpType.getName());
            requestHandlingPolicy.setPluginId(crhpType.getPluginId());
            requestHandlingPolicy.setTransactionLifeInSeconds(crhpType.getTransactionLifeInSeconds());
            requestHandlingPolicy.setAllowUnsignedLoginHintToken(crhpType.getAllowUnsignedLoginHintToken());
            requestHandlingPolicy.setRequireTokenForHint(crhpType.getRequireHintToken());
            requestHandlingPolicy.setUserCodePcvId(crhpType.getUserCodePcvId());
            if (crhpType.getLastModified() != null) {
                requestHandlingPolicy.setLastModified(crhpType.getLastModified());
            }
            for (AlternativeLoginHintTokenIssuerType altLoginHintTokenIssuerType : crhpType.getAlternativeLoginHintTokenIssuerArray()) {
                CibaServerPolicy.RequestHandlingPolicy.AlternativeLoginHintTokenIssuer alternativeLoginHintTokenIssuer = new CibaServerPolicy.RequestHandlingPolicy.AlternativeLoginHintTokenIssuer(altLoginHintTokenIssuerType.getIssuer(), altLoginHintTokenIssuerType.getJwksData(), altLoginHintTokenIssuerType.getJwksDataIsReference());
                requestHandlingPolicy.getAlternativeLoginHintTokenIssuers().add(alternativeLoginHintTokenIssuer);
            }
            AttributeMapping mainMapping = new AttributeMapping();
            this.connUtil.fillAttrMappingFromXml(crhpType.getHintContractToOOBAuthPluginMapping(), mainMapping);
            requestHandlingPolicy.setHintContractToOOBAuthPluginMapping(mainMapping);
            if (crhpType.isSetEnhanceRequestHintContractMapping()) {
                AttributeMapping enhanceRequestHintContractMapping = new AttributeMapping();
                AttributeMappingType mappingType = crhpType.getEnhanceRequestHintContractMapping();
                this.connUtil.fillAttrMappingFromXml(mappingType, enhanceRequestHintContractMapping);
                requestHandlingPolicy.setEnhanceRequestHintContractMapping(enhanceRequestHintContractMapping);
            }
            String[] requestHintAttributeArray = crhpType.getRequestHintAttributeArray();
            List<String> requestHintAttrContract = Arrays.asList(requestHintAttributeArray);
            requestHandlingPolicy.setRequestHintAttributeContract(requestHintAttrContract);
            domainPolicy.addRequestHandlingPolicy(requestHandlingPolicy);
        }
        this.cibaServerPolicy = domainPolicy;
    }
}

