/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.ciba.handlers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.crypto.jwk.JwkFacilitator;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetail;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetails;
import com.pingidentity.sdk.locale.LocaleUtil;
import com.pingidentity.sdk.oauth20.Scope;
import com.pingidentity.sdk.oobauth.OOBAuthGeneralException;
import com.pingidentity.sdk.oobauth.OOBAuthPlugin;
import com.pingidentity.sdk.oobauth.OOBAuthRequestContext;
import com.pingidentity.sdk.oobauth.OOBAuthTransactionContext;
import com.pingidentity.sdk.oobauth.UnknownUserException;
import com.pingidentity.sdk.oobauth.UserAuthBindingMessageException;
import com.pingidentity.sdk.password.PasswordCredentialValidator;
import com.pingidentity.sdk.password.PasswordCredentialValidatorAuthnException;
import com.pingidentity.sdk.password.PasswordValidationException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jose4j.base64url.Base64Url;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwe.KeyManagementAlgorithm;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.keys.KeyPersuasion;
import org.jose4j.keys.resolvers.DecryptionKeyResolver;
import org.jose4j.keys.resolvers.HttpsJwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.JwksDecryptionKeyResolver;
import org.jose4j.keys.resolvers.JwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.ByteUtil;
import org.jose4j.lang.InvalidAlgorithmException;
import org.jose4j.lang.UnresolvableKeyException;
import org.sourceid.common.dsig.SignatureStatus;
import org.sourceid.oauth20.authorizationdetails.domain.AuthorizationDetailsUtil;
import org.sourceid.oauth20.authorizationdetails.domain.InvalidAuthorizationDetailException;
import org.sourceid.oauth20.consent.OAuthConsentManager;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientVerificationKeyResolver;
import org.sourceid.oauth20.domain.InvalidRequestedScopeException;
import org.sourceid.oauth20.domain.ScopeUtil;
import org.sourceid.oauth20.handlers.AccessTokenRequestException;
import org.sourceid.oauth20.handlers.BaseClientAuthnRequestHandler;
import org.sourceid.oauth20.handlers.ServerErrorException;
import org.sourceid.oauth20.issuer.OAuthAudienceUtils;
import org.sourceid.oauth20.issuer.OAuthIssuerUtils;
import org.sourceid.oauth20.protocol.HttpsJwksCache;
import org.sourceid.oauth20.utils.ClientSecretUtils;
import org.sourceid.oauth20.utils.JwtProcessingUtils;
import org.sourceid.openid.ciba.CibaDeliveryMode;
import org.sourceid.openid.ciba.bindings.CibaInMessageContext;
import org.sourceid.openid.ciba.domain.CibaServerPolicy;
import org.sourceid.openid.ciba.handlers.CibaHelper;
import org.sourceid.openid.ciba.handlers.CibaState;
import org.sourceid.openid.ciba.handlers.CibaStateSupport;
import org.sourceid.openid.connect.MultiDecryptionKeyResolver;
import org.sourceid.openid.connect.service.PairwisePseudonymService;
import org.sourceid.openid.connect.service.impl.PairwisePseudonymServiceException;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.AttrLookupException;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AuthenticationResultEnum;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PasswordCredentialValidatorManager;
import org.sourceid.util.ObjectMapperFactory;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.RequestHandlerBase;
import org.sourceid.websso.profiles.RequestProcessingException;
import org.sourceid.websso.profiles.idp.AsAuditLogger;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class CibaAuthenticationRequestHandler
extends RequestHandlerBase {
    private static final AlgorithmConstraints JWE_ALGORITHM_CONSTRAINTS = new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.BLACKLIST, new String[]{"RSA1_5", "PBES2-HS256+A128KW", "PBES2-HS384+A192KW", "PBES2-HS512+A256KW"});
    private final Pattern b64tokenPattern = Pattern.compile("[a-zA-Z0-9-._~+/]+=*");
    private final CibaStateSupport cibaStateSupport = CibaStateSupport.getInstance();
    private HttpsJwksCache httpsJwksCache = HttpsJwksCache.getInstance();
    private final CibaHelper cibaHelper = new CibaHelper();
    private final ObjectMapper objectMapper = ObjectMapperFactory.buildObjectMapper();
    private final String bindingMessageRegex = this.cibaHelper.getConfig().getStringValue("binding_message_regex", "^[a-zA-Z0-9-._+/!?#]{1,20}$");
    private final Pattern bindingMessageMatcher = Pattern.compile(this.bindingMessageRegex);
    private final String invalidBindingMessageDescription = this.cibaHelper.getConfig().getStringValue("invalid_binding_message_description", "the binding_message value, when provided, needs to be 1 - 20 characters in length and use only a basic set of characters (matching the regex: " + this.bindingMessageRegex + " )");
    private final PasswordCredentialValidatorManager pcvMgr;
    private final PairwisePseudonymService pairwisePseudonymService;
    private final JwkFacilitator jwkFacilitator;
    private final AuthzServerManager authzServerMgr;
    private final OAuthIssuerUtils oAuthIssuerUtils;
    private final OAuthAudienceUtils oAuthAudienceUtils;
    private final OAuthConsentManager oAuthConsentManager;

    public CibaAuthenticationRequestHandler() {
        this(MgmtFactory.getCredentialValidatorManager(), MgmtFactory.getPairwisePseudonymService(), MgmtFactory.getJwkFacilitator(), MgmtFactory.getAuthzServerManager(), OAuthIssuerUtils.getInstance(), OAuthAudienceUtils.getInstance(), MgmtFactory.getOAuthConsentManager());
    }

    public CibaAuthenticationRequestHandler(PasswordCredentialValidatorManager pcvMgr, PairwisePseudonymService pairwisePseudonymService, JwkFacilitator jwkFacilitator, AuthzServerManager authzServerMgr, OAuthIssuerUtils oAuthIssuerUtils, OAuthAudienceUtils oAuthAudienceUtils, OAuthConsentManager oAuthConsentManager) {
        this.pcvMgr = pcvMgr;
        this.pairwisePseudonymService = pairwisePseudonymService;
        this.jwkFacilitator = jwkFacilitator;
        this.authzServerMgr = authzServerMgr;
        this.oAuthIssuerUtils = oAuthIssuerUtils;
        this.oAuthAudienceUtils = oAuthAudienceUtils;
        this.oAuthConsentManager = oAuthConsentManager;
    }

    @Override
    protected OutMessageContext getInitialOutMsgCtx(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp) {
        return new OutMessageContext(inMsgCtx.getRoleType());
    }

    @Override
    protected void handle(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx) throws RequestProcessingException {
        CibaInMessageContext requestCtx;
        Client client;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"entering handle");
        }
        if ((client = (requestCtx = (CibaInMessageContext)inMsgCtx).getClient()).isCibaRequireSignedRequests().booleanValue() && requestCtx.getSignatureStatus() != SignatureStatus.VALID) {
            throw this.reqErr(AccessTokenRequestException.Error.invalid_request, "given client is required to use signed CIBA authentication requests");
        }
        Scope scope = this.getCheckScope(requestCtx);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("checked scope " + scope));
        }
        AuthorizationDetails authorizationDetails = this.getCheckAuthorizationDetails(requestCtx, client, req, scope);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("checked authorization details " + authorizationDetails.toJson()));
        }
        String clientNotificationToken = this.getCheckClientNotificationToken(requestCtx);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("checked clientNotificationToken " + clientNotificationToken));
        }
        String bindingMessage = this.getCheckBindingMessage(requestCtx);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("checked bindingMessage " + bindingMessage));
        }
        CibaServerPolicy.RequestHandlingPolicy requestHandlingPolicy = this.cibaHelper.getRequestHandlingPolicy(client);
        int expiresIn = this.getExpiresIn(requestCtx, requestHandlingPolicy);
        long expiresAt = this.cibaHelper.nowInSecondsFromEpoch() + (long)expiresIn;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("got expiresIn " + expiresIn));
        }
        AttributeMap userHintAttributes = this.rationalizeUserHints(requestCtx, requestHandlingPolicy, req);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("processed user hint info: " + userHintAttributes));
        }
        Locale locale = LocaleUtil.getUserLocale((HttpServletRequest)req);
        AttributeMap contextAttrs = new AttributeMap();
        contextAttrs.put(SourceContextType.CLIENT_IP.getId(), new AttributeValue(req.getRemoteAddr()));
        contextAttrs.put(SourceContextType.REQUEST.getId(), AttrValueSupport.make((Object)req));
        String clientId = client.getClientId();
        contextAttrs.put(SourceContextType.OAUTH_CLIENT.getId(), clientId);
        contextAttrs.put(SourceContextType.LOCALE.getId(), AttrValueSupport.make((Object)locale));
        contextAttrs.put(SourceContextType.OAUTH_SCOPES.getId(), new AttributeValue((Collection)scope.getScopeSet()));
        if (authorizationDetails != null && authorizationDetails.getDetails() != null) {
            AuthorizationDetailsUtil.enrich(authorizationDetails, req, clientId, scope);
            contextAttrs.put(SourceContextType.OAUTH_AUTHORIZATION_DETAILS.getId(), authorizationDetails.toAttributeValue());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("made context attributes: " + contextAttrs));
        }
        try {
            Set<String> pluginContract;
            AttributeMap attributesForPlugin;
            AttributeMapping hintContractToOOBAuthPluginMapping;
            AttributeMap mappedAttributes;
            AttributeMapping enhanceRequestHintContractMapping = requestHandlingPolicy.getEnhanceRequestHintContractMapping();
            if (enhanceRequestHintContractMapping != null) {
                userHintAttributes = enhanceRequestHintContractMapping.executeMapping(userHintAttributes, null, contextAttrs);
                locale = this.optionalLocaleOverrideFromMapping(userHintAttributes, locale, contextAttrs);
                scope = this.optionalScopeOverrideFromMapping(userHintAttributes, scope, contextAttrs);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("(maybe, if configured) did Identity Hint Contract Fulfillment: " + userHintAttributes));
            }
            if (this.cibaHelper.isAttributeMissing(mappedAttributes = (hintContractToOOBAuthPluginMapping = requestHandlingPolicy.getHintContractToOOBAuthPluginMapping()).executeMapping(userHintAttributes, null, contextAttrs), "USER_KEY")) {
                throw this.reqErr(AccessTokenRequestException.Error.unknown_user_id, "Mapped attributes do not have a value for USER_KEY");
            }
            String userKey = mappedAttributes.getSingleValue("USER_KEY");
            AuditLogger.setUserName(userKey);
            locale = this.optionalLocaleOverrideFromMapping(userHintAttributes, locale, contextAttrs);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("got optional locale override from mapping: " + locale));
            }
            scope = this.optionalScopeOverrideFromMapping(userHintAttributes, scope, contextAttrs);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("got optional scope override from mapping: " + scope));
            }
            Map<String, String> scopesWithDescriptions = ScopeUtil.getDescriptionsForRequestedScope(requestCtx.getClient(), scope, locale);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("scopes with descriptions : " + scopesWithDescriptions));
            }
            Map<AuthorizationDetail, String> authorizationDetailsWithDescriptions = AuthorizationDetailsUtil.getDescriptions(authorizationDetails, req, clientId, scope);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("authorization details with descriptions : " + authorizationDetailsWithDescriptions));
            }
            this.augmentOrOverrideScopeDescriptionsFromMapping(mappedAttributes, scopesWithDescriptions);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("augmented scopes with descriptions : " + scopesWithDescriptions));
            }
            this.checkUserCode(requestCtx, client, requestHandlingPolicy, mappedAttributes);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("checked user code: " + requestCtx.getUserCode()));
            }
            if ((attributesForPlugin = this.cibaHelper.pareDown(mappedAttributes, pluginContract = this.cibaHelper.getPluginContract(requestHandlingPolicy))).isEmpty()) {
                throw this.reqErr(AccessTokenRequestException.Error.unknown_user_id, "Attributes mapped to initiate OOB auth plugin is an empty set.");
            }
            OOBAuthRequestContext oobAuthRequestContext = new OOBAuthRequestContext();
            oobAuthRequestContext.setUserAttributes(attributesForPlugin);
            oobAuthRequestContext.setUserAuthBindingMessage(bindingMessage);
            oobAuthRequestContext.setRequestedScope(scopesWithDescriptions);
            oobAuthRequestContext.setRequestedAuthorizationDetails(authorizationDetailsWithDescriptions);
            OOBAuthRequestContext.RequestingApplication requestingApp = new OOBAuthRequestContext.RequestingApplication();
            requestingApp.setId(clientId);
            requestingApp.setName(client.getName());
            requestingApp.setLogoUrl(client.getLogoUrl());
            oobAuthRequestContext.setRequestingApplication(requestingApp);
            oobAuthRequestContext.setLocale(locale);
            String[] authReqIds = this.cibaStateSupport.makeAuthReqIds(expiresAt, clientId);
            String authReqId = authReqIds[1];
            Map<String, String> inParams = Collections.singletonMap("ciba.auth_req_id", authReqId);
            boolean reuseConsent = this.authzServerMgr.isBypassAuthorizationForApprovedConsents();
            boolean granted = false;
            if (reuseConsent) {
                granted = this.oAuthConsentManager.isGranted(userKey, client.getClientId(), scope, authorizationDetails);
            }
            OOBAuthPlugin oobAuthPlugin = this.cibaHelper.getPlugin(requestHandlingPolicy);
            if (!granted) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("initiating OOBAuthPlugin transaction with " + oobAuthRequestContext));
                }
                OOBAuthTransactionContext txCtx = oobAuthPlugin.initiate(oobAuthRequestContext, inParams);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)(" OOBAuthPlugin transaction initiation returned " + txCtx));
                }
                if (txCtx == null) {
                    throw new ServerErrorException("OOBAuthPlugin returned null transaction context");
                }
                String ss = new Scope(scopesWithDescriptions.keySet()).getScopeStr();
                String txId = txCtx.getTransactionIdentifier();
                if (StringUtils.isBlank((String)txId)) {
                    throw new ServerErrorException("OOBAuthPlugin returned null or empty or blank transaction identifier");
                }
                AttributeMap grantAttributes = this.cibaHelper.pareDownToExtendedGrantAttributes(mappedAttributes);
                boolean statusChangeCallbackCapable = txCtx.isStatusChangeCallbackCapable();
                CibaState state = new CibaState(expiresAt, grantAttributes, clientNotificationToken, clientId, ss, txId, statusChangeCallbackCapable, authorizationDetails, false);
                this.cibaStateSupport.store(authReqIds, state);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("stored state w/ authReqId=" + authReqId + " & pluginTxId=" + txId + " & expiresIn=" + expiresIn));
                }
                this.cibaStateSupport.schedule(client, oobAuthPlugin, authReqId, state, expiresIn);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("scheduling finished w/ authReqId=" + authReqId + " & pluginTxId=" + txId + " & expiresIn=" + expiresIn));
                }
                outMsgCtx.setParam("auth_req_id", authReqId);
                outMsgCtx.setParam("interval", this.cibaHelper.getPollingInterval(client));
                outMsgCtx.setParam("expires_in", expiresIn);
                if (txCtx.getAuxiliaryParams() != null) {
                    outMsgCtx.getParams().putAll(txCtx.getAuxiliaryParams());
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("finishing with outbound context params: " + outMsgCtx.getParams()));
                }
            } else {
                AttributeMap grantAttributes = this.cibaHelper.pareDownToExtendedGrantAttributes(mappedAttributes);
                String ss = new Scope(scopesWithDescriptions.keySet()).getScopeStr();
                String txId = Base64Url.encode((byte[])ByteUtil.randomBytes((int)18));
                boolean statusChangeCallbackCapable = client.getCibaTokenDeliveryMode() == CibaDeliveryMode.ping;
                CibaState state = new CibaState(expiresAt, grantAttributes, clientNotificationToken, clientId, ss, txId, statusChangeCallbackCapable, authorizationDetails, true);
                this.cibaStateSupport.store(authReqIds, state);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("stored state w/ authReqId=" + authReqId + " & pluginTxId=" + txId + " & expiresIn=" + expiresIn));
                }
                outMsgCtx.setParam("auth_req_id", authReqId);
                outMsgCtx.setParam("interval", this.cibaHelper.getPollingInterval(client));
                outMsgCtx.setParam("expires_in", expiresIn);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("finishing with outbound context params: " + outMsgCtx.getParams()));
                }
                if (client.getCibaTokenDeliveryMode() == CibaDeliveryMode.ping) {
                    this.cibaStateSupport.statusChange(txId);
                }
            }
            AsAuditLogger.log("CIBA Auth Request");
        }
        catch (AttrLookupException e) {
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.unknown_user_id, e.getMessage(), e);
        }
        catch (AuthorizationException e) {
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.access_denied, e.getErrorDetail(), 403);
        }
        catch (UnknownUserException e) {
            String msg = e.isAllowMessagePropagation() ? e.getMessage() : "User could not be sufficiently identified to initiate out-of-band auth";
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.unknown_user_id, msg, e);
        }
        catch (UserAuthBindingMessageException e) {
            String msg = e.isAllowMessagePropagation() ? e.getMessage() : "The binding message is invalid or unacceptable for use in the context of the given request.";
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_binding_message, msg, e);
        }
        catch (OOBAuthGeneralException e) {
            ServerErrorException see = new ServerErrorException(e.getMessage());
            see.initCause(e);
            throw see;
        }
    }

    private void augmentOrOverrideScopeDescriptionsFromMapping(AttributeMap attributes, Map<String, String> scopesWithDescriptions) {
        AttributeValue scopeAttributeValue = (AttributeValue)attributes.get((Object)"REQUESTED_SCOPE_DESCRIPTIONS");
        if (scopeAttributeValue != null) {
            Object objectValue = scopeAttributeValue.getObjectValue();
            Map augmentedScopeDescriptions = Collections.emptyMap();
            if (objectValue instanceof Map) {
                augmentedScopeDescriptions = (Map)objectValue;
            } else if (objectValue instanceof String) {
                try {
                    String maybeJson = (String)objectValue;
                    augmentedScopeDescriptions = (Map)this.objectMapper.readValue(maybeJson, (TypeReference)new TypeReference<Map<String, Object>>(){});
                }
                catch (IOException e) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"Failed to parse JSON from value of REQUESTED_SCOPE_DESCRIPTIONS", (Throwable)e);
                    }
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(objectValue.getClass() + " value of REQUESTED_SCOPE_DESCRIPTIONS attribute not a String w/ JSON or a Map"));
            }
            for (Map.Entry e : augmentedScopeDescriptions.entrySet()) {
                Object value = e.getValue();
                if (!(value instanceof String) && value != null) continue;
                scopesWithDescriptions.put((String)e.getKey(), (String)value);
            }
        }
    }

    private Scope optionalScopeOverrideFromMapping(AttributeMap attributes, Scope scope, AttributeMap contextAttrs) {
        AttributeValue scopeAttributeValue = (AttributeValue)attributes.get((Object)"REQUESTED_SCOPE");
        if (scopeAttributeValue != null) {
            Collection valuesAsCollection = scopeAttributeValue.getValuesAsCollection();
            scope = new Scope(valuesAsCollection.toArray(new String[0]));
            contextAttrs.put(SourceContextType.OAUTH_SCOPES.getId(), new AttributeValue((Collection)scope.getScopeSet()));
        }
        return scope;
    }

    private Locale optionalLocaleOverrideFromMapping(AttributeMap attributes, Locale locale, AttributeMap contextAttrs) {
        String value;
        AttributeValue localeAttrValue = (AttributeValue)attributes.get((Object)"USER_LOCALE");
        if (localeAttrValue != null && (value = localeAttrValue.getValue()) != null) {
            locale = Locale.forLanguageTag(value);
            contextAttrs.put(SourceContextType.LOCALE.getId(), AttrValueSupport.make((Object)locale));
        }
        return locale;
    }

    private int getExpiresIn(CibaInMessageContext requestCtx, CibaServerPolicy.RequestHandlingPolicy requestHandlingPolicy) throws AccessTokenRequestException {
        int expiresIn = requestHandlingPolicy.getTransactionLifeInSeconds();
        String requestedExpiryString = requestCtx.getRequestedExpiry();
        if (requestedExpiryString != null) {
            int requestedExpiry;
            try {
                requestedExpiry = Integer.parseInt(requestedExpiryString);
            }
            catch (NumberFormatException e) {
                requestedExpiry = -1;
            }
            if (requestedExpiry <= 0) {
                throw this.reqErr(AccessTokenRequestException.Error.invalid_request, "requested_expiry has to be a positive integer");
            }
            expiresIn = Math.min(expiresIn, requestedExpiry);
        }
        return expiresIn;
    }

    private void checkUserCode(CibaInMessageContext requestCtx, Client client, CibaServerPolicy.RequestHandlingPolicy requestHandlingPolicy, AttributeMap mappedAttributes) throws AccessTokenRequestException {
        if (client.isCibaUserCodeSupported().booleanValue()) {
            boolean userCodeValid;
            String userCode;
            block12: {
                String pcvId = requestHandlingPolicy.getUserCodePcvId();
                if (StringUtils.isBlank((String)pcvId)) {
                    throw new ServerErrorException("Client is configured to support user code but server policy doesn't have a PCV configured to do the user code checking");
                }
                if (this.cibaHelper.isAttributeMissing(mappedAttributes, "USER_CODE_USER_NAME")) {
                    throw this.reqErr(AccessTokenRequestException.Error.unknown_user_id, "Mapped attributes do not have a value for USER_CODE_USER_NAME");
                }
                String username = mappedAttributes.getSingleValue("USER_CODE_USER_NAME");
                userCode = requestCtx.getUserCode();
                PasswordCredentialValidator pcv = this.pcvMgr.getValidator(pcvId);
                if (pcv == null) {
                    throw new ServerErrorException("Unable to get PCV " + pcvId + " for user code checking");
                }
                userCodeValid = false;
                try {
                    AttributeMap pcvResult = pcv.processPasswordCredential(username, userCode);
                    userCodeValid = pcvResult != null && !pcvResult.isEmpty();
                }
                catch (PasswordCredentialValidatorAuthnException e) {
                    if (AuthenticationResultEnum.USER_NOT_FOUND.getMessageKey().equals(e.getMessageKey())) {
                        throw new AccessTokenRequestException(AccessTokenRequestException.Error.unknown_user_id, "user_code check reported unrecognized user");
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("PCV (" + pcvId + ") threw PasswordCredentialValidatorAuthnException from user_code check " + e.getMessage()));
                    }
                }
                catch (PasswordValidationException e) {
                    if (!this.log.isDebugEnabled()) break block12;
                    this.log.debug((Object)("PCV (" + pcvId + ") threw PasswordValidationException from user_code check " + e.getMessage()));
                }
            }
            if (!userCodeValid) {
                throw new AccessTokenRequestException(userCode == null ? AccessTokenRequestException.Error.missing_user_code : AccessTokenRequestException.Error.invalid_user_code);
            }
        } else if (requestCtx.getUserCode() != null) {
            throw this.reqErr(AccessTokenRequestException.Error.invalid_request, "Client is not configured to support user code but a user_code was sent in the request.");
        }
    }

    AttributeMap rationalizeUserHints(CibaInMessageContext ctx, CibaServerPolicy.RequestHandlingPolicy requestHandlingPolicy, HttpServletRequest req) throws AccessTokenRequestException {
        AttributeMap userHintAttributes = ctx.getHintAttributes();
        String loginHint = ctx.getLoginHint();
        String loginHintToken = ctx.getLoginHintToken();
        String idTokenHint = ctx.getIdTokenHint();
        int count = 0;
        for (String prospectiveHint : new String[]{loginHint, loginHintToken, idTokenHint}) {
            count = prospectiveHint != null ? count + 1 : count;
        }
        if (count != 1) {
            throw this.reqErr(AccessTokenRequestException.Error.invalid_request, "Exactly one (not more, not less) of the hint parameters (i.e. 'login_hint_token', 'id_token_hint' or 'login_hint') must be provided.");
        }
        if (loginHint != null) {
            userHintAttributes.put("IDENTITY_HINT_SUBJECT", loginHint);
            userHintAttributes.put("login_hint", loginHint);
            if (requestHandlingPolicy.isRequireTokenForHint()) {
                throw this.reqErr(AccessTokenRequestException.Error.invalid_request, "Policy is set to require a token for the user hint but login_hint was sent.");
            }
        }
        Client client = ctx.getClient();
        if (loginHintToken != null) {
            try {
                DecryptionKeyResolver decryptionKeyResolver = (jwe, nestingContext) -> {
                    try {
                        KeyManagementAlgorithm algorithm = jwe.getAlgorithm();
                        KeyPersuasion keyPersuasion = algorithm.getKeyPersuasion();
                        if (keyPersuasion != KeyPersuasion.ASYMMETRIC) {
                            throw new UnresolvableKeyException("Only asymmetric encryption of the login_hint_token is supported (" + algorithm.getAlgorithmIdentifier() + " is " + keyPersuasion + ").");
                        }
                    }
                    catch (InvalidAlgorithmException e) {
                        throw new UnresolvableKeyException("Problem getting JWE key persuasion", (Throwable)e);
                    }
                    JwksDecryptionKeyResolver jwksDecryptionKeyResolver = new JwksDecryptionKeyResolver(this.jwkFacilitator.getEncryptionKeys());
                    return jwksDecryptionKeyResolver.resolveKey(jwe, nestingContext);
                };
                JwtConsumer firstPassJwtConsumer = new JwtConsumerBuilder().setSkipAllValidators().setDisableRequireSignature().setSkipSignatureVerification().setDecryptionKeyResolver(decryptionKeyResolver).setJweAlgorithmConstraints(JWE_ALGORITHM_CONSTRAINTS).setEnableLiberalContentTypeHandling().build();
                JwtContext jwtContext = firstPassJwtConsumer.process(loginHintToken);
                String issuer = jwtContext.getJwtClaims().getIssuer();
                ClientVerificationKeyResolver verificationKeyResolver = null;
                if (issuer == null || issuer.equals(client.getClientId())) {
                    verificationKeyResolver = new ClientVerificationKeyResolver(client, true, this.httpsJwksCache);
                } else {
                    for (CibaServerPolicy.RequestHandlingPolicy.AlternativeLoginHintTokenIssuer altIssuer : requestHandlingPolicy.getAlternativeLoginHintTokenIssuers()) {
                        if (!issuer.equals(altIssuer.getIssuer())) continue;
                        if (altIssuer.isJwksDataReference()) {
                            String url = altIssuer.getJwksData();
                            HttpsJwks httpsJwks = this.httpsJwksCache.getJwks(url);
                            verificationKeyResolver = new HttpsJwksVerificationKeyResolver(httpsJwks);
                            continue;
                        }
                        verificationKeyResolver = new JwksVerificationKeyResolver(altIssuer.getJsonWebKeys());
                    }
                }
                if (verificationKeyResolver == null) {
                    throw this.reqErr(AccessTokenRequestException.Error.invalid_request, "Unrecognized issuer in login_hint_token");
                }
                Set<String> audienceValues = this.oAuthAudienceUtils.getAudienceValues(req);
                JwtConsumerBuilder jwtConsumerBuilder = new JwtConsumerBuilder().setVerificationKeyResolver((VerificationKeyResolver)verificationKeyResolver).setDisableRequireSignature().setExpectedAudience(false, audienceValues.toArray(new String[0])).setAllowedClockSkewInSeconds(60);
                if (requestHandlingPolicy.isAllowUnsignedLoginHintToken()) {
                    jwtConsumerBuilder.setJwsAlgorithmConstraints(AlgorithmConstraints.NO_CONSTRAINTS);
                    jwtConsumerBuilder.setSkipVerificationKeyResolutionOnNone();
                } else {
                    jwtConsumerBuilder.setEnableRequireIntegrity();
                }
                JwtConsumer secondPassJwtConsumer = jwtConsumerBuilder.build();
                secondPassJwtConsumer.processContext(jwtContext);
                JwtClaims claims = jwtContext.getJwtClaims();
                String sub = claims.getSubject();
                if (sub != null) {
                    userHintAttributes.put("IDENTITY_HINT_SUBJECT", sub);
                }
                this.cibaHelper.processRequestHintTokenClaims("login_hint_token", userHintAttributes, claims);
            }
            catch (MalformedClaimException | InvalidJwtException e) {
                AccessTokenRequestException.Error errorCode = AccessTokenRequestException.Error.invalid_request;
                if (e instanceof InvalidJwtException && ((InvalidJwtException)e).hasExpired()) {
                    errorCode = AccessTokenRequestException.Error.expired_login_hint_token;
                }
                throw this.reqErr(errorCode, "login_hint_token: " + e.getMessage(), (Exception)e);
            }
        }
        if (idTokenHint != null) {
            MultiDecryptionKeyResolver decryptionKeyResolver = new MultiDecryptionKeyResolver(client.getSecretAsUtf8Bytes());
            List jwks = this.oAuthIssuerUtils.getIssuersJsonWebKeySet(req).getJsonWebKeys();
            JwksVerificationKeyResolver verificationKeyResolver = new JwksVerificationKeyResolver(jwks);
            JwtConsumerBuilder jwtConsumerBuilder = new JwtConsumerBuilder().setVerificationKeyResolver((VerificationKeyResolver)verificationKeyResolver).setDecryptionKeyResolver((DecryptionKeyResolver)decryptionKeyResolver).setJweAlgorithmConstraints(JWE_ALGORITHM_CONSTRAINTS).setExpectedAudience(new String[]{client.getClientId()}).setAllowedClockSkewInSeconds(Integer.MAX_VALUE).setEnableLiberalContentTypeHandling();
            try {
                JwtClaims claims = JwtProcessingUtils.processEncryptedJwt(idTokenHint, jwtConsumerBuilder, client, ClientSecretUtils.ActivityType.REQUEST_OBJ_DECRYPTION);
                if (claims == null) {
                    throw this.reqErr(AccessTokenRequestException.Error.invalid_request, "id_token_hint: Could not process id_token_hint jwt object", null);
                }
                String subject = claims.getSubject();
                if (client.isPairwiseUserType()) {
                    this.log.debug((Object)("Converting the PPID [" + subject + "] to a subject."));
                    try {
                        subject = this.pairwisePseudonymService.fromPPID(subject);
                    }
                    catch (PairwisePseudonymServiceException e) {
                        throw this.reqErr(AccessTokenRequestException.Error.server_error, "id_token_hint: There was an error when converting the PPID to a subject. ");
                    }
                }
                userHintAttributes.put("IDENTITY_HINT_SUBJECT", subject);
                this.cibaHelper.processRequestHintTokenClaims("id_token_hint", userHintAttributes, claims);
            }
            catch (MalformedClaimException | InvalidJwtException e) {
                throw this.reqErr(AccessTokenRequestException.Error.invalid_request, "id_token_hint: " + e.getMessage(), (Exception)e);
            }
        }
        this.log.debug((Object)("'rationalized' user hint info: " + userHintAttributes));
        return userHintAttributes;
    }

    private String getCheckBindingMessage(CibaInMessageContext ctx) throws AccessTokenRequestException {
        String bindingMessage = ctx.getBindingMessage();
        if (bindingMessage != null && !this.bindingMessageMatcher.matcher(bindingMessage).matches()) {
            throw this.reqErr(AccessTokenRequestException.Error.invalid_binding_message, this.invalidBindingMessageDescription);
        }
        return bindingMessage;
    }

    private String getCheckClientNotificationToken(CibaInMessageContext ctx) throws AccessTokenRequestException {
        String clientNotificationToken = ctx.getClientNotificationToken();
        Client client = ctx.getClient();
        if (clientNotificationToken == null) {
            if (client.getCibaTokenDeliveryMode() == CibaDeliveryMode.ping) {
                throw this.reqErr(AccessTokenRequestException.Error.invalid_request, "client_notification_token is required for clients configured to use the ping delivery mode.");
            }
        } else {
            if (client.getCibaTokenDeliveryMode() == CibaDeliveryMode.poll) {
                throw this.reqErr(AccessTokenRequestException.Error.invalid_request, "client_notification_token shouldn't be sent by clients configured to use the poll delivery mode.");
            }
            int maxLen = 1024;
            int length = clientNotificationToken.length();
            if (length > maxLen) {
                throw this.reqErr(AccessTokenRequestException.Error.invalid_request, "The length (" + length + ") of the client_notification_token must not exceed " + maxLen + " characters");
            }
            if (!this.b64tokenPattern.matcher(clientNotificationToken).matches()) {
                throw this.reqErr(AccessTokenRequestException.Error.invalid_request, "The client_notification_token must conform to the syntax for Bearer credentials as defined in Section 2.1 of RFC6750");
            }
        }
        return clientNotificationToken;
    }

    private Scope getCheckScope(CibaInMessageContext ctx) throws AccessTokenRequestException {
        Scope scope = Scope.getScope((String)ctx.getScope());
        if (!scope.hasScope("openid")) {
            throw this.reqErr(AccessTokenRequestException.Error.invalid_scope, "CIBA authentication requests MUST contain the openid scope value.");
        }
        try {
            ScopeUtil.validateRequestedScope(scope, ctx.getClient());
        }
        catch (InvalidRequestedScopeException e) {
            throw this.reqErr(AccessTokenRequestException.Error.invalid_scope, e.getMessage());
        }
        return scope;
    }

    private AuthorizationDetails getCheckAuthorizationDetails(CibaInMessageContext ctx, Client client, HttpServletRequest request, Scope scope) throws AccessTokenRequestException {
        AuthorizationDetails authorizationDetails;
        try {
            authorizationDetails = new AuthorizationDetails(ctx.getAuthorizationDetails());
            AuthorizationDetailsUtil.validate(authorizationDetails, client, request, scope);
        }
        catch (IOException | InvalidAuthorizationDetailException e) {
            throw this.reqErr(AccessTokenRequestException.Error.invalid_authorization_details, e.getMessage());
        }
        return authorizationDetails;
    }

    private AccessTokenRequestException reqErr(AccessTokenRequestException.Error error, String s, Exception cause) {
        return new AccessTokenRequestException(error, s, cause);
    }

    private AccessTokenRequestException reqErr(AccessTokenRequestException.Error error, String s) {
        return new AccessTokenRequestException(error, s);
    }

    @Override
    protected void handleEx(Exception e, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, Map<String, Object> stateParams, HttpServletRequest req, HttpServletResponse resp) {
        if (!(e instanceof AccessTokenRequestException)) {
            throw new ProcessRuntimeException("Unexpected error occurred handling CIBA request.", e);
        }
        BaseClientAuthnRequestHandler.errorCondition(resp, outMsgCtx, (AccessTokenRequestException)e, this.log, "CIBA Request", "AS");
    }

    @Override
    protected void handleException(HttpServletRequest req, HttpServletResponse resp, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, Map<String, Object> stateParams, Exception e) throws IOException {
        this.handleEx(e, inMsgCtx, outMsgCtx, stateParams, req, resp);
    }

    void setHttpsJwksCache(HttpsJwksCache httpsJwksCache) {
        this.httpsJwksCache = httpsJwksCache;
    }
}

